/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="changelog", aggregator=true)
public class ChangeLogMojo
extends AbstractScmMojo {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    @Parameter(property="startDate")
    private String startDate;
    @Parameter(property="endDate")
    private String endDate;
    @Parameter(property="startScmVersion")
    private String startScmVersion;
    @Parameter(property="endScmVersion")
    private String endScmVersion;
    @Parameter(property="startScmVersionType")
    private String startScmVersionType;
    @Parameter(property="endScmVersionType")
    private String endScmVersionType;
    @Parameter(property="dateFormat")
    private String dateFormat;
    @Parameter(property="userDateFormat", defaultValue="yyyy-MM-dd")
    private String userDateFormat = "yyyy-MM-dd";
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;
    @Parameter(property="scmBranch")
    private String scmBranch;
    @Parameter(property="limit")
    private Integer limit;
    @Parameter(property="numDays")
    private Integer numDays;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        SimpleDateFormat localFormat = new SimpleDateFormat(this.userDateFormat);
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            ChangeLogScmRequest request = new ChangeLogScmRequest(repository, this.getFileSet());
            request.setDatePattern(this.dateFormat);
            if (StringUtils.isNotEmpty((String)this.startDate)) {
                request.setStartDate(this.parseDate(localFormat, this.startDate));
            }
            if (StringUtils.isNotEmpty((String)this.endDate)) {
                request.setEndDate(this.parseDate(localFormat, this.endDate));
            }
            if (StringUtils.isNotEmpty((String)this.startScmVersion)) {
                ScmVersion startRev = this.getScmVersion(StringUtils.isEmpty((String)this.startScmVersionType) ? "revision" : this.startScmVersionType, this.startScmVersion);
                request.setStartRevision(startRev);
            }
            if (StringUtils.isNotEmpty((String)this.endScmVersion)) {
                ScmVersion endRev = this.getScmVersion(StringUtils.isEmpty((String)this.endScmVersionType) ? "revision" : this.endScmVersionType, this.endScmVersion);
                request.setEndRevision(endRev);
            }
            request.setLimit(this.limit);
            if (this.numDays != null) {
                request.setNumDays(this.numDays.intValue());
            }
            if (StringUtils.isNotEmpty((String)this.scmVersion)) {
                ScmVersion rev = this.getScmVersion(StringUtils.isEmpty((String)this.scmVersionType) ? "revision" : this.scmVersionType, this.scmVersion);
                request.setRevision(rev);
            }
            if (StringUtils.isNotEmpty((String)this.scmBranch)) {
                request.setScmBranch(new ScmBranch(this.scmBranch));
            }
            ChangeLogScmResult result = provider.changeLog(request);
            this.checkResult((ScmResult)result);
            ChangeLogSet changeLogSet = result.getChangeLog();
            for (ChangeSet changeSet : changeLogSet.getChangeSets()) {
                this.getLog().info((CharSequence)changeSet.toString());
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run changelog command : ", (Exception)e);
        }
    }

    private Date parseDate(SimpleDateFormat format, String date) throws MojoExecutionException {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        try {
            return format.parse(date.toString());
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Please use this date pattern: " + format.toLocalizedPattern().toString(), (Exception)e);
        }
    }
}

