/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scmpublish;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.scmpublish.AbstractScmPublishMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.MatchPatterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="publish-scm", aggregator=true, requiresProject=false)
public class ScmPublishPublishScmMojo
extends AbstractScmPublishMojo {
    @Parameter(property="scmpublish.content", defaultValue="${project.build.directory}/staging")
    private File content;
    @Component
    protected MavenProject project;
    private List<File> deleted = new ArrayList<File>();
    private List<File> added = new ArrayList<File>();
    private List<File> updated = new ArrayList<File>();
    private int directories = 0;
    private int files = 0;
    private long size = 0L;

    private void update(File checkout, File dir, List<String> doNotDeleteDirs) throws IOException {
        File file;
        String[] files = checkout.list((FilenameFilter)new NotFileFilter((IOFileFilter)new NameFileFilter(this.scmProvider.getScmSpecificFilename())));
        HashSet<String> checkoutContent = new HashSet<String>(Arrays.asList(files));
        List<String> dirContent = dir != null ? Arrays.asList(dir.list()) : Collections.emptyList();
        HashSet<String> deleted = new HashSet<String>(checkoutContent);
        deleted.removeAll(dirContent);
        MatchPatterns ignoreDeleteMatchPatterns = null;
        List<Object> pathsAsList = new ArrayList(0);
        if (this.ignorePathsToDelete != null && this.ignorePathsToDelete.length > 0) {
            ignoreDeleteMatchPatterns = MatchPatterns.from((String[])this.ignorePathsToDelete);
            pathsAsList = Arrays.asList(this.ignorePathsToDelete);
        }
        for (String name : deleted) {
            if (ignoreDeleteMatchPatterns != null && ignoreDeleteMatchPatterns.matches(name, true)) {
                this.getLog().debug((CharSequence)(name + " match one of the patterns '" + pathsAsList + "': do not add to deleted files"));
                continue;
            }
            this.getLog().debug((CharSequence)("file marked for deletion: " + name));
            file = new File(checkout, name);
            if (doNotDeleteDirs != null && file.isDirectory() && doNotDeleteDirs.contains(name)) continue;
            if (file.isDirectory()) {
                this.update(file, null, null);
            }
            this.deleted.add(file);
        }
        for (String name : dirContent) {
            file = new File(checkout, name);
            File source = new File(dir, name);
            if (source.isDirectory()) {
                ++this.directories;
                if (!checkoutContent.contains(name)) {
                    this.added.add(file);
                    file.mkdir();
                }
                this.update(file, source, null);
                continue;
            }
            if (checkoutContent.contains(name)) {
                this.updated.add(file);
            } else {
                this.added.add(file);
            }
            this.copyFile(source, file);
        }
    }

    private void copyFile(File srcFile, File destFile) throws IOException {
        if (this.requireNormalizeNewlines(srcFile)) {
            this.copyAndNormalizeNewlines(srcFile, destFile);
        } else {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        ++this.files;
        this.size += destFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAndNormalizeNewlines(File srcFile, File destFile) throws IOException {
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), this.siteOutputEncoding));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), this.siteOutputEncoding));
            while ((line = in.readLine()) != null) {
                if (in.ready()) {
                    out.println(line);
                    continue;
                }
                out.print(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        IOUtils.closeQuietly((Reader)in);
    }

    @Override
    public void scmPublishExecute() throws MojoExecutionException, MojoFailureException {
        if (this.siteOutputEncoding == null) {
            this.getLog().warn((CharSequence)"No output encoding, defaulting to UTF-8.");
            this.siteOutputEncoding = "utf-8";
        }
        if (!this.content.exists()) {
            throw new MojoExecutionException("Configured content directory does not exist: " + this.content);
        }
        if (!this.content.canRead()) {
            throw new MojoExecutionException("Can't read content directory: " + this.content);
        }
        this.checkoutExisting();
        try {
            this.logInfo("Updating checkout directory with actual content in %s", this.content);
            this.update(this.checkoutDirectory, this.content, this.project == null ? null : this.project.getModel().getModules());
            String displaySize = FileUtils.byteCountToDisplaySize((long)this.size);
            this.logInfo("Content consists in %d directories and %d files = %s", this.directories, this.files, displaySize);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy content to SCM checkout", (Exception)ioe);
        }
        this.logInfo("Publishing content into SCM will result in %d addition(s), %d update(s), %d delete(s)", this.added.size(), this.updated.size(), this.deleted.size());
        if (this.isDryRun()) {
            int pos = this.checkoutDirectory.getAbsolutePath().length() + 1;
            for (File addedFile : this.added) {
                this.logInfo("- addition %s", addedFile.getAbsolutePath().substring(pos));
            }
            for (File updatedFile : this.updated) {
                this.logInfo("- update   %s", updatedFile.getAbsolutePath().substring(pos));
            }
            for (File deletedFile : this.deleted) {
                this.logInfo("- delete   %s", deletedFile.getAbsolutePath().substring(pos));
            }
            return;
        }
        if (!this.added.isEmpty()) {
            this.addFiles(this.added);
        }
        if (!this.deleted.isEmpty()) {
            this.deleteFiles(this.deleted);
        }
        this.logInfo("Checking in SCM, starting at " + new Date() + "...", new Object[0]);
        this.checkinFiles();
    }
}

