/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.AbstractCompatibilityTransformer;

public class ApacheNoticeResourceTransformer
extends AbstractCompatibilityTransformer {
    Set<String> entries = new LinkedHashSet<String>();
    Map<String, Set<String>> organizationEntries = new LinkedHashMap<String, Set<String>>();
    String projectName = "";
    boolean addHeader = true;
    String preamble1 = "// ------------------------------------------------------------------\n// NOTICE file corresponding to the section 4d of The Apache License,\n// Version 2.0, in this case for ";
    String preamble2 = "\n// ------------------------------------------------------------------\n";
    String preamble3 = "This product includes software developed at\n";
    String organizationName = "The Apache Software Foundation";
    String organizationURL = "http://www.apache.org/";
    String inceptionYear = "2006";
    String copyright;
    String encoding;
    private long time = Long.MIN_VALUE;
    private static final String NOTICE_PATH = "META-INF/NOTICE";
    private static final String NOTICE_TXT_PATH = "META-INF/NOTICE.txt";
    private static final String NOTICE_MD_PATH = "META-INF/NOTICE.md";

    @Override
    public boolean canTransformResource(String resource) {
        return NOTICE_PATH.equalsIgnoreCase(resource) || NOTICE_TXT_PATH.equalsIgnoreCase(resource) || NOTICE_MD_PATH.equalsIgnoreCase(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        if (this.entries.isEmpty()) {
            String year = new SimpleDateFormat("yyyy").format(new Date());
            if (!this.inceptionYear.equals(year)) {
                year = this.inceptionYear + "-" + year;
            }
            if (this.addHeader) {
                this.entries.add(this.preamble1 + this.projectName + this.preamble2);
            } else {
                this.entries.add("");
            }
            this.entries.add(this.projectName + "\nCopyright " + year + " " + this.organizationName + "\n");
            this.entries.add(this.preamble3 + this.organizationName + " (" + this.organizationURL + ").\n");
        }
        BufferedReader reader = this.encoding != null && !this.encoding.isEmpty() ? new BufferedReader(new InputStreamReader(is, this.encoding)) : new BufferedReader(new InputStreamReader(is));
        String line = reader.readLine();
        StringBuilder sb = new StringBuilder();
        Set<String> currentOrg = null;
        int lineCount = 0;
        while (line != null) {
            String trimedLine = line.trim();
            if (!trimedLine.startsWith("//")) {
                if (trimedLine.length() > 0) {
                    if (trimedLine.startsWith("- ")) {
                        if (lineCount == 1 && sb.toString().contains("This product includes/uses software(s) developed by")) {
                            currentOrg = this.organizationEntries.get(sb.toString().trim());
                            if (currentOrg == null) {
                                currentOrg = new TreeSet<String>();
                                this.organizationEntries.put(sb.toString().trim(), currentOrg);
                            }
                            sb = new StringBuilder();
                        } else if (sb.length() > 0 && currentOrg != null) {
                            currentOrg.add(sb.toString());
                            sb = new StringBuilder();
                        }
                    }
                    sb.append(line).append("\n");
                    ++lineCount;
                } else {
                    String ent = sb.toString();
                    if (ent.startsWith(this.projectName) && ent.contains("Copyright ")) {
                        this.copyright = ent;
                    }
                    if (currentOrg == null) {
                        this.entries.add(ent);
                    } else {
                        currentOrg.add(ent);
                    }
                    sb = new StringBuilder();
                    lineCount = 0;
                    currentOrg = null;
                }
            }
            line = reader.readLine();
        }
        if (sb.length() > 0) {
            if (currentOrg == null) {
                this.entries.add(sb.toString());
            } else {
                currentOrg.add(sb.toString());
            }
        }
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        JarEntry jarEntry = new JarEntry(NOTICE_PATH);
        jarEntry.setTime(this.time);
        jos.putNextEntry(jarEntry);
        OutputStreamWriter writer = this.encoding != null && !this.encoding.isEmpty() ? new OutputStreamWriter((OutputStream)jos, this.encoding) : new OutputStreamWriter(jos);
        int count = 0;
        for (String line : this.entries) {
            if (line.equals(this.copyright) && ++count != 2) continue;
            if (count == 2 && this.copyright != null) {
                writer.write(this.copyright);
                ((Writer)writer).write(10);
            } else {
                writer.write(line);
                ((Writer)writer).write(10);
            }
            if (count != 3) continue;
            for (Map.Entry<String, Set<String>> entry : this.organizationEntries.entrySet()) {
                writer.write(entry.getKey());
                ((Writer)writer).write(10);
                for (String l : entry.getValue()) {
                    writer.write(l);
                }
                ((Writer)writer).write(10);
            }
        }
        ((Writer)writer).flush();
        this.entries.clear();
    }
}

