/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Writer;
import org.codehaus.plexus.util.IOUtil;

public class SiteDescriptorArtifactMetadata
extends AbstractArtifactMetadata {
    private final DecorationModel decoration;
    private final File file;

    public SiteDescriptorArtifactMetadata(Artifact artifact, DecorationModel decoration, File file) {
        super(artifact);
        this.file = file;
        this.decoration = decoration;
    }

    public String getRemoteFilename() {
        return this.getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.getArtifactId() + "-" + this.artifact.getVersion() + "-" + this.file.getName();
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)this, remoteRepository));
        destination.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(destination);
            new DecorationXpp3Writer().write((Writer)writer, this.decoration);
        }
        catch (IOException e) {
            try {
                throw new RepositoryMetadataStoreException("Error saving in local repository", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public String toString() {
        return "site descriptor for " + this.artifact.getArtifactId() + " " + this.artifact.getVersion() + " " + this.file.getName();
    }

    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    public Object getKey() {
        return "site descriptor " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + " " + this.file.getName();
    }

    public void merge(ArtifactMetadata metadata) {
        SiteDescriptorArtifactMetadata m = (SiteDescriptorArtifactMetadata)metadata;
        if (!m.file.equals(this.file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }
}

