/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.SiteDescriptorArtifactMetadata;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SiteDescriptorAttachMojo
extends AbstractSiteMojo {
    private Artifact artifact;
    private File basedir;

    public void execute() throws MojoExecutionException {
        List localesList = this.getAvailableLocales();
        Iterator iterator = localesList.iterator();
        while (iterator.hasNext()) {
            DecorationModel decoration;
            Locale locale = (Locale)iterator.next();
            File descriptorFile = this.getSiteDescriptorFile(this.basedir, locale);
            if (!descriptorFile.exists()) continue;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("reports", "<menu ref=\"reports\"/>");
            props.put("modules", "<menu ref=\"modules\"/>");
            try {
                String siteDescriptorContent = FileUtils.fileRead((File)descriptorFile);
                siteDescriptorContent = this.getInterpolatedSiteDescriptorContent(props, this.project, siteDescriptorContent);
                decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
            }
            MavenProject parentProject = this.getParentProject(this.project);
            if (parentProject != null && this.project.getUrl() != null && parentProject.getUrl() != null) {
                this.populateProjectParentMenu(decoration, locale, parentProject, true);
            }
            this.populateModules(decoration, locale, true);
            this.artifact.addMetadata((ArtifactMetadata)new SiteDescriptorArtifactMetadata(this.artifact, decoration, descriptorFile));
        }
    }
}

