/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.SiteDeployMojo;
import org.apache.maven.plugins.site.SiteStageMojo;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class SiteStageDeployMojo
extends SiteStageMojo {
    private String stagingSiteURL;
    private WagonManager wagonManager;
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.deployStagingSite();
    }

    private void deployStagingSite() throws MojoExecutionException, MojoFailureException {
        Wagon wagon;
        String id = "stagingSite";
        Repository repository = new Repository(id, this.stagingSiteURL);
        try {
            wagon = this.wagonManager.getWagon(repository.getProtocol());
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        try {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
            ProxyInfo proxyInfo = SiteDeployMojo.getProxyInfo(this.settings);
            if (proxyInfo != null) {
                wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id), proxyInfo);
            } else {
                wagon.connect(repository, this.wagonManager.getAuthenticationInfo(id));
            }
            wagon.putDirectory(new File(this.stagingDirectory, SiteStageMojo.getStructure(this.project, false)), ".");
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }
}

