package org.apache.maven.plugins.site;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-site-plugin. Call <pre>  mvn site:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Jun 26 20:41:36 CEST 2008
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-site-plugin:2.0-beta-7", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Site Plugin 2.0-beta-7", 0 );
        append( sb, "The Maven Site Plugin is a plugin that generates a site for the current project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 8 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "attach-descriptor".equals( goal ) )
        {
            append( sb, "site:attach-descriptor", 0 );
            append( sb, "Adds the site descriptor to the list of files to be installed/deployed.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "deploy".equals( goal ) )
        {
            append( sb, "site:deploy", 0 );
            append( sb, "Deploys the generated site using scp or file protocol to the site specified in the <distributionManagement> section of the POM.\nFor scp protocol, the website files are packaged into zip archive, then the archive is transfered to the remote host, next it is un-archived. This method of deployment should normally be much faster than making a file by file copy. For file protocol, the files are copied directly to the destination directory.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "inputDirectory", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "site:help", 0 );
            append( sb, "Display help information on maven-site-plugin. Call\n\u00a0\u00a0mvn\u00a0site:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jar".equals( goal ) )
        {
            append( sb, "site:jar", 0 );
            append( sb, "Bundles the site output into a jar so that it can be deployed to a repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project.", 3 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that \'-site\' will be appended to the file name.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory", 2 );
                append( sb, "Directory containing generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n<moduleExcludes>\n<moduleType>filename1.ext,**/*sample.ext</moduleType>\n<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0-->\n<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0-->\n<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0-->\n<xdoc>changes.xml,navigation.xml</xdoc>\n</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Default template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run".equals( goal ) )
        {
            append( sb, "site:run", 0 );
            append( sb, "Starts the site up, rendering documents as requested for faster editing. It uses Jetty as the web server.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory", 2 );
                append( sb, "Directory containing generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n<moduleExcludes>\n<moduleType>filename1.ext,**/*sample.ext</moduleType>\n<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0-->\n<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0-->\n<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0-->\n<xdoc>changes.xml,navigation.xml</xdoc>\n</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port to execute the HTTP server on.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "tempWebappDirectory", 2 );
                append( sb, "Where to create the dummy web application.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Default template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "site".equals( goal ) )
        {
            append( sb, "site:site", 0 );
            append( sb, "Generates the site for a single project.\nNote that links between module sites in a multi module build will not work.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory", 2 );
                append( sb, "Directory containing generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n<moduleExcludes>\n<moduleType>filename1.ext,**/*sample.ext</moduleType>\n<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0-->\n<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0-->\n<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0-->\n<xdoc>changes.xml,navigation.xml</xdoc>\n</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Default template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stage".equals( goal ) )
        {
            append( sb, "site:stage", 0 );
            append( sb, "Generates a site in a local staging or mock directory based on the site url specified in the <distributionManagement> section of the POM.\nIt can be used to test that links between module sites in a multi module build works.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory", 2 );
                append( sb, "Directory containing generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n<moduleExcludes>\n<moduleType>filename1.ext,**/*sample.ext</moduleType>\n<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0-->\n<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0-->\n<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0-->\n<xdoc>changes.xml,navigation.xml</xdoc>\n</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "stagingDirectory", 2 );
                append( sb, "Staging directory location. This needs to be an absolute path, like C:\\stagingArea\\myProject\\ on Windows or /stagingArea/myProject/ on Unix.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Default template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stage-deploy".equals( goal ) )
        {
            append( sb, "site:stage-deploy", 0 );
            append( sb, "Deploys the generated site to a staging or mock directory on the site specified in the <distributionManagement> section of the POM. It also supports scp and file protocols for deployment.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory", 2 );
                append( sb, "Directory containing generated documentation.", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "The local repository.", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n<moduleExcludes>\n<moduleType>filename1.ext,**/*sample.ext</moduleType>\n<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0-->\n<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0-->\n<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0-->\n<xdoc>changes.xml,navigation.xml</xdoc>\n</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ISO-8859-1)", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "", 0 );

                append( sb, "repositories", 2 );
                append( sb, "Remote repositories used for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "stagingDirectory", 2 );
                append( sb, "Staging directory location. This needs to be an absolute path, like C:\\stagingArea\\myProject\\ on Windows or /stagingArea/myProject/ on Unix.", 3 );
                append( sb, "", 0 );

                append( sb, "stagingSiteURL", 2 );
                append( sb, "The staged site will be deployed to this URL. If you don\'t specify this, the default-value will be \'${project.distributionManagement.site.url}/staging\', where \'project\' is either the current project or, in a reactor build, the top level project in the reactor.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Default template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
