/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.util.PathSet;
import org.codehaus.plexus.util.FileUtils;

public class OverlayPackagingTask
extends AbstractWarPackagingTask {
    private final Overlay overlay;

    public OverlayPackagingTask(Overlay overlay, Overlay currentProjectOverlay) {
        if (overlay == null) {
            throw new NullPointerException("overlay could not be null.");
        }
        if (overlay.equals(currentProjectOverlay)) {
            throw new IllegalStateException("Could not handle the current project with this task.");
        }
        this.overlay = overlay;
    }

    public void performPackaging(WarPackagingContext context) throws MojoExecutionException {
        context.getLog().debug((CharSequence)("OverlayPackagingTask performPackaging overlay.getTargetPath() " + this.overlay.getTargetPath()));
        if (this.overlay.shouldSkip()) {
            context.getLog().info((CharSequence)("Skipping overlay [" + this.overlay + "]"));
        } else {
            try {
                context.getLog().info((CharSequence)("Processing overlay [" + this.overlay + "]"));
                File tmpDir = this.unpackOverlay(context, this.overlay);
                PathSet includes = this.getFilesToIncludes(tmpDir, this.overlay.getIncludes(), this.overlay.getExcludes());
                if (null == this.overlay.getTargetPath()) {
                    this.copyFiles(this.overlay.getId(), context, tmpDir, includes, this.overlay.isFiltered());
                } else {
                    String targetPath = this.overlay.getTargetPath();
                    if (!targetPath.endsWith("/")) {
                        targetPath = targetPath + "/";
                    }
                    this.copyFiles(this.overlay.getId(), context, tmpDir, includes, targetPath, this.overlay.isFiltered());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy file for overlay [" + this.overlay + "]", (Exception)e);
            }
        }
    }

    protected File unpackOverlay(WarPackagingContext context, Overlay overlay) throws MojoExecutionException {
        File tmpDir = this.getOverlayTempDirectory(context, overlay);
        if (FileUtils.sizeOfDirectory((File)tmpDir) == 0L || overlay.getArtifact().getFile().lastModified() > tmpDir.lastModified()) {
            this.doUnpack(context, overlay.getArtifact().getFile(), tmpDir);
        } else {
            context.getLog().debug((CharSequence)("Overlay [" + overlay + "] was already unpacked"));
        }
        return tmpDir;
    }

    protected File getOverlayTempDirectory(WarPackagingContext context, Overlay overlay) {
        File result;
        File groupIdDir = new File(context.getOverlaysWorkDirectory(), overlay.getGroupId());
        if (!groupIdDir.exists()) {
            groupIdDir.mkdir();
        }
        String directoryName = overlay.getArtifactId();
        if (overlay.getClassifier() != null) {
            directoryName = directoryName + "-" + overlay.getClassifier();
        }
        if (!(result = new File(groupIdDir, directoryName)).exists()) {
            result.mkdirs();
        }
        return result;
    }
}

