/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.wrapper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;

@Mojo(name="wrapper", aggregator=true, requiresDirectInvocation=true)
public class WrapperMojo
extends AbstractMojo {
    private static final String MVNW_REPOURL = "MVNW_REPOURL";
    private static final String DEFAULT_REPOURL = "https://repo.maven.apache.org/maven2";
    @Parameter(property="maven")
    private String mavenVersion;
    @Parameter(defaultValue="bin", property="type")
    private String distributionType;
    @Parameter(defaultValue="false", property="includeDebug")
    private boolean includeDebugScript;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    private File basedir;
    private static final String WRAPPER_DISTRIBUTION_GROUP_ID = "org.apache.maven.wrapper";
    private static final String WRAPPER_DISTRIBUTION_ARTIFACT_ID = "maven-wrapper-distribution";
    private static final String WRAPPER_DISTRIBUTION_EXTENSION = "zip";
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private Map<String, UnArchiver> unarchivers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.mavenVersion = this.getVersion(this.mavenVersion, Maven.class, "org.apache.maven/maven-core");
        String wrapperVersion = this.getVersion(null, ((Object)((Object)this)).getClass(), "org.apache.maven.plugins/maven-wrapper-plugin");
        Artifact artifact = this.downloadWrapperDistribution(wrapperVersion);
        Path wrapperDir = this.createDirectories(this.basedir.toPath().resolve(".mvn/wrapper"));
        this.cleanup(wrapperDir);
        this.unpack(artifact, this.basedir.toPath());
        this.replaceProperties(wrapperVersion, wrapperDir);
    }

    private Path createDirectories(Path dir) throws MojoExecutionException {
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private void cleanup(Path wrapperDir) throws MojoExecutionException {
        try (DirectoryStream<Path> dsClass = Files.newDirectoryStream(wrapperDir, "*.class");){
            for (Path file : dsClass) {
                Files.deleteIfExists(file);
            }
            Files.deleteIfExists(wrapperDir.resolve("MavenWrapperDownloader.java"));
            Files.deleteIfExists(wrapperDir.resolve("maven-wrapper.jar"));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    private Artifact downloadWrapperDistribution(String wrapperVersion) throws MojoExecutionException {
        Artifact artifact = this.repositorySystem.createArtifactWithClassifier(WRAPPER_DISTRIBUTION_GROUP_ID, WRAPPER_DISTRIBUTION_ARTIFACT_ID, wrapperVersion, WRAPPER_DISTRIBUTION_EXTENSION, this.distributionType);
        MavenExecutionRequest executionRequest = this.session.getRequest();
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getPluginArtifactRepositories()).setOffline(executionRequest.isOffline()).setForceUpdate(executionRequest.isUpdateSnapshots());
        ArtifactResolutionResult resolveResult = this.repositorySystem.resolve(resolutionRequest);
        if (!resolveResult.isSuccess()) {
            if (executionRequest.isShowErrors()) {
                for (Exception e : resolveResult.getExceptions()) {
                    this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            throw new MojoExecutionException("artifact: " + artifact + " not resolved.");
        }
        return artifact;
    }

    private void unpack(Artifact artifact, Path targetFolder) {
        UnArchiver unarchiver = this.unarchivers.get(WRAPPER_DISTRIBUTION_EXTENSION);
        unarchiver.setDestDirectory(targetFolder.toFile());
        unarchiver.setSourceFile(artifact.getFile());
        if (!this.includeDebugScript) {
            unarchiver.setFileSelectors(new FileSelector[]{new FileSelector(){

                public boolean isSelected(FileInfo fileInfo) {
                    return !fileInfo.getName().contains("Debug");
                }
            }});
        }
        unarchiver.extract();
        this.getLog().info((CharSequence)("Unpacked " + MessageUtils.buffer().strong((Object)this.distributionType) + " type wrapper distribution " + artifact));
    }

    private void replaceProperties(String wrapperVersion, Path targetFolder) throws MojoExecutionException {
        String repoUrl = this.getRepoUrl();
        String distributionUrl = repoUrl + "/org/apache/maven/apache-maven/" + this.mavenVersion + "/apache-maven-" + this.mavenVersion + "-bin.zip";
        String wrapperUrl = repoUrl + "/org/apache/maven/wrapper/maven-wrapper/" + wrapperVersion + "/maven-wrapper-" + wrapperVersion + ".jar";
        Path wrapperPropertiesFile = targetFolder.resolve("maven-wrapper.properties");
        this.getLog().info((CharSequence)("Configuring .mvn/wrapper/maven-wrapper.properties to use " + MessageUtils.buffer().strong((Object)("Maven " + this.mavenVersion)) + " and download from " + repoUrl));
        String license = "# Licensed to the Apache Software Foundation (ASF) under one%n# or more contributor license agreements.  See the NOTICE file%n# distributed with this work for additional information%n# regarding copyright ownership.  The ASF licenses this file%n# to you under the Apache License, Version 2.0 (the%n# \"License\"); you may not use this file except in compliance%n# with the License.  You may obtain a copy of the License at%n#%n#   https://www.apache.org/licenses/LICENSE-2.0%n#%n# Unless required by applicable law or agreed to in writing,%n# software distributed under the License is distributed on an%n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY%n# KIND, either express or implied.  See the License for the%n# specific language governing permissions and limitations%n# under the License.%n";
        try (BufferedWriter out = Files.newBufferedWriter(wrapperPropertiesFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.append(String.format(Locale.ROOT, "# Licensed to the Apache Software Foundation (ASF) under one%n# or more contributor license agreements.  See the NOTICE file%n# distributed with this work for additional information%n# regarding copyright ownership.  The ASF licenses this file%n# to you under the Apache License, Version 2.0 (the%n# \"License\"); you may not use this file except in compliance%n# with the License.  You may obtain a copy of the License at%n#%n#   https://www.apache.org/licenses/LICENSE-2.0%n#%n# Unless required by applicable law or agreed to in writing,%n# software distributed under the License is distributed on an%n# \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY%n# KIND, either express or implied.  See the License for the%n# specific language governing permissions and limitations%n# under the License.%n", new Object[0]));
            out.append("distributionUrl=" + distributionUrl + System.lineSeparator());
            out.append("wrapperUrl=" + wrapperUrl + System.lineSeparator());
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Can't create maven-wrapper.properties", (Exception)ioe);
        }
    }

    private String getVersion(String defaultVersion, Class<?> clazz, String path) {
        String version = defaultVersion;
        if (version == null) {
            Properties props = new Properties();
            try (InputStream is = clazz.getResourceAsStream("/META-INF/maven/" + path + "/pom.properties");){
                if (is != null) {
                    props.load(is);
                    version = props.getProperty("version");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }

    private String getRepoUrl() {
        String repoUrl = DEFAULT_REPOURL;
        String mvnwRepoUrl = System.getenv(MVNW_REPOURL);
        if (mvnwRepoUrl != null && !mvnwRepoUrl.isEmpty()) {
            repoUrl = mvnwRepoUrl;
            this.getLog().debug((CharSequence)"Using repo URL from MVNW_REPOURL environment variable.");
        } else if (this.settings.getMirrors() != null && !this.settings.getMirrors().isEmpty()) {
            for (Mirror current : this.settings.getMirrors()) {
                if (!"*".equals(current.getMirrorOf())) continue;
                repoUrl = current.getUrl();
                break;
            }
            this.getLog().debug((CharSequence)"Using repo URL from * mirror in settings file.");
        }
        this.getLog().debug((CharSequence)("Determined repo URL to use as " + repoUrl));
        return repoUrl;
    }
}

