/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Scm;
import org.apache.maven.shared.release.config.ReleaseStageVersions;
import org.apache.maven.shared.release.scm.IdentifiedScm;

public class ModelloReleaseDescriptor
implements Serializable {
    private String name;
    private String description;
    private String ScmCommentPrefix = "[maven-release-manager] ";
    private boolean scmShallowClone = true;
    private String scmReleaseCommitComment = "@{prefix} prepare release @{releaseLabel}";
    private String scmDevelopmentCommitComment = "@{prefix} prepare for next development iteration";
    private String scmBranchCommitComment = "@{prefix} prepare branch @{releaseLabel}";
    private String scmRollbackCommitComment = "@{prefix} rollback the release of @{releaseLabel}";
    private String scmSourceUrl;
    private String scmTagBase;
    private String scmBranchBase;
    private String scmReleaseLabel;
    private String scmId;
    private String scmUsername;
    private String scmPassword;
    private String scmPrivateKey;
    private String scmPrivateKeyPassPhrase;
    private boolean scmUseEditMode = false;
    private String scmRelativePathProjectDirectory;
    private boolean updateDependencies = true;
    private boolean useReleaseProfile = true;
    private List<String> activateProfiles;
    private String workingDirectory;
    private String checkoutDirectory = "target/checkout";
    private String completedPhase;
    private boolean addSchema = false;
    private boolean generateReleasePoms = false;
    private boolean autoVersionSubmodules = false;
    private boolean interactive = true;
    private boolean snapshotReleasePluginAllowed = false;
    private String additionalArguments;
    private String pomFileName;
    private List<String> checkModificationExcludes;
    private String preparationGoals;
    private String completionGoals;
    private String performGoals;
    private boolean commitByProject = false;
    private boolean branchCreation = false;
    private boolean updateBranchVersions = false;
    private boolean updateWorkingCopyVersions = true;
    private boolean updateVersionsToSnapshot = false;
    private boolean suppressCommitBeforeTagOrBranch = false;
    private int waitBeforeTagging = 0;
    private boolean allowTimestampedSnapshots = false;
    private String defaultReleaseVersion;
    private String defaultDevelopmentVersion;
    private String projectVersionPolicyId = "default";
    private String projectNamingPolicyId;
    private String releaseStrategyId = "default";
    private boolean remoteTagging = false;
    private String scmReleasedPomRevision;
    private boolean pushChanges = true;
    private boolean localCheckout = false;
    private String scmTagNameFormat;
    private String workItem;
    private String autoResolveSnapshots;
    private boolean pinExternals = false;
    private boolean scmSignTags = false;
    private String lineSeparator;
    private String modelEncoding = "UTF-8";
    private Map<String, ReleaseStageVersions> resolvedSnapshotDependencies = new HashMap<String, ReleaseStageVersions>();
    private Map<String, ReleaseStageVersions> projectVersions = new HashMap<String, ReleaseStageVersions>();
    private Map<String, Scm> originalScmInfo = new HashMap<String, Scm>();

    public void addActivateProfile(String string) {
        this.getActivateProfiles().add(string);
    }

    public void addCheckModificationExclude(String string) {
        this.getCheckModificationExcludes().add(string);
    }

    public List<String> getActivateProfiles() {
        if (this.activateProfiles == null) {
            this.activateProfiles = new ArrayList<String>();
        }
        return this.activateProfiles;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public String getAutoResolveSnapshots() {
        return this.autoResolveSnapshots;
    }

    public List<String> getCheckModificationExcludes() {
        if (this.checkModificationExcludes == null) {
            this.checkModificationExcludes = new ArrayList<String>();
        }
        return this.checkModificationExcludes;
    }

    public String getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public String getCompletedPhase() {
        return this.completedPhase;
    }

    public String getCompletionGoals() {
        return this.completionGoals;
    }

    public String getDefaultDevelopmentVersion() {
        return this.defaultDevelopmentVersion;
    }

    public String getDefaultReleaseVersion() {
        return this.defaultReleaseVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getName() {
        return this.name;
    }

    public String getPerformGoals() {
        return this.performGoals;
    }

    public String getPomFileName() {
        return this.pomFileName;
    }

    public String getPreparationGoals() {
        return this.preparationGoals;
    }

    public String getProjectNamingPolicyId() {
        return this.projectNamingPolicyId;
    }

    public String getProjectVersionPolicyId() {
        return this.projectVersionPolicyId;
    }

    public String getReleaseStrategyId() {
        return this.releaseStrategyId;
    }

    public String getScmBranchBase() {
        return this.scmBranchBase;
    }

    public String getScmBranchCommitComment() {
        return this.scmBranchCommitComment;
    }

    public String getScmCommentPrefix() {
        return this.ScmCommentPrefix;
    }

    public String getScmDevelopmentCommitComment() {
        return this.scmDevelopmentCommitComment;
    }

    public String getScmId() {
        return this.scmId;
    }

    public String getScmPassword() {
        return this.scmPassword;
    }

    public String getScmPrivateKey() {
        return this.scmPrivateKey;
    }

    public String getScmPrivateKeyPassPhrase() {
        return this.scmPrivateKeyPassPhrase;
    }

    public String getScmRelativePathProjectDirectory() {
        return this.scmRelativePathProjectDirectory;
    }

    public String getScmReleaseCommitComment() {
        return this.scmReleaseCommitComment;
    }

    public String getScmReleaseLabel() {
        return this.scmReleaseLabel;
    }

    public String getScmReleasedPomRevision() {
        return this.scmReleasedPomRevision;
    }

    public String getScmRollbackCommitComment() {
        return this.scmRollbackCommitComment;
    }

    public String getScmSourceUrl() {
        return this.scmSourceUrl;
    }

    public String getScmTagBase() {
        return this.scmTagBase;
    }

    public String getScmTagNameFormat() {
        return this.scmTagNameFormat;
    }

    public String getScmUsername() {
        return this.scmUsername;
    }

    public int getWaitBeforeTagging() {
        return this.waitBeforeTagging;
    }

    public String getWorkItem() {
        return this.workItem;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isAddSchema() {
        return this.addSchema;
    }

    public boolean isAllowTimestampedSnapshots() {
        return this.allowTimestampedSnapshots;
    }

    public boolean isAutoVersionSubmodules() {
        return this.autoVersionSubmodules;
    }

    public boolean isBranchCreation() {
        return this.branchCreation;
    }

    public boolean isCommitByProject() {
        return this.commitByProject;
    }

    public boolean isGenerateReleasePoms() {
        return this.generateReleasePoms;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isLocalCheckout() {
        return this.localCheckout;
    }

    public boolean isPinExternals() {
        return this.pinExternals;
    }

    public boolean isPushChanges() {
        return this.pushChanges;
    }

    public boolean isRemoteTagging() {
        return this.remoteTagging;
    }

    public boolean isScmShallowClone() {
        return this.scmShallowClone;
    }

    public boolean isScmSignTags() {
        return this.scmSignTags;
    }

    public boolean isScmUseEditMode() {
        return this.scmUseEditMode;
    }

    public boolean isSnapshotReleasePluginAllowed() {
        return this.snapshotReleasePluginAllowed;
    }

    public boolean isSuppressCommitBeforeTagOrBranch() {
        return this.suppressCommitBeforeTagOrBranch;
    }

    public boolean isUpdateBranchVersions() {
        return this.updateBranchVersions;
    }

    public boolean isUpdateDependencies() {
        return this.updateDependencies;
    }

    public boolean isUpdateVersionsToSnapshot() {
        return this.updateVersionsToSnapshot;
    }

    public boolean isUpdateWorkingCopyVersions() {
        return this.updateWorkingCopyVersions;
    }

    public boolean isUseReleaseProfile() {
        return this.useReleaseProfile;
    }

    public void removeActivateProfile(String string) {
        this.getActivateProfiles().remove(string);
    }

    public void removeCheckModificationExclude(String string) {
        this.getCheckModificationExcludes().remove(string);
    }

    public void setActivateProfiles(List<String> activateProfiles) {
        this.activateProfiles = activateProfiles;
    }

    public void setAddSchema(boolean addSchema) {
        this.addSchema = addSchema;
    }

    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public void setAllowTimestampedSnapshots(boolean allowTimestampedSnapshots) {
        this.allowTimestampedSnapshots = allowTimestampedSnapshots;
    }

    public void setAutoResolveSnapshots(String autoResolveSnapshots) {
        this.autoResolveSnapshots = autoResolveSnapshots;
    }

    public void setAutoVersionSubmodules(boolean autoVersionSubmodules) {
        this.autoVersionSubmodules = autoVersionSubmodules;
    }

    public void setBranchCreation(boolean branchCreation) {
        this.branchCreation = branchCreation;
    }

    public void setCheckModificationExcludes(List<String> checkModificationExcludes) {
        this.checkModificationExcludes = checkModificationExcludes;
    }

    public void setCheckoutDirectory(String checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public void setCommitByProject(boolean commitByProject) {
        this.commitByProject = commitByProject;
    }

    public void setCompletedPhase(String completedPhase) {
        this.completedPhase = completedPhase;
    }

    public void setCompletionGoals(String completionGoals) {
        this.completionGoals = completionGoals;
    }

    public void setDefaultDevelopmentVersion(String defaultDevelopmentVersion) {
        this.defaultDevelopmentVersion = defaultDevelopmentVersion;
    }

    public void setDefaultReleaseVersion(String defaultReleaseVersion) {
        this.defaultReleaseVersion = defaultReleaseVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGenerateReleasePoms(boolean generateReleasePoms) {
        this.generateReleasePoms = generateReleasePoms;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setLocalCheckout(boolean localCheckout) {
        this.localCheckout = localCheckout;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPerformGoals(String performGoals) {
        this.performGoals = performGoals;
    }

    public void setPinExternals(boolean pinExternals) {
        this.pinExternals = pinExternals;
    }

    public void setPomFileName(String pomFileName) {
        this.pomFileName = pomFileName;
    }

    public void setPreparationGoals(String preparationGoals) {
        this.preparationGoals = preparationGoals;
    }

    public void setProjectNamingPolicyId(String projectNamingPolicyId) {
        this.projectNamingPolicyId = projectNamingPolicyId;
    }

    public void setProjectVersionPolicyId(String projectVersionPolicyId) {
        this.projectVersionPolicyId = projectVersionPolicyId;
    }

    public void setPushChanges(boolean pushChanges) {
        this.pushChanges = pushChanges;
    }

    public void setReleaseStrategyId(String releaseStrategyId) {
        this.releaseStrategyId = releaseStrategyId;
    }

    public void setRemoteTagging(boolean remoteTagging) {
        this.remoteTagging = remoteTagging;
    }

    public void setScmBranchBase(String scmBranchBase) {
        this.scmBranchBase = scmBranchBase;
    }

    public void setScmBranchCommitComment(String scmBranchCommitComment) {
        this.scmBranchCommitComment = scmBranchCommitComment;
    }

    public void setScmCommentPrefix(String ScmCommentPrefix) {
        this.ScmCommentPrefix = ScmCommentPrefix;
    }

    public void setScmDevelopmentCommitComment(String scmDevelopmentCommitComment) {
        this.scmDevelopmentCommitComment = scmDevelopmentCommitComment;
    }

    public void setScmId(String scmId) {
        this.scmId = scmId;
    }

    public void setScmPassword(String scmPassword) {
        this.scmPassword = scmPassword;
    }

    public void setScmPrivateKey(String scmPrivateKey) {
        this.scmPrivateKey = scmPrivateKey;
    }

    public void setScmPrivateKeyPassPhrase(String scmPrivateKeyPassPhrase) {
        this.scmPrivateKeyPassPhrase = scmPrivateKeyPassPhrase;
    }

    public void setScmRelativePathProjectDirectory(String scmRelativePathProjectDirectory) {
        this.scmRelativePathProjectDirectory = scmRelativePathProjectDirectory;
    }

    public void setScmReleaseCommitComment(String scmReleaseCommitComment) {
        this.scmReleaseCommitComment = scmReleaseCommitComment;
    }

    public void setScmReleaseLabel(String scmReleaseLabel) {
        this.scmReleaseLabel = scmReleaseLabel;
    }

    public void setScmReleasedPomRevision(String scmReleasedPomRevision) {
        this.scmReleasedPomRevision = scmReleasedPomRevision;
    }

    public void setScmRollbackCommitComment(String scmRollbackCommitComment) {
        this.scmRollbackCommitComment = scmRollbackCommitComment;
    }

    public void setScmShallowClone(boolean scmShallowClone) {
        this.scmShallowClone = scmShallowClone;
    }

    public void setScmSignTags(boolean scmSignTags) {
        this.scmSignTags = scmSignTags;
    }

    public void setScmSourceUrl(String scmSourceUrl) {
        this.scmSourceUrl = scmSourceUrl;
    }

    public void setScmTagBase(String scmTagBase) {
        this.scmTagBase = scmTagBase;
    }

    public void setScmTagNameFormat(String scmTagNameFormat) {
        this.scmTagNameFormat = scmTagNameFormat;
    }

    public void setScmUseEditMode(boolean scmUseEditMode) {
        this.scmUseEditMode = scmUseEditMode;
    }

    public void setScmUsername(String scmUsername) {
        this.scmUsername = scmUsername;
    }

    public void setSnapshotReleasePluginAllowed(boolean snapshotReleasePluginAllowed) {
        this.snapshotReleasePluginAllowed = snapshotReleasePluginAllowed;
    }

    public void setSuppressCommitBeforeTagOrBranch(boolean suppressCommitBeforeTagOrBranch) {
        this.suppressCommitBeforeTagOrBranch = suppressCommitBeforeTagOrBranch;
    }

    public void setUpdateBranchVersions(boolean updateBranchVersions) {
        this.updateBranchVersions = updateBranchVersions;
    }

    public void setUpdateDependencies(boolean updateDependencies) {
        this.updateDependencies = updateDependencies;
    }

    public void setUpdateVersionsToSnapshot(boolean updateVersionsToSnapshot) {
        this.updateVersionsToSnapshot = updateVersionsToSnapshot;
    }

    public void setUpdateWorkingCopyVersions(boolean updateWorkingCopyVersions) {
        this.updateWorkingCopyVersions = updateWorkingCopyVersions;
    }

    public void setUseReleaseProfile(boolean useReleaseProfile) {
        this.useReleaseProfile = useReleaseProfile;
    }

    public void setWaitBeforeTagging(int waitBeforeTagging) {
        this.waitBeforeTagging = waitBeforeTagging;
    }

    public void setWorkItem(String workItem) {
        this.workItem = workItem;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    Map<String, ReleaseStageVersions> getProjectVersions() {
        return this.projectVersions;
    }

    Map<String, Scm> getOriginalScmInfo() {
        return this.originalScmInfo;
    }

    Map<String, ReleaseStageVersions> getResolvedSnapshotDependencies() {
        return this.resolvedSnapshotDependencies;
    }

    public String getProjectReleaseVersion(String projectId) {
        if (this.projectVersions.containsKey(projectId)) {
            return this.projectVersions.get(projectId).getRelease();
        }
        return null;
    }

    public void addReleaseVersion(String projectId, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.projectVersions, projectId).setRelease(version);
    }

    public String getProjectDevelopmentVersion(String projectId) {
        if (this.projectVersions.containsKey(projectId)) {
            return this.projectVersions.get(projectId).getDevelopment();
        }
        return null;
    }

    public void addDevelopmentVersion(String projectId, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.projectVersions, projectId).setDevelopment(version);
    }

    public Scm getOriginalScmInfo(String id) {
        return this.originalScmInfo.get(id);
    }

    public boolean hasOriginalScmInfo(String id) {
        return this.originalScmInfo.containsKey(id);
    }

    public void addOriginalScmInfo(String key, Scm value) {
        this.getOriginalScmInfo().put(key, value);
    }

    public String getProjectOriginalVersion(String projectId) {
        if (this.projectVersions.containsKey(projectId)) {
            return this.projectVersions.get(projectId).getOriginal();
        }
        return null;
    }

    public void addOriginalVersion(String projectId, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.projectVersions, projectId).setOriginal(version);
    }

    public String getDependencyDevelopmentVersion(String artifactConflictId) {
        if (this.resolvedSnapshotDependencies.containsKey(artifactConflictId)) {
            ReleaseStageVersions versionMap = this.resolvedSnapshotDependencies.get(artifactConflictId);
            return versionMap.getDevelopment();
        }
        return null;
    }

    public String getDependencyReleaseVersion(String artifactConflictId) {
        if (this.resolvedSnapshotDependencies.containsKey(artifactConflictId)) {
            ReleaseStageVersions versionMap = this.resolvedSnapshotDependencies.get(artifactConflictId);
            return versionMap.getRelease();
        }
        return null;
    }

    public String getDependencyOriginalVersion(String artifactConflictId) {
        if (this.resolvedSnapshotDependencies.containsKey(artifactConflictId)) {
            ReleaseStageVersions versionMap = this.resolvedSnapshotDependencies.get(artifactConflictId);
            return versionMap.getOriginal();
        }
        return null;
    }

    public void addDependencyOriginalVersion(String dependencyKey, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.resolvedSnapshotDependencies, dependencyKey).setOriginal(version);
    }

    public void addDependencyReleaseVersion(String dependencyKey, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.resolvedSnapshotDependencies, dependencyKey).setRelease(version);
    }

    public void addDependencyDevelopmentVersion(String dependencyKey, String version) {
        ModelloReleaseDescriptor.computeIfAbsent(this.resolvedSnapshotDependencies, dependencyKey).setDevelopment(version);
    }

    private static ReleaseStageVersions computeIfAbsent(Map<String, ReleaseStageVersions> map, String key) {
        ReleaseStageVersions value = map.get(key);
        if (value == null) {
            value = new ReleaseStageVersions();
            map.put(key, value);
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModelloReleaseDescriptor that = (ModelloReleaseDescriptor)obj;
        if (this.updateDependencies != that.isUpdateDependencies() || this.useReleaseProfile != that.isUseReleaseProfile() || this.autoVersionSubmodules != that.isAutoVersionSubmodules() || this.snapshotReleasePluginAllowed != that.isSnapshotReleasePluginAllowed() || this.commitByProject != that.isCommitByProject() || this.branchCreation != that.isBranchCreation() || this.updateBranchVersions != that.isUpdateBranchVersions() || this.updateWorkingCopyVersions != that.isUpdateWorkingCopyVersions() || this.suppressCommitBeforeTagOrBranch != that.isSuppressCommitBeforeTagOrBranch() || this.updateVersionsToSnapshot != that.isUpdateVersionsToSnapshot() || this.allowTimestampedSnapshots != that.isAllowTimestampedSnapshots() || this.remoteTagging != that.isRemoteTagging() || this.pinExternals != that.isPinExternals() || this.localCheckout != that.isLocalCheckout() || this.pushChanges != that.isPushChanges()) {
            return false;
        }
        if (!(Objects.equals(this.defaultDevelopmentVersion, that.getDefaultDevelopmentVersion()) && Objects.equals(this.scmRelativePathProjectDirectory, that.getScmRelativePathProjectDirectory()) && Objects.equals(this.checkoutDirectory, that.getCheckoutDirectory()) && Objects.equals(this.performGoals, that.getPerformGoals()) && Objects.equals(this.defaultReleaseVersion, that.getDefaultReleaseVersion()) && Objects.equals(this.workItem, that.getWorkItem()) && Objects.equals(this.scmReleasedPomRevision, that.getScmReleasedPomRevision()) && Objects.equals(this.autoResolveSnapshots, that.getAutoResolveSnapshots()))) {
            return false;
        }
        if (this.addSchema != that.isAddSchema()) {
            return false;
        }
        if (this.generateReleasePoms != that.isGenerateReleasePoms()) {
            return false;
        }
        if (this.interactive != that.isInteractive()) {
            return false;
        }
        if (this.scmUseEditMode != that.isScmUseEditMode()) {
            return false;
        }
        if (!Objects.equals(this.completedPhase, that.getCompletedPhase())) {
            return false;
        }
        if ((this.checkModificationExcludes != null && (this.checkModificationExcludes == null || this.checkModificationExcludes.size() != 0) || that.getCheckModificationExcludes() != null && (that.getCheckModificationExcludes() == null || that.getCheckModificationExcludes().size() != 0)) && (this.checkModificationExcludes != null ? !this.checkModificationExcludes.equals(that.getCheckModificationExcludes()) : that.getCheckModificationExcludes() != null)) {
            return false;
        }
        if ((this.originalScmInfo != null && (this.originalScmInfo == null || this.originalScmInfo.size() != 0) || that.getOriginalScmInfo() != null && (that.getOriginalScmInfo() == null || that.getOriginalScmInfo().size() != 0)) && (this.originalScmInfo != null ? !this.compareScmCollections(that.getOriginalScmInfo()) : that.getOriginalScmInfo() != null)) {
            return false;
        }
        if (!Objects.equals(this.additionalArguments, that.getAdditionalArguments())) {
            return false;
        }
        if (!Objects.equals(this.preparationGoals, that.getPreparationGoals())) {
            return false;
        }
        if (!Objects.equals(this.completionGoals, that.getCompletionGoals())) {
            return false;
        }
        if (!Objects.equals(this.pomFileName, that.getPomFileName())) {
            return false;
        }
        if (!Objects.equals(this.scmDevelopmentCommitComment, that.getScmDevelopmentCommitComment())) {
            return false;
        }
        if (!Objects.equals(this.scmShallowClone, that.isScmShallowClone())) {
            return false;
        }
        if (!Objects.equals(this.scmReleaseCommitComment, that.getScmReleaseCommitComment())) {
            return false;
        }
        if (!Objects.equals(this.scmBranchCommitComment, that.getScmBranchCommitComment())) {
            return false;
        }
        if (!Objects.equals(this.scmRollbackCommitComment, that.getScmRollbackCommitComment())) {
            return false;
        }
        if (!Objects.equals(this.scmPrivateKeyPassPhrase, that.getScmPrivateKeyPassPhrase())) {
            return false;
        }
        if (!Objects.equals(this.scmPassword, that.getScmPassword())) {
            return false;
        }
        if (!Objects.equals(this.scmPrivateKey, that.getScmPrivateKey())) {
            return false;
        }
        if (!Objects.equals(this.scmReleaseLabel, that.getScmReleaseLabel())) {
            return false;
        }
        if (!Objects.equals(this.scmTagBase, that.getScmTagBase())) {
            return false;
        }
        if (!Objects.equals(this.scmBranchBase, that.getScmBranchBase())) {
            return false;
        }
        if (!Objects.equals(this.scmId, that.getScmId())) {
            return false;
        }
        if (!Objects.equals(this.scmSourceUrl, that.getScmSourceUrl())) {
            return false;
        }
        if (!Objects.equals(this.scmUsername, that.getScmUsername())) {
            return false;
        }
        if (!Objects.equals(this.workingDirectory, that.getWorkingDirectory())) {
            return false;
        }
        if (!Objects.equals(this.scmTagNameFormat, that.getScmTagNameFormat())) {
            return false;
        }
        return Objects.deepEquals(this.projectVersions, that.getProjectVersions());
    }

    private boolean compareScmCollections(Map<String, Scm> that) {
        if (that == null && this.originalScmInfo == null) {
            return true;
        }
        if (that == null && this.originalScmInfo != null || that != null && this.originalScmInfo == null) {
            return false;
        }
        if (that.size() != this.originalScmInfo.size()) {
            return false;
        }
        for (Map.Entry<String, Scm> entry : this.originalScmInfo.entrySet()) {
            Scm thatScm = that.get(entry.getKey());
            Scm thisScm = entry.getValue();
            if (thatScm == null && thisScm == null) {
                return true;
            }
            if (thatScm == null) {
                return false;
            }
            if (thisScm == null) {
                return true;
            }
            if (thisScm.getConnection() != null ? !thisScm.getConnection().equals(thatScm.getConnection()) : thatScm.getConnection() != null) {
                return false;
            }
            if (thisScm.getDeveloperConnection() != null ? !thisScm.getDeveloperConnection().equals(thatScm.getDeveloperConnection()) : thatScm.getDeveloperConnection() != null) {
                return false;
            }
            if (thisScm.getUrl() != null ? !thisScm.getUrl().equals(thatScm.getUrl()) : thatScm.getUrl() != null) {
                return false;
            }
            if (thisScm.getTag() != null ? !thisScm.getTag().equals(thatScm.getTag()) : thatScm.getTag() != null) {
                return false;
            }
            if (!(thisScm instanceof IdentifiedScm) || !(thatScm instanceof IdentifiedScm)) continue;
            IdentifiedScm thisIdentifiedScm = (IdentifiedScm)thisScm;
            IdentifiedScm thatIdentifiedScm = (IdentifiedScm)thatScm;
            if (!(thisIdentifiedScm.getId() != null ? !thisIdentifiedScm.getId().equals(thatIdentifiedScm.getId()) : thatIdentifiedScm.getId() != null)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.completedPhase);
        result = 29 * result + Objects.hashCode(this.scmReleaseLabel);
        result = 29 * result + Objects.hashCode(this.additionalArguments);
        result = 29 * result + Objects.hashCode(this.preparationGoals);
        result = 29 * result + Objects.hashCode(this.completionGoals);
        result = 29 * result + Objects.hashCode(this.pomFileName);
        result = 29 * result + Objects.hashCode(this.checkModificationExcludes);
        result = 29 * result + Objects.hashCode(this.scmDevelopmentCommitComment);
        result = 29 * result + Objects.hashCode(this.scmShallowClone);
        result = 29 * result + Objects.hashCode(this.scmReleaseCommitComment);
        result = 29 * result + Objects.hashCode(this.scmBranchCommitComment);
        result = 29 * result + Objects.hashCode(this.scmRollbackCommitComment);
        result = 29 * result + Objects.hashCode(this.scmTagBase);
        result = 29 * result + Objects.hashCode(this.scmBranchBase);
        result = 29 * result + Objects.hashCode(this.scmUsername);
        result = 29 * result + Objects.hashCode(this.scmPassword);
        result = 29 * result + Objects.hashCode(this.scmId);
        result = 29 * result + Objects.hashCode(this.scmSourceUrl);
        result = 29 * result + Objects.hashCode(this.scmPrivateKey);
        result = 29 * result + Objects.hashCode(this.scmPrivateKeyPassPhrase);
        result = 29 * result + Objects.hashCode(this.workingDirectory);
        result = 29 * result + Objects.hashCode(this.scmUseEditMode);
        result = 29 * result + Objects.hashCode(this.addSchema);
        result = 29 * result + Objects.hashCode(this.generateReleasePoms);
        result = 29 * result + Objects.hashCode(this.interactive);
        result = 29 * result + Objects.hashCode(this.projectVersions);
        result = 29 * result + Objects.hashCode(this.originalScmInfo);
        result = 29 * result + Objects.hashCode(this.updateDependencies);
        result = 29 * result + Objects.hashCode(this.useReleaseProfile);
        result = 29 * result + Objects.hashCode(this.autoVersionSubmodules);
        result = 29 * result + Objects.hashCode(this.snapshotReleasePluginAllowed);
        result = 29 * result + Objects.hashCode(this.commitByProject);
        result = 29 * result + Objects.hashCode(this.branchCreation);
        result = 29 * result + Objects.hashCode(this.updateBranchVersions);
        result = 29 * result + Objects.hashCode(this.updateWorkingCopyVersions);
        result = 29 * result + Objects.hashCode(this.suppressCommitBeforeTagOrBranch);
        result = 29 * result + Objects.hashCode(this.updateVersionsToSnapshot);
        result = 29 * result + Objects.hashCode(this.allowTimestampedSnapshots);
        result = 29 * result + Objects.hashCode(this.remoteTagging);
        result = 29 * result + Objects.hashCode(this.localCheckout);
        result = 29 * result + Objects.hashCode(this.pushChanges);
        result = 29 * result + Objects.hashCode(this.defaultDevelopmentVersion);
        result = 29 * result + Objects.hashCode(this.scmRelativePathProjectDirectory);
        result = 29 * result + Objects.hashCode(this.checkoutDirectory);
        result = 29 * result + Objects.hashCode(this.performGoals);
        result = 29 * result + Objects.hashCode(this.defaultReleaseVersion);
        result = 29 * result + Objects.hashCode(this.scmReleasedPomRevision);
        result = 29 * result + Objects.hashCode(this.workItem);
        result = 29 * result + Objects.hashCode(this.autoResolveSnapshots);
        result = 29 * result + Objects.hashCode(this.pinExternals);
        return result;
    }
}

