/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.phase.ResourceGenerator;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.transform.MavenCoordinate;
import org.apache.maven.shared.release.transform.ModelETL;
import org.apache.maven.shared.release.transform.ModelETLFactory;
import org.apache.maven.shared.release.transform.ModelETLRequest;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRewritePomsPhase
extends AbstractReleasePhase
implements ResourceGenerator {
    private final ScmRepositoryConfigurator scmRepositoryConfigurator;
    private final Map<String, ModelETLFactory> modelETLFactories;
    private Map<String, ScmTranslator> scmTranslators;
    private String modelETL = "jdom2-sax";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    private static final List<String> CI_FRIENDLY_PROPERTIES = Arrays.asList("revision", "sha1", "changelist");
    private long startTime = -1000L;

    protected AbstractRewritePomsPhase(ScmRepositoryConfigurator scmRepositoryConfigurator, Map<String, ModelETLFactory> modelETLFactories, Map<String, ScmTranslator> scmTranslators) {
        this.scmRepositoryConfigurator = Objects.requireNonNull(scmRepositoryConfigurator);
        this.modelETLFactories = Objects.requireNonNull(modelETLFactories);
        this.scmTranslators = Objects.requireNonNull(scmTranslators);
    }

    protected final Map<String, ScmTranslator> getScmTranslators() {
        return this.scmTranslators;
    }

    public void setModelETL(String modelETL) {
        this.modelETL = modelETL;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected abstract String getPomSuffix();

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, releaseEnvironment, reactorProjects, false, result);
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, releaseEnvironment, reactorProjects, true, result);
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult clean(List<MavenProject> reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        if (reactorProjects != null) {
            for (MavenProject project : reactorProjects) {
                File file;
                File pomFile = ReleaseUtil.getStandardPom(project);
                if (pomFile == null || !(file = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.getPomSuffix())).exists()) continue;
                file.delete();
            }
        }
        result.setResultCode(0);
        return result;
    }

    private void transform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        result.setStartTime(this.startTime >= 0L ? this.startTime : System.currentTimeMillis());
        URI root = ReleaseUtil.getRootProject(reactorProjects).getBasedir().toURI();
        for (MavenProject project : reactorProjects) {
            URI pom = project.getFile().toURI();
            this.logInfo(result, "Transforming " + root.relativize(pom).getPath() + ' ' + MessageUtils.buffer().project((Object)project.getArtifactId()) + " '" + project.getName() + "'" + (simulate ? " with ." + this.getPomSuffix() + " suffix" : "") + "...");
            this.transformProject(project, releaseDescriptor, releaseEnvironment, simulate, result);
        }
    }

    private void transformProject(MavenProject project, ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        File outputFile;
        File pomFile = ReleaseUtil.getStandardPom(project);
        ModelETLRequest request = new ModelETLRequest();
        request.setProject(project);
        request.setReleaseDescriptor(releaseDescriptor);
        ModelETL etl = this.modelETLFactories.get(this.modelETL).newInstance(request);
        etl.extract(pomFile);
        ScmRepository scmRepository = null;
        ScmProvider provider = null;
        if (this.isUpdateScm()) {
            try {
                scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
                provider = this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
            }
            catch (ScmRepositoryException e) {
                throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
            }
            catch (NoSuchScmProviderException e) {
                throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), (Throwable)e);
            }
        }
        this.transformDocument(project, etl.getModel(), releaseDescriptor, scmRepository, result, simulate);
        if (simulate) {
            outputFile = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.getPomSuffix());
        } else {
            outputFile = pomFile;
            this.prepareScm(pomFile, releaseDescriptor, scmRepository, provider);
        }
        etl.load(outputFile);
    }

    private void transformDocument(MavenProject project, Model modelTarget, ReleaseDescriptor releaseDescriptor, ScmRepository scmRepository, ReleaseResult result, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        Model model = project.getModel();
        Properties properties = modelTarget.getProperties();
        String parentVersion = this.rewriteParent(project, modelTarget, result, releaseDescriptor, simulate);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        this.rewriteVersion(modelTarget, releaseDescriptor, projectId, project);
        Build buildTarget = modelTarget.getBuild();
        if (buildTarget != null) {
            this.rewriteArtifactVersions(this.toMavenCoordinates(buildTarget.getExtensions()), model, properties, result, releaseDescriptor, simulate);
            this.rewriteArtifactVersions(this.toMavenCoordinates(buildTarget.getPlugins()), model, properties, result, releaseDescriptor, simulate);
            for (Plugin plugin : buildTarget.getPlugins()) {
                this.rewriteArtifactVersions(this.toMavenCoordinates(plugin.getDependencies()), model, properties, result, releaseDescriptor, simulate);
            }
            if (buildTarget.getPluginManagement() != null) {
                this.rewriteArtifactVersions(this.toMavenCoordinates(buildTarget.getPluginManagement().getPlugins()), model, properties, result, releaseDescriptor, simulate);
                for (Plugin plugin : buildTarget.getPluginManagement().getPlugins()) {
                    this.rewriteArtifactVersions(this.toMavenCoordinates(plugin.getDependencies()), model, properties, result, releaseDescriptor, simulate);
                }
            }
        }
        for (Profile profile : modelTarget.getProfiles()) {
            BuildBase buildBase = profile.getBuild();
            if (buildBase == null) continue;
            this.rewriteArtifactVersions(this.toMavenCoordinates(buildBase.getPlugins()), model, properties, result, releaseDescriptor, simulate);
            for (Plugin plugin : buildBase.getPlugins()) {
                this.rewriteArtifactVersions(this.toMavenCoordinates(plugin.getDependencies()), model, properties, result, releaseDescriptor, simulate);
            }
            if (buildBase.getPluginManagement() == null) continue;
            this.rewriteArtifactVersions(this.toMavenCoordinates(buildBase.getPluginManagement().getPlugins()), model, properties, result, releaseDescriptor, simulate);
            for (Plugin plugin : buildBase.getPluginManagement().getPlugins()) {
                this.rewriteArtifactVersions(this.toMavenCoordinates(plugin.getDependencies()), model, properties, result, releaseDescriptor, simulate);
            }
        }
        ArrayList<Model> modelBases = new ArrayList<Model>();
        modelBases.add(modelTarget);
        modelBases.addAll(modelTarget.getProfiles());
        for (ModelBase modelBase : modelBases) {
            this.rewriteArtifactVersions(this.toMavenCoordinates(modelBase.getDependencies()), model, properties, result, releaseDescriptor, simulate);
            if (modelBase.getDependencyManagement() != null) {
                this.rewriteArtifactVersions(this.toMavenCoordinates(modelBase.getDependencyManagement().getDependencies()), model, properties, result, releaseDescriptor, simulate);
            }
            if (modelBase.getReporting() == null) continue;
            this.rewriteArtifactVersions(this.toMavenCoordinates(modelBase.getReporting().getPlugins()), model, properties, result, releaseDescriptor, simulate);
        }
        this.transformScm(project, modelTarget, releaseDescriptor, projectId, scmRepository, result);
        if (properties != null) {
            this.rewriteBuildOutputTimestampProperty(properties, result);
        }
    }

    private void rewriteBuildOutputTimestampProperty(Properties properties, ReleaseResult result) {
        String buildOutputTimestamp = properties.getProperty("project.build.outputTimestamp");
        if (buildOutputTimestamp == null || buildOutputTimestamp == null || buildOutputTimestamp.isEmpty()) {
            return;
        }
        if (StringUtils.isNumeric((String)buildOutputTimestamp)) {
            buildOutputTimestamp = String.valueOf(result.getStartTime() / 1000L);
        } else {
            if (buildOutputTimestamp.length() <= 1) {
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            buildOutputTimestamp = df.format(new Date(result.getStartTime()));
        }
        properties.setProperty("project.build.outputTimestamp", buildOutputTimestamp);
    }

    private void rewriteVersion(Model modelTarget, ReleaseDescriptor releaseDescriptor, String projectId, MavenProject project) throws ReleaseFailureException {
        String version = this.getNextVersion(releaseDescriptor, projectId);
        if (version == null) {
            throw new ReleaseFailureException("Version for '" + project.getName() + "' was not mapped");
        }
        modelTarget.setVersion(version);
    }

    public static String extractPropertyFromExpression(String expression) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    public static boolean isCiFriendlyVersion(String version) {
        return CI_FRIENDLY_PROPERTIES.contains(AbstractRewritePomsPhase.extractPropertyFromExpression(version));
    }

    private String rewriteParent(MavenProject project, Model targetModel, ReleaseResult result, ReleaseDescriptor releaseDescriptor, boolean simulate) throws ReleaseFailureException {
        String parentVersion = null;
        if (project.hasParent()) {
            MavenProject parent = project.getParent();
            String key = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
            parentVersion = this.getNextVersion(releaseDescriptor, key);
            if (parentVersion == null) {
                parentVersion = this.getResolvedSnapshotVersion(key, releaseDescriptor);
            }
            if (parentVersion == null) {
                String original = this.getOriginalVersion(releaseDescriptor, key, simulate);
                if (parent.getVersion().equals(original)) {
                    throw new ReleaseFailureException("Version for parent '" + parent.getName() + "' was not mapped");
                }
            } else if (!AbstractRewritePomsPhase.isCiFriendlyVersion(targetModel.getParent().getVersion())) {
                targetModel.getParent().setVersion(parentVersion);
            } else {
                this.logInfo(result, "  Ignoring parent version update for CI friendly expression " + parent.getVersion());
            }
        }
        return parentVersion;
    }

    private void rewriteArtifactVersions(Collection<MavenCoordinate> elements, Model projectModel, Properties properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        if (elements == null) {
            return;
        }
        String projectId = ArtifactUtils.versionlessKey((String)projectModel.getGroupId(), (String)projectModel.getArtifactId());
        for (MavenCoordinate coordinate : elements) {
            String rawVersion = coordinate.getVersion();
            if (rawVersion == null) continue;
            String rawGroupId = coordinate.getGroupId();
            if (rawGroupId == null) {
                if (!"plugin".equals(coordinate.getName())) continue;
                rawGroupId = "org.apache.maven.plugins";
            }
            String groupId = ReleaseUtil.interpolate(rawGroupId, projectModel);
            String rawArtifactId = coordinate.getArtifactId();
            if (rawArtifactId == null) continue;
            String artifactId = ReleaseUtil.interpolate(rawArtifactId, projectModel);
            String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
            String resolvedSnapshotVersion = this.getResolvedSnapshotVersion(key, releaseDescriptor);
            String mappedVersion = this.getNextVersion(releaseDescriptor, key);
            String originalVersion = this.getOriginalVersion(releaseDescriptor, key, simulate);
            if (originalVersion == null) {
                originalVersion = this.getOriginalResolvedSnapshotVersion(key, releaseDescriptor);
            }
            if (mappedVersion != null && mappedVersion.endsWith("SNAPSHOT") && !rawVersion.endsWith("SNAPSHOT") && !releaseDescriptor.isUpdateDependencies()) continue;
            if (mappedVersion != null) {
                if (rawVersion.equals(originalVersion)) {
                    this.logInfo(result, "  Updating " + artifactId + " to " + mappedVersion);
                    coordinate.setVersion(mappedVersion);
                    continue;
                }
                String property = AbstractRewritePomsPhase.extractPropertyFromExpression(rawVersion);
                if (property == null) continue;
                if (property.startsWith("project.") || property.startsWith("pom.") || "version".equals(property)) {
                    if (!mappedVersion.equals(this.getNextVersion(releaseDescriptor, projectId))) {
                        this.logInfo(result, "  Updating " + artifactId + " to " + mappedVersion);
                        coordinate.setVersion(mappedVersion);
                        continue;
                    }
                    this.logInfo(result, "  Ignoring artifact version update for expression " + rawVersion);
                    continue;
                }
                if (properties != null) {
                    String propertyValue = properties.getProperty(property);
                    if (propertyValue != null) {
                        if (propertyValue.equals(originalVersion)) {
                            this.logInfo(result, "  Updating " + rawVersion + " to " + mappedVersion);
                            properties.setProperty(property, mappedVersion);
                            continue;
                        }
                        if (mappedVersion.equals(propertyValue)) {
                            this.logInfo(result, "  Ignoring artifact version update for expression " + rawVersion + " because it is already updated");
                            continue;
                        }
                        if (mappedVersion.equals(rawVersion)) continue;
                        if (mappedVersion.matches("\\$\\{project.+\\}") || mappedVersion.matches("\\$\\{pom.+\\}") || "${version}".equals(mappedVersion)) {
                            this.logInfo(result, "  Ignoring artifact version update for expression " + mappedVersion);
                            continue;
                        }
                        throw new ReleaseFailureException("The artifact (" + key + ") requires a different version (" + mappedVersion + ") than what is found (" + propertyValue + ") for the expression (" + rawVersion + ") in the project (" + projectId + ").");
                    }
                    if (CI_FRIENDLY_PROPERTIES.contains(property)) {
                        this.logInfo(result, "  Ignoring artifact version update for CI friendly expression " + rawVersion);
                        continue;
                    }
                    throw new ReleaseFailureException("Could not find property resolving version expression: " + rawVersion);
                }
                throw new ReleaseFailureException("Could not find properties resolving version expression : " + rawVersion);
            }
            if (resolvedSnapshotVersion == null) continue;
            this.logInfo(result, "  Updating " + artifactId + " to " + resolvedSnapshotVersion);
            coordinate.setVersion(resolvedSnapshotVersion);
        }
    }

    private void prepareScm(File pomFile, ReleaseDescriptor releaseDescriptor, ScmRepository repository, ScmProvider provider) throws ReleaseExecutionException, ReleaseScmCommandException {
        try {
            EditScmResult result;
            if (this.isUpdateScm() && (releaseDescriptor.isScmUseEditMode() || provider.requiresEditMode()) && !(result = provider.edit(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), pomFile))).isSuccess()) {
                throw new ReleaseScmCommandException("Unable to enable editing on the POM", (ScmResult)result);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred enabling edit mode: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract String getResolvedSnapshotVersion(String var1, ReleaseDescriptor var2);

    protected abstract String getOriginalVersion(ReleaseDescriptor var1, String var2, boolean var3);

    protected abstract String getNextVersion(ReleaseDescriptor var1, String var2);

    protected abstract void transformScm(MavenProject var1, Model var2, ReleaseDescriptor var3, String var4, ScmRepository var5, ReleaseResult var6) throws ReleaseExecutionException;

    protected boolean isUpdateScm() {
        return true;
    }

    protected String getOriginalResolvedSnapshotVersion(String artifactVersionlessKey, ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDependencyOriginalVersion(artifactVersionlessKey);
    }

    protected static String translateUrlPath(String trunkPath, String tagPath, String urlPath) {
        int i;
        trunkPath = trunkPath.trim();
        tagPath = tagPath.trim();
        if (trunkPath.endsWith("/")) {
            trunkPath = trunkPath.substring(0, trunkPath.length() - 1);
        }
        if (tagPath.endsWith("/")) {
            tagPath = tagPath.substring(0, tagPath.length() - 1);
        }
        char[] tagPathChars = trunkPath.toCharArray();
        char[] trunkPathChars = tagPath.toCharArray();
        for (i = 0; i < tagPathChars.length && i < trunkPathChars.length && tagPathChars[i] == trunkPathChars[i]; ++i) {
        }
        if (i == 0 || urlPath.indexOf(trunkPath.substring(i)) < 0) {
            return tagPath;
        }
        return StringUtils.replace((String)urlPath, (String)trunkPath.substring(i), (String)tagPath.substring(i));
    }

    private Collection<MavenCoordinate> toMavenCoordinates(List<?> objects) {
        ArrayList<MavenCoordinate> coordinates = new ArrayList<MavenCoordinate>(objects.size());
        for (Object object : objects) {
            if (object instanceof MavenCoordinate) {
                coordinates.add((MavenCoordinate)object);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return coordinates;
    }
}

