/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.providers.gitlib.settings.Settings;
import org.apache.maven.scm.providers.gitlib.settings.io.xpp3.GitXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class GitUtil {
    public static final String GIT_SETTINGS_FILENAME = "git-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    public static final String PASSWORD_PLACE_HOLDER_WITH_DELIMITERS = ":********@";
    private static final Pattern PASSWORD_IN_URL_PATTERN = Pattern.compile("^.*(:[^/].*@).*$");
    private static File settingsDirectory = DEFAULT_SETTINGS_DIRECTORY;
    private static Settings settings;

    private GitUtil() {
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = GitUtil.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        File settingsFile = GitUtil.getSettingsFile();
        if (settingsFile.exists()) {
            GitXpp3Reader reader = new GitXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (IOException iOException) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
        settings = GitUtil.readSettings();
    }

    public static File getSettingsFile() {
        return new File(settingsDirectory, GIT_SETTINGS_FILENAME);
    }

    public static String maskPasswordInUrl(String urlWithCredentials) {
        String output = urlWithCredentials;
        Matcher passwordMatcher = PASSWORD_IN_URL_PATTERN.matcher(output);
        if (passwordMatcher.find()) {
            String clearPasswordWithDelimiters = passwordMatcher.group(1);
            output = StringUtils.replace((String)output, (String)clearPasswordWithDelimiters, (String)PASSWORD_PLACE_HOLDER_WITH_DELIMITERS);
        }
        return output;
    }
}

