/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitStatusConsumer
implements StreamConsumer {
    private static final String ADDED_PATTERN = "^#\\s*new file:\\s*(.*)";
    private static final String MODIFIED_PATTERN = "^#\\s*modified:\\s*(.*)";
    private static final String DELETED_PATTERN = "^#\\s*deleted:\\s*(.*)";
    private RE addedRegexp;
    private RE modifiedRegexp;
    private RE deletedRegexp;
    private ScmLogger logger;
    private File workingDirectory;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public GitStatusConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
        try {
            this.addedRegexp = new RE(ADDED_PATTERN);
            this.modifiedRegexp = new RE(MODIFIED_PATTERN);
            this.deletedRegexp = new RE(DELETED_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty((String)line)) {
            return;
        }
        ScmFileStatus status = null;
        String file = null;
        if (this.addedRegexp.match(line)) {
            status = ScmFileStatus.ADDED;
            file = this.addedRegexp.getParen(1);
        } else if (this.modifiedRegexp.match(line)) {
            status = ScmFileStatus.MODIFIED;
            file = this.modifiedRegexp.getParen(1);
        } else if (this.deletedRegexp.match(line)) {
            status = ScmFileStatus.DELETED;
            file = this.deletedRegexp.getParen(1);
        }
        if (file != null && status != null) {
            if (this.workingDirectory != null && (status == ScmFileStatus.DELETED ? new File(this.workingDirectory, file).isFile() : !new File(this.workingDirectory, file).isFile())) {
                return;
            }
            this.changedFiles.add(new ScmFile(file, status));
        }
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

