/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.checkout;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListCommand;
import org.apache.maven.scm.provider.git.gitexe.command.list.GitListConsumer;
import org.apache.maven.scm.provider.git.gitexe.command.remoteinfo.GitRemoteInfoCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitCheckOutCommand
extends AbstractCheckOutCommand
implements GitCommand {
    private final Map<String, String> environmentVariables;

    public GitCheckOutCommand(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public ScmResult executeCommand(ScmProviderRepository repo, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        int exitCode;
        ScmVersion version = parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        boolean binary = parameters.getBoolean(CommandParameter.BINARY, false);
        boolean shallow = parameters.getBoolean(CommandParameter.SHALLOW, false);
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        String lastCommandLine = "git-nothing-to-do";
        if (!fileSet.getBasedir().exists() || !new File(fileSet.getBasedir(), ".git").exists()) {
            Commandline gitClone;
            if (fileSet.getBasedir().exists()) {
                fileSet.getBasedir().delete();
            }
            if ((exitCode = GitCommandLineUtils.execute(gitClone = this.createCloneCommand(repository, fileSet.getBasedir(), version, binary, shallow), stdout, stderr)) != 0) {
                return new CheckOutScmResult(gitClone.toString(), "The git clone command failed.", stderr.getOutput(), false);
            }
            lastCommandLine = gitClone.toString();
        }
        GitRemoteInfoCommand gitRemoteInfoCommand = new GitRemoteInfoCommand(this.environmentVariables);
        RemoteInfoScmResult result = gitRemoteInfoCommand.executeRemoteInfoCommand((ScmProviderRepository)repository, null, null);
        if (fileSet.getBasedir().exists() && new File(fileSet.getBasedir(), ".git").exists() && result.getBranches().size() > 0) {
            Commandline gitPull = this.createPullCommand(repository, fileSet.getBasedir(), version);
            exitCode = GitCommandLineUtils.execute(gitPull, stdout, stderr);
            if (exitCode != 0) {
                return new CheckOutScmResult(gitPull.toString(), "The git pull command failed.", stderr.getOutput(), false);
            }
            Commandline gitCheckout = GitCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), version);
            exitCode = GitCommandLineUtils.execute(gitCheckout, stdout, stderr);
            if (exitCode != 0) {
                return new CheckOutScmResult(gitCheckout.toString(), "The git checkout command failed.", stderr.getOutput(), false);
            }
            lastCommandLine = gitCheckout.toString();
        }
        GitListConsumer listConsumer = new GitListConsumer(fileSet.getBasedir(), ScmFileStatus.CHECKED_IN);
        Commandline gitList = GitListCommand.createCommandLine(repository, fileSet.getBasedir());
        exitCode = GitCommandLineUtils.execute(gitList, (StreamConsumer)listConsumer, stderr);
        if (exitCode != 0) {
            return new CheckOutScmResult(gitList.toString(), "The git ls-files command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(lastCommandLine, listConsumer.getListedFiles());
    }

    public static Commandline createCommandLine(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        Commandline gitCheckout = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "checkout");
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName())) {
            gitCheckout.createArg().setValue(version.getName());
        }
        return gitCheckout;
    }

    private Commandline createCloneCommand(GitScmProviderRepository repository, File workingDirectory, ScmVersion version, boolean binary, boolean shallow) {
        Commandline gitClone = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory.getParentFile(), "clone", repository, this.environmentVariables);
        this.forceBinary(gitClone, binary);
        if (shallow) {
            gitClone.createArg().setValue("--depth");
            gitClone.createArg().setValue("1");
        }
        if (version instanceof ScmBranch) {
            gitClone.createArg().setValue("--branch");
            gitClone.createArg().setValue(version.getName());
        }
        gitClone.createArg().setValue(repository.getFetchUrl());
        gitClone.createArg().setValue(workingDirectory.getName());
        return gitClone;
    }

    private void forceBinary(Commandline commandLine, boolean binary) {
        if (binary) {
            commandLine.createArg().setValue("-c");
            commandLine.createArg().setValue("core.autocrlf=false");
        }
    }

    private Commandline createPullCommand(GitScmProviderRepository repository, File workingDirectory, ScmVersion version) {
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName())) {
            if (version instanceof ScmTag) {
                Commandline gitFetch = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "fetch", repository, this.environmentVariables);
                gitFetch.createArg().setValue(repository.getFetchUrl());
                return gitFetch;
            }
            Commandline gitPull = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull", repository, this.environmentVariables);
            gitPull.createArg().setValue(repository.getFetchUrl());
            gitPull.createArg().setValue(version.getName() + ":" + version.getName());
            return gitPull;
        }
        Commandline gitPull = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "pull", repository, this.environmentVariables);
        gitPull.createArg().setValue(repository.getFetchUrl());
        gitPull.createArg().setValue("master");
        return gitPull;
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        throw new UnsupportedOperationException("Should not get here");
    }
}

