/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.remove;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgRemoveConsumer
extends HgConsumer {
    private final File workingDir;
    private final List<ScmFile> removedFiles = new ArrayList<ScmFile>();

    public HgRemoveConsumer(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void doConsume(ScmFileStatus status, String trimmedLine) {
        if (status == ScmFileStatus.DELETED) {
            File tmpFile = new File(this.workingDir, trimmedLine);
            if (!tmpFile.exists()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Not a file: " + tmpFile + ". Ignored");
                }
            } else {
                ScmFile scmFile = new ScmFile(trimmedLine, ScmFileStatus.DELETED);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(scmFile.toString());
                }
                this.removedFiles.add(scmFile);
            }
        }
    }

    public List<ScmFile> getRemovedFiles() {
        return this.removedFiles;
    }
}

