/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.blame;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.AbstractRepositoryConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzBlameConsumer
extends AbstractRepositoryConsumer {
    private static final String JAZZ_TIMESTAMP_PATTERN = "yyyy-MM-dd";
    private static final String LINE_PATTERN = "(\\d+) (.*) \\((\\d+)\\) (\\d+-\\d+-\\d+) (.*)";
    private RE lineRegexp;
    private List<BlameLine> fLines = new ArrayList<BlameLine>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public JazzBlameConsumer(ScmProviderRepository repository, ScmLogger logger) {
        super(repository, logger);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.lineRegexp = new RE(LINE_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse jazz scm blame output. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    @Override
    public void consumeLine(String line) {
        super.consumeLine(line);
        if (this.lineRegexp.match(line)) {
            String lineNumberStr = this.lineRegexp.getParen(1);
            String owner = this.lineRegexp.getParen(2);
            String changeSetNumberStr = this.lineRegexp.getParen(3);
            String dateStr = this.lineRegexp.getParen(4);
            Date date = this.parseDate(dateStr, JAZZ_TIMESTAMP_PATTERN, null);
            this.fLines.add(new BlameLine(date, changeSetNumberStr, owner));
        }
    }

    public List<BlameLine> getLines() {
        return this.fLines;
    }
}

