/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.status;

import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.command.status.JazzStatusConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzStatusCommand
extends AbstractStatusCommand {
    public StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing status command...");
        }
        JazzStatusConsumer statusConsumer = new JazzStatusConsumer(repo, this.getLogger());
        ErrorConsumer errConsumer = new ErrorConsumer(this.getLogger());
        JazzScmCommand statusCmd = this.createStatusCommand(repo, fileSet);
        int status = statusCmd.execute((StreamConsumer)statusConsumer, errConsumer);
        if (status != 0 || errConsumer.hasBeenFed()) {
            return new StatusScmResult(statusCmd.getCommandString(), "Error code for Jazz SCM status command - " + status, errConsumer.getOutput(), false);
        }
        if (this.getLogger().isDebugEnabled()) {
            Iterator<ScmFile> iter = statusConsumer.getChangedFiles().iterator();
            if (iter.hasNext()) {
                this.getLogger().debug("Iterating over \"Status\" results");
                while (iter.hasNext()) {
                    ScmFile file = iter.next();
                    this.getLogger().debug(file.getPath() + " : " + file.getStatus());
                }
            } else {
                this.getLogger().debug("There are no differences");
            }
        }
        return new StatusScmResult(statusCmd.getCommandString(), statusConsumer.getChangedFiles());
    }

    public JazzScmCommand createStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) {
        JazzScmCommand command = new JazzScmCommand("status", null, repo, false, fileSet, this.getLogger());
        command.addArgument("--wide");
        return command;
    }
}

