/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkout;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.checkout.SvnCheckOutConsumer;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCheckOutCommand
extends AbstractCheckOutCommand
implements SvnCommand {
    private final boolean interactive;

    public SvnCheckOutCommand(boolean interactive) {
        this.interactive = interactive;
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        int exitCode;
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName())) {
            if (version instanceof ScmTag) {
                url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)((ScmTag)version));
            } else if (version instanceof ScmBranch) {
                url = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)((ScmBranch)version));
            }
        }
        url = SvnCommandUtils.fixUrl((String)url, (String)repository.getUser());
        Commandline cl = this.createCommandLine(repository, fileSet.getBasedir(), version, url, recursive);
        SvnCheckOutConsumer consumer = new SvnCheckOutConsumer(fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            if (Os.isFamily((String)"windows")) {
                this.logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), Integer.toString(consumer.getRevision()), consumer.getCheckedOutFiles());
    }

    public Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, ScmVersion version, String url) {
        return this.createCommandLine(repository, workingDirectory, version, url, true);
    }

    public Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, ScmVersion version, String url, boolean recursive) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory.getParentFile(), repository, this.interactive);
        cl.createArg().setValue("checkout");
        if (!recursive) {
            cl.createArg().setValue("-N");
        }
        if (version != null && StringUtils.isNotEmpty((CharSequence)version.getName()) && version instanceof ScmRevision) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(version.getName());
        }
        cl.createArg().setValue(url + "@");
        cl.createArg().setValue(workingDirectory.getAbsolutePath());
        return cl;
    }
}

