/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import org.apache.maven.scm.ScmTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class SvnScmTestUtils {
    public static final String SVN_COMMAND_LINE = "svn";
    public static final String SVNADMIN_COMMAND_LINE = "svnadmin";

    private SvnScmTestUtils() {
    }

    public static void initializeRepository(File repositoryRoot) throws Exception {
        if (repositoryRoot.exists()) {
            FileUtils.deleteDirectory((File)repositoryRoot);
        }
        Assert.assertTrue((String)("Could not make repository root directory: " + repositoryRoot.getAbsolutePath()), (boolean)repositoryRoot.mkdirs());
        ScmTestCase.execute((File)repositoryRoot.getParentFile(), (String)SVNADMIN_COMMAND_LINE, (String)("create " + repositoryRoot.getName()));
        SvnScmTestUtils.loadSvnDump(repositoryRoot, new SvnScmTestUtils().getClass().getClassLoader().getResourceAsStream("tck/tck.dump"));
    }

    public static void initializeRepository(File repositoryRoot, File dump) throws Exception {
        if (repositoryRoot.exists()) {
            FileUtils.deleteDirectory((File)repositoryRoot);
        }
        Assert.assertTrue((String)("Could not make repository root directory: " + repositoryRoot.getAbsolutePath()), (boolean)repositoryRoot.mkdirs());
        ScmTestCase.execute((File)repositoryRoot.getParentFile(), (String)SVNADMIN_COMMAND_LINE, (String)("create " + repositoryRoot.getName()));
        Assert.assertTrue((String)("The dump file doesn't exist: " + dump.getAbsolutePath()), (boolean)dump.exists());
        SvnScmTestUtils.loadSvnDump(repositoryRoot, new FileInputStream(dump));
    }

    private static void loadSvnDump(File repositoryRoot, InputStream dumpStream) throws Exception {
        Commandline cl = new Commandline();
        cl.setExecutable(SVNADMIN_COMMAND_LINE);
        cl.setWorkingDirectory(repositoryRoot.getParentFile().getAbsolutePath());
        cl.createArg().setValue("load");
        cl.createArg().setValue(repositoryRoot.getAbsolutePath());
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitValue = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)dumpStream, (StreamConsumer)stdout, (StreamConsumer)stderr);
        if (exitValue != 0) {
            System.err.println("-----------------------------------------");
            System.err.println("Command line: " + cl);
            System.err.println("Working directory: " + cl.getWorkingDirectory());
            System.err.println("-----------------------------------------");
            System.err.println("Standard output: ");
            System.err.println("-----------------------------------------");
            System.err.println(stdout.getOutput());
            System.err.println("-----------------------------------------");
            System.err.println("Standard error: ");
            System.err.println("-----------------------------------------");
            System.err.println(stderr.getOutput());
            System.err.println("-----------------------------------------");
        }
        if (exitValue != 0) {
            Assert.fail((String)("Exit value wasn't 0, was:" + exitValue));
        }
    }

    public static String getScmUrl(File repositoryRootFile) throws CommandLineException {
        String repositoryRoot = repositoryRootFile.getAbsolutePath();
        if ("true".equals(System.getProperty("cygwin"))) {
            Commandline cl = new Commandline();
            cl.setExecutable("cygpath");
            cl.createArg().setValue("--unix");
            cl.createArg().setValue(repositoryRoot);
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            int exitValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, null);
            if (exitValue != 0) {
                throw new CommandLineException("Unable to convert cygwin path, exit code = " + exitValue);
            }
            repositoryRoot = stdout.getOutput().trim();
        } else if (Os.isFamily((String)"windows")) {
            repositoryRoot = "/" + StringUtils.replace((String)repositoryRoot, (String)"\\", (String)"/");
        }
        return "scm:svn:file://" + repositoryRoot;
    }
}

