/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.mkdir;

import java.io.File;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.provider.svn.SvnScmTestUtils;
import org.apache.maven.scm.tck.command.mkdir.MkdirCommandTckTest;

public class SvnMkdirCommandTckTest
extends MkdirCommandTckTest {
    public String getScmUrl() throws Exception {
        return SvnScmTestUtils.getScmUrl(new File(this.getRepositoryRoot(), "trunk"));
    }

    public void initRepo() throws Exception {
        SvnScmTestUtils.initializeRepository(this.getRepositoryRoot());
    }

    public void testMkdirCommandMkdirUrl() throws Exception {
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy(), new File(this.getMissingDirectory()));
        MkdirScmResult result = this.getScmManager().mkdir(this.getScmRepository(), fileSet, "Mkdir message", false);
        this.assertResultIsSuccess((ScmResult)result);
        SvnMkdirCommandTckTest.assertNotNull((Object)result.getRevision());
        ListScmResult listResult = this.getScmManager().list(this.getScmRepository(), fileSet, true, null);
        SvnMkdirCommandTckTest.assertTrue((String)"Directory should have been found.", (boolean)listResult.isSuccess());
    }

    public void testMkdirCommandDirAlreadyAdded() throws Exception {
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy(), new File(this.getMissingDirectory()));
        MkdirScmResult result = this.getScmManager().mkdir(this.getScmRepository(), fileSet, null, false);
        this.assertResultIsSuccess((ScmResult)result);
        SvnMkdirCommandTckTest.assertNotNull((Object)result.getRevision());
        ListScmResult listResult = this.getScmManager().list(this.getScmRepository(), fileSet, true, null);
        SvnMkdirCommandTckTest.assertTrue((String)"Directory should have been found.", (boolean)listResult.isSuccess());
        result = this.getScmManager().mkdir(this.getScmRepository(), fileSet, null, false);
        this.printOutputError((ScmResult)result);
        SvnMkdirCommandTckTest.assertFalse((boolean)result.isSuccess());
    }
}

