/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.shared.model.fileset;

/**
 * 
 *         Defines the rules for matching and working with files in
 * a given base directory.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class FileSet
    extends SetBase
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Absolute or relative from the module's
     * directory.  For
     *             example, "src/main/bin" would select this
     * subdirectory
     *             of the project in which this dependency is
     * defined.
     *           
     */
    private String directory;

    /**
     * 
     *             
     *             Controls the line-endings of files in this
     * fileSet.
     *             <br/>
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    private String lineEnding;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get absolute or relative from the module's directory.  For
     *             example, "src/main/bin" would select this
     * subdirectory
     *             of the project in which this dependency is
     * defined.
     * 
     * @return String
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory()

    /**
     * Get controls the line-endings of files in this fileSet.
     *             <br/>
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @return String
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Set absolute or relative from the module's directory.  For
     *             example, "src/main/bin" would select this
     * subdirectory
     *             of the project in which this dependency is
     * defined.
     * 
     * @param directory a directory object.
     */
    public void setDirectory( String directory )
    {
        this.directory = directory;
    } //-- void setDirectory( String )

    /**
     * Set controls the line-endings of files in this fileSet.
     *             <br/>
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @param lineEnding a lineEnding object.
     */
    public void setLineEnding( String lineEnding )
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding( String )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding a modelEncoding object.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

}
