/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.dependency.tree.DependencyNode;

public class DependencyTreeResolutionListener
implements ResolutionListener {
    private final Stack parents = new Stack();
    private final Map artifacts = new HashMap();
    private DependencyNode rootNode = null;
    private int currentDepth = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void testArtifact(Artifact artifact) {
    }

    public void startProcessChildren(Artifact artifact) {
        DependencyNode node = (DependencyNode)this.artifacts.get(artifact.getDependencyConflictId());
        node.depth = this.currentDepth++;
        if (this.parents.isEmpty()) {
            this.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        DependencyNode check = (DependencyNode)this.parents.pop();
        if (!$assertionsDisabled && !artifact.equals(check.artifact)) {
            throw new AssertionError();
        }
        --this.currentDepth;
    }

    public void includeArtifact(Artifact artifact) {
        if (this.artifacts.containsKey(artifact.getDependencyConflictId())) {
            DependencyNode prev = (DependencyNode)this.artifacts.get(artifact.getDependencyConflictId());
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(artifact.getDependencyConflictId());
        }
        DependencyNode node = new DependencyNode();
        node.artifact = artifact;
        if (!this.parents.isEmpty()) {
            node.parent = (DependencyNode)this.parents.peek();
            node.parent.children.add(node);
            node.depth = this.currentDepth;
        }
        this.artifacts.put(artifact.getDependencyConflictId(), node);
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        if (!$assertionsDisabled && !omitted.getDependencyConflictId().equals(kept.getDependencyConflictId())) {
            throw new AssertionError();
        }
        DependencyNode prev = (DependencyNode)this.artifacts.get(omitted.getDependencyConflictId());
        if (prev != null) {
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(omitted.getDependencyConflictId());
        }
        this.includeArtifact(kept);
    }

    public void updateScope(Artifact artifact, String scope) {
        DependencyNode node = (DependencyNode)this.artifacts.get(artifact.getDependencyConflictId());
        node.artifact.setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        DependencyNode node = (DependencyNode)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.artifact.setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.artifact.setScope(replacement.getScope());
            }
        }
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void updateScopeCurrentPom(Artifact artifact, String key) {
    }

    public void selectVersionFromRange(Artifact artifact) {
    }

    public void restrictRange(Artifact artifact, Artifact artifact1, VersionRange versionRange) {
    }

    public Collection getNodes() {
        return this.artifacts.values();
    }

    public DependencyNode getRootNode() {
        return this.rootNode;
    }

    static {
        $assertionsDisabled = !DependencyTreeResolutionListener.class.desiredAssertionStatus();
    }
}

