/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.dependency.tree.DependencyTreeInverseIterator;
import org.apache.maven.shared.dependency.tree.DependencyTreePreorderIterator;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.SerializingDependencyNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyNode {
    public static final int INCLUDED = 0;
    public static final int OMITTED_FOR_DUPLICATE = 1;
    public static final int OMITTED_FOR_CONFLICT = 2;
    public static final int OMITTED_FOR_CYCLE = 3;
    private final Artifact artifact;
    private final List<DependencyNode> children;
    private DependencyNode parent;
    private int state;
    private Artifact relatedArtifact;
    private String originalScope;
    private String failedUpdateScope;
    private String premanagedVersion;
    private String premanagedScope;
    private VersionRange versionSelectedFromRange;
    private List<ArtifactVersion> availableVersions;

    public DependencyNode(Artifact artifact) {
        this(artifact, 0);
    }

    public DependencyNode(Artifact artifact, int state) {
        this(artifact, state, null);
    }

    public DependencyNode(Artifact artifact, int state, Artifact relatedArtifact) {
        boolean requiresRelatedArtifact;
        if (artifact == null) {
            throw new IllegalArgumentException("artifact cannot be null");
        }
        if (state < 0 || state > 3) {
            throw new IllegalArgumentException("Unknown state: " + state);
        }
        boolean bl = requiresRelatedArtifact = state == 1 || state == 2;
        if (requiresRelatedArtifact && relatedArtifact == null) {
            throw new IllegalArgumentException("Related artifact is required for states OMITTED_FOR_DUPLICATE and OMITTED_FOR_CONFLICT");
        }
        if (!requiresRelatedArtifact && relatedArtifact != null) {
            throw new IllegalArgumentException("Related artifact is only required for states OMITTED_FOR_DUPLICATE and OMITTED_FOR_CONFLICT");
        }
        this.artifact = artifact;
        this.state = state;
        this.relatedArtifact = relatedArtifact;
        this.children = new ArrayList<DependencyNode>();
    }

    DependencyNode() {
        this.artifact = null;
        this.children = new ArrayList<DependencyNode>();
    }

    public boolean accept(DependencyNodeVisitor visitor) {
        block1: {
            if (!visitor.visit(this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.endVisit(this);
    }

    public void addChild(DependencyNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public void removeChild(DependencyNode child) {
        this.children.remove(child);
        child.parent = null;
    }

    public DependencyNode getParent() {
        return this.parent;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public int getDepth() {
        int depth = 0;
        for (DependencyNode node = this.getParent(); node != null; node = node.getParent()) {
            ++depth;
        }
        return depth;
    }

    public List<DependencyNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public int getState() {
        return this.state;
    }

    public Artifact getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public String getOriginalScope() {
        return this.originalScope;
    }

    public void setOriginalScope(String originalScope) {
        this.originalScope = originalScope;
    }

    public String getFailedUpdateScope() {
        return this.failedUpdateScope;
    }

    public void setFailedUpdateScope(String failedUpdateScope) {
        this.failedUpdateScope = failedUpdateScope;
    }

    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String premanagedVersion) {
        this.premanagedVersion = premanagedVersion;
    }

    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String premanagedScope) {
        this.premanagedScope = premanagedScope;
    }

    public VersionRange getVersionSelectedFromRange() {
        return this.versionSelectedFromRange;
    }

    public void setVersionSelectedFromRange(VersionRange versionSelectedFromRange) {
        this.versionSelectedFromRange = versionSelectedFromRange;
    }

    public List<ArtifactVersion> getAvailableVersions() {
        return this.availableVersions;
    }

    public void setAvailableVersions(List<ArtifactVersion> availableVersions) {
        this.availableVersions = availableVersions;
    }

    public void omitForConflict(Artifact relatedArtifact) {
        if (this.getState() != 0) {
            throw new IllegalStateException("Only INCLUDED dependency nodes can be omitted for conflict");
        }
        if (relatedArtifact == null) {
            throw new IllegalArgumentException("Related artifact cannot be null");
        }
        if (!relatedArtifact.getDependencyConflictId().equals(this.getArtifact().getDependencyConflictId())) {
            throw new IllegalArgumentException("Related artifact has a different dependency conflict id");
        }
        this.relatedArtifact = relatedArtifact;
        boolean duplicate = false;
        if (this.getArtifact().getVersion() != null) {
            duplicate = this.getArtifact().getVersion().equals(relatedArtifact.getVersion());
        } else if (this.getArtifact().getVersionRange() != null) {
            duplicate = this.getArtifact().getVersionRange().equals((Object)relatedArtifact.getVersionRange());
        } else {
            throw new RuntimeException("Artifact version and version range is null: " + this.getArtifact());
        }
        this.state = duplicate ? 1 : 2;
        this.removeAllChildren();
    }

    public void omitForCycle() {
        if (this.getState() != 0) {
            throw new IllegalStateException("Only INCLUDED dependency nodes can be omitted for cycle");
        }
        this.state = 3;
        this.removeAllChildren();
    }

    public Iterator<DependencyNode> iterator() {
        return this.preorderIterator();
    }

    public Iterator<DependencyNode> preorderIterator() {
        return new DependencyTreePreorderIterator(this);
    }

    public Iterator<DependencyNode> inverseIterator() {
        return new DependencyTreeInverseIterator(this);
    }

    public String toNodeString() {
        boolean included;
        StringBuffer buffer = new StringBuffer();
        boolean bl = included = this.getState() == 0;
        if (!included) {
            buffer.append('(');
        }
        buffer.append(this.artifact);
        ItemAppender appender = new ItemAppender(buffer, included ? " (" : " - ", "; ", included ? ")" : "");
        if (this.getPremanagedVersion() != null) {
            appender.append("version managed from ", this.getPremanagedVersion());
        }
        if (this.getPremanagedScope() != null) {
            appender.append("scope managed from ", this.getPremanagedScope());
        }
        if (this.getOriginalScope() != null) {
            appender.append("scope updated from ", this.getOriginalScope());
        }
        if (this.getFailedUpdateScope() != null) {
            appender.append("scope not updated to ", this.getFailedUpdateScope());
        }
        if (this.getVersionSelectedFromRange() != null) {
            appender.append("version selected from range ", this.getVersionSelectedFromRange().toString());
            appender.append("available versions ", this.getAvailableVersions().toString());
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                appender.append("omitted for duplicate");
                break;
            }
            case 2: {
                appender.append("omitted for conflict with ", this.relatedArtifact.getVersion());
                break;
            }
            case 3: {
                appender.append("omitted for cycle");
            }
        }
        appender.flush();
        if (!included) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    public String toString(int indentDepth) {
        return this.toString();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 31 + this.getArtifact().hashCode();
        hashCode = hashCode * 31 + this.nullHashCode(this.getArtifact().getScope());
        hashCode = hashCode * 31 + this.nullHashCode(DependencyNode.nullGetArtifact(this.getParent()));
        hashCode = hashCode * 31 + ((Object)this.getChildren()).hashCode();
        hashCode = hashCode * 31 + this.getState();
        hashCode = hashCode * 31 + this.nullHashCode(this.getRelatedArtifact());
        hashCode = hashCode * 31 + this.nullHashCode(this.getPremanagedVersion());
        hashCode = hashCode * 31 + this.nullHashCode(this.getPremanagedScope());
        hashCode = hashCode * 31 + this.nullHashCode(this.getOriginalScope());
        hashCode = hashCode * 31 + this.nullHashCode(this.getFailedUpdateScope());
        hashCode = hashCode * 31 + this.nullHashCode(this.getVersionSelectedFromRange());
        hashCode = hashCode * 31 + this.nullHashCode(this.getAvailableVersions());
        return hashCode;
    }

    public boolean equals(Object object) {
        boolean equal;
        if (object instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)object;
            equal = this.getArtifact().equals(node.getArtifact());
            equal &= this.nullEquals(this.getArtifact().getScope(), node.getArtifact().getScope());
            equal &= this.nullEquals(DependencyNode.nullGetArtifact(this.getParent()), DependencyNode.nullGetArtifact(node.getParent()));
            equal &= ((Object)this.getChildren()).equals(node.getChildren());
            equal &= this.getState() == node.getState();
            equal &= this.nullEquals(this.getRelatedArtifact(), node.getRelatedArtifact());
            equal &= this.nullEquals(this.getPremanagedVersion(), node.getPremanagedVersion());
            equal &= this.nullEquals(this.getPremanagedScope(), node.getPremanagedScope());
            equal &= this.nullEquals(this.getOriginalScope(), node.getOriginalScope());
            equal &= this.nullEquals(this.getFailedUpdateScope(), node.getFailedUpdateScope());
            equal &= this.nullEquals(this.getVersionSelectedFromRange(), node.getVersionSelectedFromRange());
            equal &= this.nullEquals(this.getAvailableVersions(), node.getAvailableVersions());
        } else {
            equal = false;
        }
        return equal;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.accept(new SerializingDependencyNodeVisitor(writer));
        return writer.toString();
    }

    private void removeAllChildren() {
        for (DependencyNode child : this.children) {
            child.parent = null;
        }
        this.children.clear();
    }

    private int nullHashCode(Object a) {
        return a == null ? 0 : a.hashCode();
    }

    private boolean nullEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static Artifact nullGetArtifact(DependencyNode node) {
        return node != null ? node.getArtifact() : null;
    }

    private static class ItemAppender {
        private StringBuffer buffer;
        private String startToken;
        private String separatorToken;
        private String endToken;
        private boolean appended;

        public ItemAppender(StringBuffer buffer, String startToken, String separatorToken, String endToken) {
            this.buffer = buffer;
            this.startToken = startToken;
            this.separatorToken = separatorToken;
            this.endToken = endToken;
            this.appended = false;
        }

        public ItemAppender append(String item) {
            this.appendToken();
            this.buffer.append(item);
            return this;
        }

        public ItemAppender append(String item1, String item2) {
            this.appendToken();
            this.buffer.append(item1).append(item2);
            return this;
        }

        public void flush() {
            if (this.appended) {
                this.buffer.append(this.endToken);
                this.appended = false;
            }
        }

        private void appendToken() {
            this.buffer.append(this.appended ? this.separatorToken : this.startToken);
            this.appended = true;
        }
    }
}

