/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import java.io.File;
import java.io.IOException;
import org.apache.maven.shared.jarsigner.CommandLineConfigurationException;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerVerifyRequest;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Arg;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class JarSignerCommandLineBuilder {
    private static final Logger DEFAULT_LOGGER = new ConsoleLogger(0, JarSignerCommandLineBuilder.class.getName());
    private Logger logger = DEFAULT_LOGGER;
    private String jarSignerFile;

    public Commandline build(JarSignerRequest request) throws CommandLineConfigurationException {
        String[] arguments;
        String maxMemory;
        String providerArg;
        String providerClass;
        String providerName;
        String storetype;
        String storepass;
        String keystore;
        try {
            this.checkRequiredState();
        }
        catch (IOException e) {
            throw new CommandLineConfigurationException(e.getMessage(), e);
        }
        Commandline cli = new Commandline();
        cli.setExecutable(this.jarSignerFile);
        cli.setWorkingDirectory(request.getWorkingDirectory());
        if (request.isVerbose()) {
            cli.createArg().setValue("-verbose");
        }
        if (!StringUtils.isEmpty((String)(keystore = request.getKeystore()))) {
            cli.createArg().setValue("-keystore");
            cli.createArg().setValue(keystore);
        }
        if (!StringUtils.isEmpty((String)(storepass = request.getStorepass()))) {
            cli.createArg().setValue("-storepass");
            Arg arg = cli.createArg();
            arg.setValue(storepass);
            arg.setMask(true);
        }
        if (!StringUtils.isEmpty((String)(storetype = request.getStoretype()))) {
            cli.createArg().setValue("-storetype");
            cli.createArg().setValue(storetype);
        }
        if (!StringUtils.isEmpty((String)(providerName = request.getProviderName()))) {
            cli.createArg().setValue("-providerName");
            cli.createArg().setValue(providerName);
        }
        if (!StringUtils.isEmpty((String)(providerClass = request.getProviderClass()))) {
            cli.createArg().setValue("-providerClass");
            cli.createArg().setValue(providerClass);
        }
        if (!StringUtils.isEmpty((String)(providerArg = request.getProviderArg()))) {
            cli.createArg().setValue("-providerArg");
            cli.createArg().setValue(providerArg);
        }
        if (request.isProtectedAuthenticationPath()) {
            cli.createArg().setValue("-protected");
        }
        if (StringUtils.isNotEmpty((String)(maxMemory = request.getMaxMemory()))) {
            cli.createArg().setValue("-J-Xmx" + maxMemory);
        }
        if ((arguments = request.getArguments()) != null) {
            cli.addArguments(arguments);
        }
        if (request instanceof JarSignerSignRequest) {
            this.build((JarSignerSignRequest)request, cli);
        }
        if (request instanceof JarSignerVerifyRequest) {
            this.build((JarSignerVerifyRequest)request, cli);
        }
        cli.createArg().setFile(request.getArchive());
        String alias = request.getAlias();
        if (!StringUtils.isEmpty((String)alias)) {
            cli.createArg().setValue(alias);
        }
        return cli;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setJarSignerFile(String jarSignerFile) {
        this.jarSignerFile = jarSignerFile;
    }

    protected void checkRequiredState() throws IOException {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
        if (this.jarSignerFile == null) {
            throw new IllegalStateException("A jarSigner file is required.");
        }
    }

    protected void build(JarSignerSignRequest request, Commandline cli) {
        File certchain;
        File signedjar;
        String tsaAlias;
        String tsaLocation;
        String sigfile;
        String keypass = request.getKeypass();
        if (!StringUtils.isEmpty((String)keypass)) {
            cli.createArg().setValue("-keypass");
            Arg arg = cli.createArg();
            arg.setValue(keypass);
            arg.setMask(true);
        }
        if (!StringUtils.isEmpty((String)(sigfile = request.getSigfile()))) {
            cli.createArg().setValue("-sigfile");
            cli.createArg().setValue(sigfile);
        }
        if (StringUtils.isNotBlank((String)(tsaLocation = request.getTsaLocation()))) {
            cli.createArg().setValue("-tsa");
            cli.createArg().setValue(tsaLocation);
        }
        if (StringUtils.isNotBlank((String)(tsaAlias = request.getTsaAlias()))) {
            cli.createArg().setValue("-tsacert");
            cli.createArg().setValue(tsaAlias);
        }
        if ((signedjar = request.getSignedjar()) != null) {
            cli.createArg().setValue("-signedjar");
            cli.createArg().setValue(signedjar.getAbsolutePath());
        }
        if ((certchain = request.getCertchain()) != null) {
            cli.createArg().setValue("-certchain");
            cli.createArg().setValue(certchain.getAbsolutePath());
        }
    }

    protected void build(JarSignerVerifyRequest request, Commandline cli) throws CommandLineConfigurationException {
        cli.createArg(true).setValue("-verify");
        if (request.isCerts()) {
            cli.createArg().setValue("-certs");
        }
    }
}

