/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

class StreamFeeder
extends Thread {
    private final InputStream input;
    private final OutputStream output;
    private Throwable exception;
    private boolean done;
    private final Object lock = new Object();

    StreamFeeder(InputStream input, OutputStream output) {
        this.input = Objects.requireNonNull(input);
        this.output = Objects.requireNonNull(output);
        this.done = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int data;
            while (!this.isInterrupted() && (data = this.input.read()) != -1) {
                this.output.write(data);
            }
            this.output.flush();
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            this.close();
        }
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    private void close() {
        block2: {
            try {
                this.output.close();
            }
            catch (IOException e) {
                if (this.exception != null) break block2;
                this.exception = e;
            }
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        this.interrupt();
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

