/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.report.MulticastingReporter;
import org.apache.maven.plugin.surefire.report.Reporter;
import org.apache.maven.plugin.surefire.report.TestSetRunListener;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.DefaultDirectConsoleReporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.suite.RunResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReporterFactory
implements ReporterFactory {
    private final ReporterConfiguration reporterConfiguration;
    private final RunStatistics globalStats = new RunStatistics();
    private final MulticastingReporter multicastingReporter;
    private final StartupReportConfiguration reportConfiguration;
    private final StatisticsReporter statisticsReporter;

    public FileReporterFactory(StartupReportConfiguration reportConfiguration) {
        this.reportConfiguration = reportConfiguration;
        this.reporterConfiguration = this.getReporterConfiguration();
        this.multicastingReporter = new MulticastingReporter(this.instantiateReports());
        this.statisticsReporter = reportConfiguration.instantiateStatisticsReporter();
        this.runStarting();
    }

    private ReporterConfiguration getReporterConfiguration() {
        return new ReporterConfiguration(this.reportConfiguration.getReportsDirectory(), Boolean.valueOf(this.reportConfiguration.isTrimStackTrace()));
    }

    public RunListener createReporter() {
        PrintStream sout = this.reporterConfiguration.getOriginalSystemOut();
        return new TestSetRunListener(this.reportConfiguration.instantiateConsoleReporter(), this.reportConfiguration.instantiateFileReporter(), this.reportConfiguration.instantiateXmlReporter(), this.reportConfiguration.instantiateConsoleOutputFileReporter(sout), this.statisticsReporter, this.globalStats);
    }

    private List<Reporter> instantiateReports() {
        PrintStream sout = this.reporterConfiguration.getOriginalSystemOut();
        ArrayList<Reporter> result = new ArrayList<Reporter>();
        this.addIfNotNull(result, this.reportConfiguration.instantiateConsoleReporter());
        this.addIfNotNull(result, this.reportConfiguration.instantiateFileReporter());
        this.addIfNotNull(result, this.reportConfiguration.instantiateXmlReporter());
        this.addIfNotNull(result, this.reportConfiguration.instantiateConsoleOutputFileReporter(sout));
        this.addIfNotNull(result, this.statisticsReporter);
        return result;
    }

    private void addIfNotNull(List<Reporter> result, Reporter reporter) {
        if (reporter != null) {
            result.add(reporter);
        }
    }

    public RunResult close() {
        this.runCompleted();
        return this.globalStats.getRunResult();
    }

    private ConsoleLogger createConsoleLogger() {
        return new DefaultDirectConsoleReporter(this.reporterConfiguration.getOriginalSystemOut());
    }

    public void runStarting() {
        ConsoleLogger consoleReporter = this.createConsoleLogger();
        consoleReporter.info("");
        consoleReporter.info("-------------------------------------------------------");
        consoleReporter.info(" T E S T S");
        consoleReporter.info("-------------------------------------------------------");
    }

    private void runCompleted() {
        ConsoleLogger logger = this.createConsoleLogger();
        logger.info("");
        logger.info("Results :");
        logger.info("");
        if (this.globalStats.hadFailures()) {
            this.multicastingReporter.writeMessage("Failed tests: ");
            for (Object o : this.globalStats.getFailureSources()) {
                logger.info("  " + o);
            }
            logger.info("");
        }
        if (this.globalStats.hadErrors()) {
            logger.info("Tests in error: ");
            for (Object o : this.globalStats.getErrorSources()) {
                logger.info("  " + o);
            }
            logger.info("");
        }
        logger.info(this.globalStats.getSummary());
        logger.info("");
    }

    public RunStatistics getGlobalRunStatistics() {
        return this.globalStats;
    }

    public static FileReporterFactory defaultNoXml() {
        return new FileReporterFactory(StartupReportConfiguration.defaultNoXml());
    }
}

