/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ForkNumberBucket {
    private static final ForkNumberBucket INSTANCE = new ForkNumberBucket();
    private Queue<Integer> qFree = new ConcurrentLinkedQueue<Integer>();
    private AtomicInteger highWaterMark = new AtomicInteger(1);

    protected ForkNumberBucket() {
    }

    public static int drawNumber() {
        return ForkNumberBucket.getInstance().drawNumberInternal();
    }

    public static void returnNumber(int number) {
        ForkNumberBucket.getInstance().returnNumberInternal(number);
    }

    private static ForkNumberBucket getInstance() {
        return INSTANCE;
    }

    protected int drawNumberInternal() {
        Integer nextFree = this.qFree.poll();
        if (null == nextFree) {
            return this.highWaterMark.getAndIncrement();
        }
        return nextFree;
    }

    protected int getHighestDrawnNumber() {
        return this.highWaterMark.get() - 1;
    }

    protected void returnNumberInternal(int number) {
        this.qFree.add(number);
    }
}

