/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.ProviderList;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.report.BriefConsoleReporter;
import org.apache.maven.surefire.report.BriefFileReporter;
import org.apache.maven.surefire.report.ConsoleReporter;
import org.apache.maven.surefire.report.DetailedConsoleReporter;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ForkingConsoleReporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private static final String BRIEF_REPORT_FORMAT = "brief";
    private static final String PLAIN_REPORT_FORMAT = "plain";
    protected SurefireDependencyResolver dependencyResolver;
    private Artifact surefireArtifact;
    ProviderList wellKnownProviders;

    protected abstract String getPluginName();

    protected abstract boolean verifyParameters() throws MojoFailureException;

    protected List initialize() throws MojoFailureException {
        this.dependencyResolver = new SurefireDependencyResolver(this.getArtifactResolver(), this.getArtifactFactory(), this.getLog(), this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), this.getPluginName());
        try {
            this.wellKnownProviders = new ProviderList(new ProviderInfo[]{new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact()), new JUnit4ProviderInfo(this.getJunitArtifact()), new JUnit3ProviderInfo()}, new DynamicProviderInfo(null));
            return this.wellKnownProviders.resolve(this.getLog());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void logReportsDirectory() {
        this.getLog().info((CharSequence)(StringUtils.capitalizeFirstLetter((String)this.getPluginName()) + " report directory: " + this.getReportsDirectory()));
    }

    protected final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void convertTestNGParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && this.getParallel().trim().length() > 0;
    }

    private void convertJunitCoreParameters() {
        if (this.getProperties() == null) {
            this.setProperties(new Properties());
        }
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadCount", Integer.toString(this.getThreadCount()));
        }
        if (this.getPerCoreThreadCount() != null) {
            this.getProperties().setProperty("perCoreThreadCount", this.getPerCoreThreadCount());
        }
        if (this.getUseUnlimitedThreads() != null) {
            this.getProperties().setProperty("useUnlimitedThreads", this.getUseUnlimitedThreads());
        }
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    protected boolean isForkModeNever() {
        return "never".equals(this.getForkMode());
    }

    protected ProviderConfiguration createProviderConfiguration(ForkConfiguration forkConfiguration) throws MojoExecutionException, MojoFailureException {
        Properties providerProperties;
        boolean failIfNoTests;
        Artifact testNgArtifact;
        List reports = this.getReporters(forkConfiguration.isForking());
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(reports, this.getReportsDirectory(), Boolean.valueOf(this.isTrimStackTrace()));
        this.surefireArtifact = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (this.surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        this.surefireArtifact.isSnapshot();
        try {
            this.addArtifact(forkConfiguration.getBootClasspath(), this.surefireArtifact);
            testNgArtifact = this.getTestNgArtifact();
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        DirectoryScannerParameters directoryScannerParameters = null;
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        List<File> testXml = this.getSuiteXmlFiles() != null ? Arrays.asList(this.getSuiteXmlFiles()) : null;
        TestRequest testSuiteDefinition = new TestRequest(testXml, this.getTestSourceDirectory(), this.getTest());
        if (this.isValidSuiteXmlFileConfig() && this.getTest() == null) {
            boolean bl = failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            if (this.isSpecificTestSpecified() && this.getFailIfNoTests() == null) {
                this.setFailIfNoTests(Boolean.TRUE);
            }
            failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            List includes = this.getIncludeList();
            List excludes = this.getExcludeList();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), includes, excludes, Boolean.valueOf(failIfNoTests), this.getRunOrder());
        }
        if ((providerProperties = this.getProperties()) == null) {
            providerProperties = new Properties();
        }
        ProviderConfiguration providerConfiguration1 = new ProviderConfiguration(directoryScannerParameters, failIfNoTests, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null);
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in " + this.getPluginName() + "-plugin: " + tc));
            if (this.isForkModeNever()) {
                this.setForkMode("once");
            }
            if (this.getJvm() != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.getJvm()));
            } else {
                this.setJvm(tc.findTool("java"));
            }
        }
        return providerConfiguration1;
    }

    protected StartupConfiguration createStartupConfiguration(ForkConfiguration forkConfiguration, ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        List classpathElements;
        String providerName;
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(this.isEnableAssertions(), this.isChildDelegation());
        this.surefireArtifact = (Artifact)this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (this.surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        this.surefireArtifact.isSnapshot();
        try {
            this.addArtifact(forkConfiguration.getBootClasspath(), this.surefireArtifact);
            provider.addProviderProperties();
            provider.addProviderArtifactToBootClasspath(forkConfiguration.getBootClasspath());
            provider.addProviderArtifactToSurefireClasspath(classpathConfiguration);
            providerName = provider.getProviderName();
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            classpathElements = this.generateTestClasspath();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to generate test classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        Iterator i = classpathElements.iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            this.getLog().debug((CharSequence)("  " + classpathElement));
            classpathConfiguration.addClasspathUrl(classpathElement);
        }
        return new StartupConfiguration(providerName, classpathConfiguration, classLoaderConfiguration, forkConfiguration.isForking(), false, this.isRedirectTestOutputToFile());
    }

    private boolean isSpecificTestSpecified() {
        return this.getTest() != null;
    }

    private boolean isValidSuiteXmlFileConfig() {
        return this.getSuiteXmlFiles() != null && this.getSuiteXmlFiles().length > 0;
    }

    private List getExcludeList() {
        ArrayList<Object> excludes;
        if (this.isSpecificTestSpecified()) {
            excludes = new ArrayList();
        } else {
            excludes = this.getExcludes();
            if (excludes == null || excludes.size() == 0) {
                excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
            }
        }
        return excludes;
    }

    private List getIncludeList() {
        ArrayList<Object> includes;
        if (this.isSpecificTestSpecified()) {
            includes = new ArrayList();
            String[] testRegexes = StringUtils.split((String)this.getTest(), (String)",");
            for (int i = 0; i < testRegexes.length; ++i) {
                String testRegex = testRegexes[i];
                if (testRegex.endsWith(".java")) {
                    testRegex = testRegex.substring(0, testRegex.length() - 5);
                }
                testRegex = testRegex.replace('.', '/');
                includes.add("**/" + testRegex + ".java");
            }
        } else {
            includes = this.getIncludes();
            if (includes == null || includes.size() == 0) {
                includes = new ArrayList<String>(Arrays.asList(this.getDefaultIncludes()));
            }
        }
        return includes;
    }

    private Artifact getTestNgArtifact() throws MojoFailureException, InvalidVersionSpecificationException {
        VersionRange range;
        Artifact artifact = (Artifact)this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        if (artifact != null && !(range = VersionRange.createFromVersionSpec((String)"[4.7,)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
            throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
        }
        return artifact;
    }

    private Artifact getJunitArtifact() {
        Artifact junitArtifact = (Artifact)this.getProjectArtifactMap().get(this.getJunitArtifactName());
        if (junitArtifact == null && "junit:junit".equals(this.getJunitArtifactName())) {
            junitArtifact = (Artifact)this.getProjectArtifactMap().get("junit:junit-dep");
        }
        return junitArtifact;
    }

    protected ForkStarter createForkStarter(ProviderInfo provider, ForkConfiguration forkConfiguration, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(forkConfiguration, provider, classLoaderConfiguration);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(forkConfiguration);
        return new ForkStarter(providerConfiguration, startupConfiguration, this.getReportsDirectory(), forkConfiguration, this.getForkedProcessTimeoutInSeconds());
    }

    protected ForkConfiguration getForkConfiguration() {
        Classpath bootClasspathConfiguration = new Classpath();
        ForkConfiguration fork = new ForkConfiguration(bootClasspathConfiguration);
        fork.setForkMode(this.getForkMode());
        File tmpDir = new File(this.getReportsDirectory().getParentFile(), "surefire");
        tmpDir.mkdirs();
        fork.setTempDirectory(tmpDir);
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.getInternalSystemProperties(), "system property");
        }
        if (fork.isForking()) {
            List<String> args;
            this.setUseSystemClassLoader(this.getUseSystemClassLoader() == null ? Boolean.TRUE : this.getUseSystemClassLoader());
            fork.setSystemProperties(this.getInternalSystemProperties());
            if ("true".equals(this.getDebugForkedProcess())) {
                this.setDebugForkedProcess("-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
            }
            fork.setDebugLine(this.getDebugForkedProcess());
            if (this.getJvm() == null || "".equals(this.getJvm())) {
                this.setJvm(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
                this.getLog().debug((CharSequence)("Using JVM: " + this.getJvm()));
            }
            fork.setJvmExecutable(this.getJvm());
            if (this.getWorkingDirectory() != null) {
                fork.setWorkingDirectory(this.getWorkingDirectory());
            } else {
                fork.setWorkingDirectory(this.getBasedir());
            }
            fork.setArgLine(this.getArgLine());
            fork.setEnvironmentVariables(this.getEnvironmentVariables());
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.getEnvironmentVariables(), "environment variable");
                fork.setDebug(true);
            }
            if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.setEnableAssertions(false);
            }
        }
        return fork;
    }

    protected ClassLoaderConfiguration getClassLoaderConfiguration(ForkConfiguration fork) {
        return fork.isForking() ? new ClassLoaderConfiguration(this.getUseSystemClassLoader().booleanValue(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    protected abstract String[] getDefaultIncludes();

    public List generateTestClasspath() throws DependencyResolutionRequiredException, MojoExecutionException {
        PatternIncludesArtifactFilter dependencyFilter;
        ArrayList<String> classpath = new ArrayList<String>(2 + this.getProject().getArtifacts().size());
        classpath.add(this.getTestClassesDirectory().getAbsolutePath());
        classpath.add(this.getClassesDirectory().getAbsolutePath());
        Set classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().equals("")) {
            dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            dependencyFilter = new PatternIncludesArtifactFilter(this.getClasspathDependencyExcludes());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        Iterator iter = classpathArtifacts.iterator();
        while (iter.hasNext()) {
            File file;
            Artifact artifact = (Artifact)iter.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getPath());
        }
        if (this.getAdditionalClasspathElements() != null) {
            iter = this.getAdditionalClasspathElements().iterator();
            while (iter.hasNext()) {
                String classpathElement = (String)iter.next();
                classpath.add(classpathElement);
            }
        }
        return classpath;
    }

    private Set filterArtifacts(Set artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map map, String setting) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.getArtifactFactory().createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.getArtifactResolver().resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), (ArtifactFilter)filter);
    }

    private void addArtifact(Classpath bootClasspath, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
            bootClasspath.addClassPathElementUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        String value;
        String key;
        String value2;
        String key2;
        Iterator<Object> i;
        if (this.getSystemProperties() != null) {
            i = this.getSystemProperties().keySet().iterator();
            while (i.hasNext()) {
                key2 = (String)i.next();
                value2 = (String)this.getSystemProperties().get(key2);
                this.getInternalSystemProperties().setProperty(key2, value2);
            }
        }
        if (this.getSystemPropertyVariables() != null) {
            i = this.getSystemPropertyVariables().keySet().iterator();
            while (i.hasNext()) {
                key2 = (String)i.next();
                value2 = (String)this.getSystemPropertyVariables().get(key2);
                if (value2 == null) continue;
                this.getInternalSystemProperties().setProperty(key2, value2);
            }
        }
        this.setOriginalSystemProperties((Properties)System.getProperties().clone());
        Properties userProperties = this.getUserProperties();
        Iterator<Object> it = userProperties.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            value = userProperties.getProperty(key);
            this.getInternalSystemProperties().setProperty(key, value);
        }
        this.getInternalSystemProperties().setProperty("basedir", this.getBasedir().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        this.getInternalSystemProperties().setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (setInSystem) {
            Iterator<Object> iter = this.getInternalSystemProperties().keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = this.getInternalSystemProperties().getProperty(key);
                System.setProperty(key, value);
            }
        }
    }

    private Properties getUserProperties() {
        Properties props = null;
        try {
            Method getUserProperties = this.getSession().getClass().getMethod("getUserProperties", null);
            props = (Properties)getUserProperties.invoke((Object)this.getSession(), null);
        }
        catch (Exception e) {
            String msg = "Build uses Maven 2.0.x, cannot propagate system properties from command line to tests (cf. SUREFIRE-121)";
            if (this.getLog().isDebugEnabled()) {
                this.getLog().warn((CharSequence)msg, (Throwable)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    private List getReporters(boolean forking) {
        ArrayList<String> reports = new ArrayList<String>();
        String consoleReporter = this.getConsoleReporter(forking);
        if (consoleReporter != null) {
            reports.add(consoleReporter);
        }
        if (this.isUseFile()) {
            if (BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
                reports.add(BriefFileReporter.class.getName());
            } else if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
                reports.add(FileReporter.class.getName());
            }
        }
        if (!this.isDisableXmlReport()) {
            reports.add(XMLReporter.class.getName());
        }
        return reports;
    }

    private String getConsoleReporter(boolean forking) {
        if (this.isUseFile()) {
            if (this.isPrintSummary()) {
                return forking ? ForkingConsoleReporter.class.getName() : ConsoleReporter.class.getName();
            }
        } else {
            if (BRIEF_REPORT_FORMAT.equals(this.getReportFormat())) {
                return BriefConsoleReporter.class.getName();
            }
            if (PLAIN_REPORT_FORMAT.equals(this.getReportFormat())) {
                return DetailedConsoleReporter.class.getName();
            }
        }
        return null;
    }

    protected void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    protected void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isForkModeNever()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkmode NEVER");
        }
    }

    protected void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.getUseSystemClassLoader() != null && this.isForkModeNever()) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
    }

    public class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        public String getProviderName() {
            return this.providerName;
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public void addProviderArtifactToBootClasspath(Classpath bootclasspath) {
        }

        public void addProviderArtifactToSurefireClasspath(ClasspathConfiguration classpathConfiguration) throws ArtifactResolutionException, ArtifactNotFoundException {
            Map pluginArtifactMap = AbstractSurefireMojo.this.getPluginArtifactMap();
            Artifact plugin = (Artifact)pluginArtifactMap.get("org.apache.maven.plugins:maven-surefire-plugin");
            AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(classpathConfiguration, pluginArtifactMap, plugin);
        }
    }

    class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact) {
            this.junitArtifact = junitArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        public boolean isApplicable() {
            return AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isAnyConcurrencySelected() && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
        }

        public void addProviderArtifactToBootClasspath(Classpath bootclasspath) {
        }

        public void addProviderArtifactToSurefireClasspath(ClasspathConfiguration classpathConfiguration) throws ArtifactResolutionException, ArtifactNotFoundException {
            AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(classpathConfiguration, "surefire-junit47", AbstractSurefireMojo.this.surefireArtifact.getBaseVersion(), null);
        }
    }

    class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact) {
            this.junitArtifact = junitArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        public boolean isApplicable() {
            return AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        public void addProviderProperties() {
        }

        public void addProviderArtifactToBootClasspath(Classpath bootclasspath) {
        }

        public void addProviderArtifactToSurefireClasspath(ClasspathConfiguration classpathConfiguration) throws ArtifactResolutionException, ArtifactNotFoundException {
            AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(classpathConfiguration, "surefire-junit4", AbstractSurefireMojo.this.surefireArtifact.getBaseVersion(), null);
        }
    }

    class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
        }

        public void addProviderArtifactToBootClasspath(Classpath bootclasspath) {
        }

        public void addProviderArtifactToSurefireClasspath(ClasspathConfiguration classpathConfiguration) throws ArtifactResolutionException, ArtifactNotFoundException {
            AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(classpathConfiguration, "surefire-junit3", AbstractSurefireMojo.this.surefireArtifact.getBaseVersion(), null);
        }
    }

    class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public void addProviderArtifactToBootClasspath(Classpath bootclasspath) throws ArtifactResolutionException, ArtifactNotFoundException {
            AbstractSurefireMojo.this.dependencyResolver.addResolvedArtifactToClasspath(bootclasspath, this.testNgArtifact);
        }

        public void addProviderArtifactToSurefireClasspath(ClasspathConfiguration bootclasspath) throws ArtifactResolutionException, ArtifactNotFoundException {
            Artifact surefireArtifact = (Artifact)AbstractSurefireMojo.this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
            AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(bootclasspath, "surefire-testng", surefireArtifact.getBaseVersion(), this.testNgArtifact);
        }
    }
}

