/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    protected final String testClass;
    protected final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    public String writeTraceToString() {
        StringWriter w = new StringWriter();
        if (this.t != null) {
            this.t.printStackTrace(new PrintWriter(w));
            w.flush();
        }
        return w.toString();
    }

    public String writeTrimmedTraceToString() {
        int i;
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = StringUtils.split(text, "\n");
        int lastLine = lines.length - 1;
        int causedByLine = -1;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line = lines[i2].trim();
            if (line.startsWith(marker)) {
                lastLine = i2;
                continue;
            }
            if (!line.startsWith("Caused by")) continue;
            causedByLine = i2;
            break;
        }
        StringBuffer trace = new StringBuffer();
        for (i = 0; i <= lastLine; ++i) {
            trace.append(lines[i]);
            trace.append("\n");
        }
        if (causedByLine != -1) {
            for (i = causedByLine; i < lines.length; ++i) {
                trace.append(lines[i]);
                trace.append("\n");
            }
        }
        return trace.toString();
    }

    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.t);
    }
}

