/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;

public class SimpleReportEntry
implements ReportEntry {
    private final String source;
    private final String name;
    private final StackTraceWriter stackTraceWriter;
    private final Integer elapsed;
    private final String message;

    public SimpleReportEntry() {
        this(null, null);
    }

    public SimpleReportEntry(String source, String name) {
        this(source, name, null, null);
    }

    private SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter) {
        this(source, name, stackTraceWriter, null);
    }

    public SimpleReportEntry(String source, String name, Integer elapsed) {
        this(source, name, null, elapsed);
    }

    public SimpleReportEntry(String source, String name, String message) {
        this(source, name, null, null, message);
    }

    protected SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter, Integer elapsed, String message) {
        if (source == null) {
            source = "null";
        }
        if (name == null) {
            name = "null";
        }
        this.source = source;
        this.name = name;
        this.stackTraceWriter = stackTraceWriter;
        this.message = message;
        this.elapsed = elapsed;
    }

    public SimpleReportEntry(String source, String name, StackTraceWriter stackTraceWriter, Integer elapsed) {
        this(source, name, stackTraceWriter, elapsed, SimpleReportEntry.safeGetMessage(stackTraceWriter));
    }

    public static SimpleReportEntry assumption(String source, String name, String message) {
        return new SimpleReportEntry(source, name, message);
    }

    public static SimpleReportEntry ignored(String source, String name, String message) {
        return new SimpleReportEntry(source, name, message);
    }

    public static SimpleReportEntry withException(String source, String name, StackTraceWriter stackTraceWriter) {
        return new SimpleReportEntry(source, name, stackTraceWriter);
    }

    private static String safeGetMessage(StackTraceWriter stackTraceWriter) {
        try {
            SafeThrowable t = stackTraceWriter == null ? null : stackTraceWriter.getThrowable();
            return t == null ? null : t.getMessage();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    @Override
    public String getSourceName() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    @Override
    public Integer getElapsed() {
        return this.elapsed;
    }

    public String toString() {
        return "ReportEntry{source='" + this.source + '\'' + ", name='" + this.name + '\'' + ", stackTraceWriter=" + this.stackTraceWriter + ", elapsed=" + this.elapsed + ",message=" + this.message + '}';
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleReportEntry that = (SimpleReportEntry)o;
        if (this.elapsed != null ? !this.elapsed.equals(that.elapsed) : that.elapsed != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.stackTraceWriter != null ? !this.stackTraceWriter.equals(that.stackTraceWriter) : that.stackTraceWriter != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.stackTraceWriter != null ? this.stackTraceWriter.hashCode() : 0);
        result = 31 * result + (this.elapsed != null ? this.elapsed.hashCode() : 0);
        return result;
    }

    @Override
    public String getNameWithGroup() {
        return this.getName();
    }
}

