/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CloseableIterator<T>
implements Iterator<T> {
    private Boolean finishCurrentIteration;

    protected abstract boolean isClosed();

    protected abstract boolean doHasNext();

    protected abstract T doNext();

    protected abstract void doRemove();

    @Override
    public boolean hasNext() {
        this.popMarker();
        return this.finishCurrentIteration == false && this.doHasNext();
    }

    @Override
    public T next() {
        try {
            if (this.popMarker() && this.finishCurrentIteration.booleanValue()) {
                throw new NoSuchElementException("iterator closed");
            }
            T t = this.doNext();
            return t;
        }
        finally {
            this.finishCurrentIteration = null;
        }
    }

    @Override
    public void remove() {
        try {
            if (this.popMarker() && this.finishCurrentIteration.booleanValue()) {
                throw new IllegalStateException("iterator closed");
            }
            this.doRemove();
        }
        finally {
            this.finishCurrentIteration = null;
        }
    }

    private boolean popMarker() {
        if (this.finishCurrentIteration == null) {
            this.finishCurrentIteration = this.isClosed();
            return true;
        }
        return false;
    }
}

