/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.testset.AbstractTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class PojoTestSet
extends AbstractTestSet {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private static final String TEST_METHOD_PREFIX = "test";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Object testObject;
    protected List testMethods;

    public PojoTestSet(Class testClass) throws TestSetFailedException {
        super(testClass);
        try {
            this.testObject = testClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException("Unable to instantiate POJO '" + testClass + "'", e);
        }
    }

    public void execute(ReporterManager reportManager, ClassLoader loader) throws TestSetFailedException {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.executeTestMethods(reportManager);
    }

    protected void executeTestMethods(ReporterManager reportManager) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (this.testMethods == null) {
            this.discoverTestMethods();
        }
        boolean abort = false;
        for (int i = 0; i < this.testMethods.size() && !abort; ++i) {
            abort = this.executeTestMethod((Method)this.testMethods.get(i), EMPTY_OBJECT_ARRAY, reportManager);
        }
    }

    protected boolean executeTestMethod(Method method, Object[] args, ReporterManager reportManager) {
        if (method == null || args == null || reportManager == null) {
            throw new NullPointerException();
        }
        String userFriendlyMethodName = method.getName() + '(';
        if (args.length != 0) {
            userFriendlyMethodName = userFriendlyMethodName + "Reporter";
        }
        userFriendlyMethodName = userFriendlyMethodName + ')';
        DefaultReportEntry report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), this.getName());
        reportManager.testStarting(report);
        try {
            this.setUpFixture();
        }
        catch (Exception e) {
            String rawString = this.bundle.getString("setupFixtureFailed");
            MessageFormat msgFmt = new MessageFormat(rawString);
            Object[] stringArgs = new Object[]{method.getName()};
            String stringToPrint = msgFmt.format(stringArgs);
            report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), stringToPrint, new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), e));
            reportManager.testFailed(report);
            return true;
        }
        try {
            method.invoke(this.testObject, args);
            report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), this.getName());
            reportManager.testSucceeded(report);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), msg, new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), msg, new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
        }
        try {
            this.tearDownFixture();
        }
        catch (Throwable t) {
            String rawString = this.bundle.getString("cleanupFixtureFailed");
            MessageFormat msgFmt = new MessageFormat(rawString);
            Object[] stringArgs = new Object[]{method.getName()};
            String stringToPrint = msgFmt.format(stringArgs);
            report = new DefaultReportEntry(this.testObject.getClass().getName(), this.getTestName(userFriendlyMethodName), stringToPrint, new PojoStackTraceWriter(this.testObject.getClass().getName(), method.getName(), t));
            reportManager.testFailed(report);
            return true;
        }
        return false;
    }

    public String getTestName(String testMethodName) {
        if (testMethodName == null) {
            throw new NullPointerException("testMethodName is null");
        }
        return this.getTestClass().getName() + "." + testMethodName;
    }

    public void setUpFixture() {
    }

    public void tearDownFixture() {
    }

    private void discoverTestMethods() {
        if (this.testMethods == null) {
            this.testMethods = new ArrayList();
            Method[] methods = this.getTestClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String firstFour;
                String simpleName;
                Method m = methods[i];
                if (!PojoTestSet.isValidTestMethod(m) || (simpleName = m.getName()).length() <= 4 || !(firstFour = simpleName.substring(0, 4)).equals(TEST_METHOD_PREFIX)) continue;
                this.testMethods.add(m);
            }
        }
    }

    private static boolean isValidTestMethod(Method m) {
        boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
        boolean returnsVoid = m.getReturnType().equals(Void.TYPE);
        boolean hasNoParams = m.getParameterTypes().length == 0;
        return isInstanceMethod && returnsVoid && hasNoParams;
    }
}

