/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.report;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.api.report.ConsoleOutputReceiver;

public final class ConsoleOutputCapture {
    public static void startCapture(ConsoleOutputReceiver target) {
        System.setOut(new ForwardingPrintStream(true, target));
        System.setErr(new ForwardingPrintStream(false, target));
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }
    }

    private static final class ForwardingPrintStream
    extends PrintStream {
        private final boolean isStdout;
        private final ConsoleOutputReceiver target;

        ForwardingPrintStream(boolean stdout, ConsoleOutputReceiver target) {
            super(new NullOutputStream());
            this.isStdout = stdout;
            this.target = target;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.target.writeTestOutput(new String(buf, off, len), false, this.isStdout);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) {
            try {
                this.write(new byte[]{(byte)b});
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void println(boolean x) {
            this.println(x ? "true" : "false");
        }

        @Override
        public void println(char x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(double x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(char[] x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(Object x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(String s) {
            this.target.writeTestOutput(s == null ? "null" : s, true, this.isStdout);
        }

        @Override
        public void println() {
            this.target.writeTestOutput("", true, this.isStdout);
        }

        @Override
        public void print(boolean x) {
            this.print(x ? "true" : "false");
        }

        @Override
        public void print(char x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(int x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(long x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(float x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(double x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(char[] x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(Object x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(String s) {
            this.target.writeTestOutput(s == null ? "null" : s, false, this.isStdout);
        }

        @Override
        public PrintStream append(CharSequence csq) {
            this.print(csq == null ? "null" : csq.toString());
            return this;
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            CharSequence s = csq == null ? "null" : csq;
            this.print(s.subSequence(start, end).toString());
            return this;
        }

        @Override
        public PrintStream append(char c) {
            this.print(c);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

