/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.output.FileOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.booter.output.SupressFooterOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.SupressHeaderOutputConsumerProxy;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.IOUtil;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.StringUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineException;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.CommandLineUtils;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.Commandline;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.cli.StreamConsumer;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.UrlUtils;

public class SurefireBooter {
    private static final String TEST_SUITE_PROPERTY_PREFIX = "testSuite.";
    private static final String REPORT_PROPERTY_PREFIX = "report.";
    private static final String PARAMS_SUFIX = ".params";
    private static final String TYPES_SUFIX = ".types";
    private List reports = new ArrayList();
    private List classPathUrls = new ArrayList();
    private List surefireClassPathUrls = new ArrayList();
    private List surefireBootClassPathUrls = new ArrayList();
    private List testSuites = new ArrayList();
    private boolean failIfNoTests = false;
    private int forkedProcessTimeoutInSeconds = 0;
    private boolean redirectTestOutputToFile = false;
    private ForkConfiguration forkConfiguration;
    public static final int TESTS_SUCCEEDED_EXIT_CODE = 0;
    public static final int TESTS_FAILED_EXIT_CODE = 255;
    public static final int NO_TESTS_EXIT_CODE = 254;
    private static Method assertionStatusMethod;
    private boolean childDelegation = true;
    private File reportsDirectory;
    private final boolean isForked;
    private boolean enableAssertions;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$maven$surefire$Surefire;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class array$Ljava$io$File;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Integer;

    public SurefireBooter() {
        this.isForked = false;
    }

    private SurefireBooter(boolean isForked) {
        this.isForked = isForked;
    }

    public void addReport(String report) {
        this.addReport(report, null);
    }

    public void addReport(String report, Object[] constructorParams) {
        this.reports.add(new Object[]{report, constructorParams});
    }

    public void addTestSuite(String suiteClassName, Object[] constructorParams) {
        this.testSuites.add(new Object[]{suiteClassName, constructorParams});
    }

    public void addClassPathUrl(String path) {
        if (!this.classPathUrls.contains(path)) {
            this.classPathUrls.add(path);
        }
    }

    public void addSurefireClassPathUrl(String path) {
        if (!this.surefireClassPathUrls.contains(path)) {
            this.surefireClassPathUrls.add(path);
        }
    }

    public void addSurefireBootClassPathUrl(String path) {
        if (!this.surefireBootClassPathUrls.contains(path)) {
            this.surefireBootClassPathUrls.add(path);
        }
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setForkConfiguration(ForkConfiguration forkConfiguration) {
        this.forkConfiguration = forkConfiguration;
    }

    public boolean isForking() {
        return this.forkConfiguration.isForking();
    }

    public int run() throws SurefireBooterForkException, SurefireExecutionException {
        int result;
        if ("never".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesInProcess();
        } else if ("once".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesForkOnce();
        } else if ("always".equals(this.forkConfiguration.getForkMode())) {
            result = this.runSuitesForkPerTestSet();
        } else {
            throw new SurefireExecutionException("Unknown forkmode: " + this.forkConfiguration.getForkMode(), null);
        }
        return result;
    }

    private int runSuitesInProcess(String testSet, Properties results) throws SurefireExecutionException {
        if (this.testSuites.size() != 1) {
            throw new IllegalArgumentException("Cannot only specify testSet for single test suites");
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader testsClassLoader = this.useSystemClassLoader() ? ClassLoader.getSystemClassLoader() : this.createClassLoader(this.classPathUrls, null, this.childDelegation);
            ClassLoader surefireClassLoader = this.createClassLoader(this.surefireClassPathUrls, testsClassLoader);
            Class<?> surefireClass = surefireClassLoader.loadClass((class$org$apache$maven$surefire$Surefire == null ? (class$org$apache$maven$surefire$Surefire = SurefireBooter.class$("org.apache.maven.surefire.Surefire")) : class$org$apache$maven$surefire$Surefire).getName());
            Object surefire = surefireClass.newInstance();
            Method run = surefireClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SurefireBooter.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$java$lang$String == null ? (class$java$lang$String = SurefireBooter.class$("java.lang.String")) : class$java$lang$String, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$util$Properties == null ? (class$java$util$Properties = SurefireBooter.class$("java.util.Properties")) : class$java$util$Properties, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SurefireBooter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            Thread.currentThread().setContextClassLoader(testsClassLoader);
            Integer result = (Integer)run.invoke(surefire, this.reports, this.testSuites.get(0), testSet, surefireClassLoader, testsClassLoader, results, new Boolean(this.failIfNoTests));
            int n = result;
            return n;
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new SurefireExecutionException("Unable to instantiate and execute Surefire", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private int runSuitesInProcess() throws SurefireExecutionException {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader testsClassLoader;
            String testClassPath = this.getTestClassPathAsString();
            System.setProperty("surefire.test.class.path", testClassPath);
            if (this.useManifestOnlyJar()) {
                testsClassLoader = this.getClass().getClassLoader();
                System.setProperty("surefire.real.class.path", System.getProperty("java.class.path"));
                System.setProperty("java.class.path", testClassPath);
            } else {
                testsClassLoader = this.createClassLoader(this.classPathUrls, null, this.childDelegation);
            }
            ClassLoader surefireClassLoader = this.createClassLoader(this.surefireClassPathUrls, testsClassLoader);
            Class<?> surefireClass = surefireClassLoader.loadClass((class$org$apache$maven$surefire$Surefire == null ? (class$org$apache$maven$surefire$Surefire = SurefireBooter.class$("org.apache.maven.surefire.Surefire")) : class$org$apache$maven$surefire$Surefire).getName());
            Object surefire = surefireClass.newInstance();
            Method run = surefireClass.getMethod("run", class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$util$List == null ? (class$java$util$List = SurefireBooter.class$("java.util.List")) : class$java$util$List, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SurefireBooter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            Thread.currentThread().setContextClassLoader(testsClassLoader);
            Integer result = (Integer)run.invoke(surefire, this.reports, this.testSuites, surefireClassLoader, testsClassLoader, new Boolean(this.failIfNoTests));
            int n = result;
            return n;
        }
        catch (InvocationTargetException e) {
            throw new SurefireExecutionException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            throw new SurefireExecutionException("Unable to instantiate and execute Surefire", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private String getTestClassPathAsString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.classPathUrls.size(); ++i) {
            sb.append(this.classPathUrls.get(i)).append(File.pathSeparatorChar);
        }
        return sb.toString();
    }

    private int runSuitesForkOnce() throws SurefireBooterForkException {
        return this.forkSuites(this.testSuites, true, true);
    }

    private int runSuitesForkPerTestSet() throws SurefireBooterForkException {
        ClassLoader surefireClassLoader;
        ClassLoader testsClassLoader;
        try {
            testsClassLoader = this.createClassLoader(this.classPathUrls, null, false);
            surefireClassLoader = this.createClassLoader(this.surefireClassPathUrls, testsClassLoader, false);
        }
        catch (MalformedURLException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", e);
        }
        int globalResult = 0;
        boolean showHeading = true;
        Properties properties = new Properties();
        Iterator i = this.testSuites.iterator();
        while (i.hasNext()) {
            Object[] testSuite = (Object[])i.next();
            Map testSets = this.getTestSets(testSuite, testsClassLoader, surefireClassLoader);
            Iterator j = testSets.keySet().iterator();
            while (j.hasNext()) {
                boolean showFooter;
                Object testSet = j.next();
                int result = this.forkSuite(testSuite, testSet, showHeading, showFooter = !j.hasNext() && !i.hasNext(), properties);
                if (result > globalResult) {
                    globalResult = result;
                }
                showHeading = false;
            }
        }
        return globalResult;
    }

    private Map getTestSets(Object[] testSuite, ClassLoader testsClassLoader, ClassLoader surefireClassLoader) throws SurefireBooterForkException {
        Map testSets;
        Object suite;
        String className = (String)testSuite[0];
        Object[] params = (Object[])testSuite[1];
        try {
            suite = Surefire.instantiateObject((String)className, (Object[])params, (ClassLoader)surefireClassLoader);
        }
        catch (TestSetFailedException e) {
            throw new SurefireBooterForkException(e.getMessage(), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireBooterForkException("Unable to find class for test suite '" + className + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireBooterForkException("Unable to find appropriate constructor for test suite '" + className + "': " + e.getMessage(), e);
        }
        try {
            Method m = suite.getClass().getMethod("locateTestSets", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            testSets = (Map)m.invoke(suite, testsClassLoader);
        }
        catch (IllegalAccessException e) {
            throw new SurefireBooterForkException("Error obtaining test sets", e);
        }
        catch (NoSuchMethodException e) {
            throw new SurefireBooterForkException("Error obtaining test sets", e);
        }
        catch (InvocationTargetException e) {
            throw new SurefireBooterForkException(e.getTargetException().getMessage(), e.getTargetException());
        }
        return testSets;
    }

    private int forkSuites(List testSuites, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        Properties properties = new Properties();
        this.setForkProperties(testSuites, properties);
        return this.fork(properties, showHeading, showFooter);
    }

    private int forkSuite(Object[] testSuite, Object testSet, boolean showHeading, boolean showFooter, Properties properties) throws SurefireBooterForkException {
        this.setForkProperties(Collections.singletonList(testSuite), properties);
        if (testSet instanceof String) {
            properties.setProperty("testSet", (String)testSet);
        }
        return this.fork(properties, showHeading, showFooter);
    }

    private void setForkProperties(List testSuites, Properties properties) {
        String url;
        int i;
        this.addPropertiesForTypeHolder(this.reports, properties, REPORT_PROPERTY_PREFIX);
        this.addPropertiesForTypeHolder(testSuites, properties, TEST_SUITE_PROPERTY_PREFIX);
        for (i = 0; i < this.classPathUrls.size(); ++i) {
            url = (String)this.classPathUrls.get(i);
            properties.setProperty("classPathUrl." + i, url);
        }
        for (i = 0; i < this.surefireClassPathUrls.size(); ++i) {
            url = (String)this.surefireClassPathUrls.get(i);
            properties.setProperty("surefireClassPathUrl." + i, url);
        }
        properties.setProperty("childDelegation", String.valueOf(this.childDelegation));
        properties.setProperty("enableAssertions", String.valueOf(this.enableAssertions));
        properties.setProperty("useSystemClassLoader", String.valueOf(this.useSystemClassLoader()));
        properties.setProperty("useManifestOnlyJar", String.valueOf(this.useManifestOnlyJar()));
        properties.setProperty("failIfNoTests", String.valueOf(this.failIfNoTests));
    }

    private File writePropertiesFile(String name, Properties properties) throws IOException {
        File file = File.createTempFile(name, "tmp");
        if (!this.forkConfiguration.isDebug()) {
            file.deleteOnExit();
        }
        this.writePropertiesFile(file, name, properties);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(File file, String name, Properties properties) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            properties.store(out, name);
        }
        finally {
            IOUtil.close(out);
        }
    }

    private void addPropertiesForTypeHolder(List typeHolderList, Properties properties, String propertyPrefix) {
        for (int i = 0; i < typeHolderList.size(); ++i) {
            Object[] report = (Object[])typeHolderList.get(i);
            String className = (String)report[0];
            Object[] params = (Object[])report[1];
            properties.setProperty(propertyPrefix + i, className);
            if (params == null) continue;
            String paramProperty = SurefireBooter.convert(params[0]);
            String typeProperty = params[0].getClass().getName();
            for (int j = 1; j < params.length; ++j) {
                paramProperty = paramProperty + "|";
                typeProperty = typeProperty + "|";
                if (params[j] == null) continue;
                paramProperty = paramProperty + SurefireBooter.convert(params[j]);
                typeProperty = typeProperty + params[j].getClass().getName();
            }
            properties.setProperty(propertyPrefix + i + PARAMS_SUFIX, paramProperty);
            properties.setProperty(propertyPrefix + i + TYPES_SUFIX, typeProperty);
        }
    }

    private static String convert(Object param) {
        if (param instanceof File[]) {
            Object[] files = (File[])param;
            return "[" + StringUtils.join(files, ",") + "]";
        }
        if (param instanceof Properties) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ((Properties)param).store(baos, "");
                return new String(baos.toByteArray(), "8859_1");
            }
            catch (Exception e) {
                throw new RuntimeException("bug in property conversion", e);
            }
        }
        return param.toString();
    }

    private final boolean useSystemClassLoader() {
        return this.forkConfiguration.isUseSystemClassLoader() && (this.isForked || this.forkConfiguration.isForking());
    }

    private final boolean useManifestOnlyJar() {
        return this.forkConfiguration.isUseSystemClassLoader() && this.forkConfiguration.isUseManifestOnlyJar();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fork(Properties properties, boolean showHeading, boolean showFooter) throws SurefireBooterForkException {
        int returnCode;
        File surefireProperties;
        File systemProperties = null;
        try {
            surefireProperties = this.writePropertiesFile("surefire", properties);
            if (this.forkConfiguration.getSystemProperties() != null) {
                systemProperties = this.writePropertiesFile("surefire", this.forkConfiguration.getSystemProperties());
            }
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating properties files for forking", e);
        }
        ArrayList bootClasspath = new ArrayList(this.surefireBootClassPathUrls.size() + this.classPathUrls.size());
        bootClasspath.addAll(this.surefireBootClassPathUrls);
        if (this.useSystemClassLoader()) {
            bootClasspath.addAll(this.classPathUrls);
        }
        Commandline cli = this.forkConfiguration.createCommandLine(bootClasspath, this.useManifestOnlyJar());
        cli.createArg().setFile(surefireProperties);
        if (systemProperties != null) {
            cli.createArg().setFile(systemProperties);
        }
        ForkingStreamConsumer out = this.getForkingStreamConsumer(showHeading, showFooter, this.redirectTestOutputToFile);
        ForkingStreamConsumer err = this.redirectTestOutputToFile ? out : this.getForkingStreamConsumer(showHeading, showFooter, this.redirectTestOutputToFile);
        if (this.forkConfiguration.isDebug()) {
            System.out.println("Forking command line: " + cli);
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine(cli, out, (StreamConsumer)err, this.forkedProcessTimeoutInSeconds);
        }
        catch (CommandLineException e) {
            throw new SurefireBooterForkException("Error while executing forked tests.", e);
        }
        if (this.redirectTestOutputToFile) {
            try {
                out.getOutputConsumer().testSetCompleted();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (surefireProperties == null) return returnCode;
        if (!surefireProperties.exists()) return returnCode;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(surefireProperties);
            properties.load(inStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new SurefireBooterForkException("Unable to reload properties file from forked process", e);
                catch (IOException e2) {
                    throw new SurefireBooterForkException("Unable to reload properties file from forked process", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inStream);
                throw throwable;
            }
        }
        IOUtil.close(inStream);
        return returnCode;
    }

    private ClassLoader createClassLoader(List classPathUrls, ClassLoader parent) throws MalformedURLException {
        return this.createClassLoader(classPathUrls, parent, false);
    }

    private ClassLoader createClassLoader(List classPathUrls, ClassLoader parent, boolean childDelegation) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i = classPathUrls.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            if (url == null) continue;
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation);
        if (assertionStatusMethod != null) {
            try {
                Object[] args = new Object[]{this.enableAssertions ? Boolean.TRUE : Boolean.FALSE};
                if (parent != null) {
                    assertionStatusMethod.invoke((Object)parent, args);
                }
                assertionStatusMethod.invoke((Object)classLoader, args);
            }
            catch (IllegalAccessException e) {
                throw new NestedRuntimeException("Unable to access the assertion enablement method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new NestedRuntimeException("Unable to invoke the assertion enablement method", (Throwable)e);
            }
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            classLoader.addURL(url);
        }
        return classLoader;
    }

    private static List processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split(sl, ",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        if (file != null && file.exists()) {
            FileInputStream inStream = new FileInputStream(file);
            try {
                p.load(inStream);
            }
            finally {
                IOUtil.close(inStream);
            }
        }
        return p;
    }

    private static void setSystemProperties(File file) throws IOException {
        Properties p = SurefireBooter.loadProperties(file);
        Iterator<Object> i = p.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.setProperty(key, p.getProperty(key));
        }
    }

    private static Object[] constructParamObjects(String paramProperty, String typeProperty) {
        Object[] paramObjects = null;
        if (paramProperty != null) {
            String[] params = StringUtils.split(StringUtils.replace(StringUtils.replace(paramProperty, "||", "| |"), "||", "| |"), "|");
            String[] types = StringUtils.split(StringUtils.replace(StringUtils.replace(typeProperty, "||", "| |"), "||", "| |"), "|");
            paramObjects = new Object[params.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i].trim().length() == 0) {
                    params[i] = null;
                    continue;
                }
                if (types[i].equals((class$java$lang$String == null ? SurefireBooter.class$("java.lang.String") : class$java$lang$String).getName())) {
                    paramObjects[i] = params[i];
                    continue;
                }
                if (types[i].equals((class$java$io$File == null ? SurefireBooter.class$("java.io.File") : class$java$io$File).getName())) {
                    paramObjects[i] = new File(params[i]);
                    continue;
                }
                if (types[i].equals((array$Ljava$io$File == null ? SurefireBooter.class$("[Ljava.io.File;") : array$Ljava$io$File).getName())) {
                    List stringList = SurefireBooter.processStringList(params[i]);
                    File[] fileList = new File[stringList.size()];
                    for (int j = 0; j < stringList.size(); ++j) {
                        fileList[j] = new File((String)stringList.get(j));
                    }
                    paramObjects[i] = fileList;
                    continue;
                }
                if (types[i].equals((class$java$util$ArrayList == null ? SurefireBooter.class$("java.util.ArrayList") : class$java$util$ArrayList).getName())) {
                    paramObjects[i] = SurefireBooter.processStringList(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$lang$Boolean == null ? SurefireBooter.class$("java.lang.Boolean") : class$java$lang$Boolean).getName())) {
                    paramObjects[i] = Boolean.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$lang$Integer == null ? SurefireBooter.class$("java.lang.Integer") : class$java$lang$Integer).getName())) {
                    paramObjects[i] = Integer.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals((class$java$util$Properties == null ? SurefireBooter.class$("java.util.Properties") : class$java$util$Properties).getName())) {
                    Properties result = new Properties();
                    String value = params[i];
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(value.getBytes("8859_1"));
                        result.load(bais);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("bug in property conversion", e);
                    }
                    paramObjects[i] = result;
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter type: " + types[i]);
            }
        }
        return paramObjects;
    }

    public static void main(String[] args) throws Throwable {
        try {
            String url;
            if (args.length > 1) {
                SurefireBooter.setSystemProperties(new File(args[1]));
            }
            File surefirePropertiesFile = new File(args[0]);
            Properties p = SurefireBooter.loadProperties(surefirePropertiesFile);
            TreeMap<Integer, String> classPathUrls = new TreeMap<Integer, String>();
            TreeMap<Integer, String> surefireClassPathUrls = new TreeMap<Integer, String>();
            SurefireBooter surefireBooter = new SurefireBooter(true);
            ForkConfiguration forkConfiguration = new ForkConfiguration();
            forkConfiguration.setForkMode("never");
            surefireBooter.setForkConfiguration(forkConfiguration);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String types;
                String params;
                String className;
                String name = (String)e.nextElement();
                if (name.startsWith(REPORT_PROPERTY_PREFIX) && !name.endsWith(PARAMS_SUFIX) && !name.endsWith(TYPES_SUFIX)) {
                    className = p.getProperty(name);
                    params = p.getProperty(name + PARAMS_SUFIX);
                    types = p.getProperty(name + TYPES_SUFIX);
                    surefireBooter.addReport(className, SurefireBooter.constructParamObjects(params, types));
                    continue;
                }
                if (name.startsWith(TEST_SUITE_PROPERTY_PREFIX) && !name.endsWith(PARAMS_SUFIX) && !name.endsWith(TYPES_SUFIX)) {
                    className = p.getProperty(name);
                    params = p.getProperty(name + PARAMS_SUFIX);
                    types = p.getProperty(name + TYPES_SUFIX);
                    surefireBooter.addTestSuite(className, SurefireBooter.constructParamObjects(params, types));
                    continue;
                }
                if (name.startsWith("classPathUrl.")) {
                    classPathUrls.put(Integer.valueOf(name.substring(name.indexOf(46) + 1)), p.getProperty(name));
                    continue;
                }
                if (name.startsWith("surefireClassPathUrl.")) {
                    surefireClassPathUrls.put(Integer.valueOf(name.substring(name.indexOf(46) + 1)), p.getProperty(name));
                    continue;
                }
                if (name.startsWith("surefireBootClassPathUrl.")) {
                    surefireBooter.addSurefireBootClassPathUrl(p.getProperty(name));
                    continue;
                }
                if ("childDelegation".equals(name)) {
                    surefireBooter.childDelegation = Boolean.valueOf(p.getProperty("childDelegation"));
                    continue;
                }
                if ("enableAssertions".equals(name)) {
                    surefireBooter.enableAssertions = Boolean.valueOf(p.getProperty("enableAssertions"));
                    continue;
                }
                if ("useSystemClassLoader".equals(name)) {
                    surefireBooter.forkConfiguration.setUseSystemClassLoader(Boolean.valueOf(p.getProperty("useSystemClassLoader")));
                    continue;
                }
                if ("useManifestOnlyJar".equals(name)) {
                    surefireBooter.forkConfiguration.setUseManifestOnlyJar(Boolean.valueOf(p.getProperty("useManifestOnlyJar")));
                    continue;
                }
                if (!"failIfNoTests".equals(name)) continue;
                surefireBooter.setFailIfNoTests(Boolean.valueOf(p.getProperty("failIfNoTests")));
            }
            Iterator cpi = classPathUrls.keySet().iterator();
            while (cpi.hasNext()) {
                url = (String)classPathUrls.get(cpi.next());
                surefireBooter.addClassPathUrl(url);
            }
            Iterator scpi = surefireClassPathUrls.keySet().iterator();
            while (scpi.hasNext()) {
                url = (String)surefireClassPathUrls.get(scpi.next());
                surefireBooter.addSurefireClassPathUrl(url);
            }
            String testSet = p.getProperty("testSet");
            int result = testSet != null ? surefireBooter.runSuitesInProcess(testSet, p) : surefireBooter.runSuitesInProcess();
            surefireBooter.writePropertiesFile(surefirePropertiesFile, "surefire", p);
            System.exit(result);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    private ForkingStreamConsumer getForkingStreamConsumer(boolean showHeading, boolean showFooter, boolean redirectTestOutputToFile) {
        OutputConsumer outputConsumer = new StandardOutputConsumer();
        if (redirectTestOutputToFile) {
            outputConsumer = new FileOutputConsumerProxy(outputConsumer, this.getReportsDirectory());
        }
        if (!showHeading) {
            outputConsumer = new SupressHeaderOutputConsumerProxy(outputConsumer);
        }
        if (!showFooter) {
            outputConsumer = new SupressFooterOutputConsumerProxy(outputConsumer);
        }
        return new ForkingStreamConsumer(outputConsumer);
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            assertionStatusMethod = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SurefireBooter.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("setDefaultAssertionStatus", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            assertionStatusMethod = null;
        }
    }
}

