/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.internal.StringUtils;

public class PropertiesWrapper {
    private final Properties properties;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$io$File;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Properties;

    public PropertiesWrapper(Properties properties) {
        if (properties == null) {
            throw new IllegalStateException("Properties cannot be null");
        }
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setAsSystemProperties() {
        Iterator<Object> i = this.properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            System.setProperty(key, this.properties.getProperty(key));
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBooleanProperty(String propertyName) {
        Boolean aBoolean = Boolean.valueOf(this.properties.getProperty(propertyName));
        return aBoolean;
    }

    public Boolean getBooleanObjectProperty(String propertyName) {
        return Boolean.valueOf(this.properties.getProperty(propertyName));
    }

    public File getFileProperty(String key) {
        String property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        return (File)this.getParamValue(property, (class$java$io$File == null ? (class$java$io$File = PropertiesWrapper.class$("java.io.File")) : class$java$io$File).getName());
    }

    public List getStringList(String propertyPrefix) {
        String value;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((value = this.getProperty(propertyPrefix + i)) != null) {
            result.add(value);
            ++i;
        }
        return result;
    }

    public Object getTypeDecoded(String key) {
        String typeEncoded = this.getProperty(key);
        if (typeEncoded == null) {
            return null;
        }
        int typeSep = typeEncoded.indexOf("|");
        String type = typeEncoded.substring(0, typeSep);
        String value = typeEncoded.substring(typeSep + 1);
        return this.getParamValue(value, type);
    }

    private Object getParamValue(String param, String typeName) {
        if (typeName.trim().length() == 0) {
            return null;
        }
        if (typeName.equals((class$java$lang$String == null ? (class$java$lang$String = PropertiesWrapper.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return param;
        }
        if (typeName.equals((class$java$lang$Class == null ? (class$java$lang$Class = PropertiesWrapper.class$("java.lang.Class")) : class$java$lang$Class).getName())) {
            return ReflectionUtils.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)param);
        }
        if (typeName.equals((class$java$io$File == null ? (class$java$io$File = PropertiesWrapper.class$("java.io.File")) : class$java$io$File).getName())) {
            return new File(param);
        }
        if (typeName.equals((array$Ljava$io$File == null ? (array$Ljava$io$File = PropertiesWrapper.class$("[Ljava.io.File;")) : array$Ljava$io$File).getName())) {
            List stringList = PropertiesWrapper.processStringList(param);
            File[] fileList = new File[stringList.size()];
            for (int j = 0; j < stringList.size(); ++j) {
                fileList[j] = new File((String)stringList.get(j));
            }
            return fileList;
        }
        if (typeName.equals((class$java$util$ArrayList == null ? (class$java$util$ArrayList = PropertiesWrapper.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName())) {
            return PropertiesWrapper.processStringList(param);
        }
        if (typeName.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertiesWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
            return Boolean.valueOf(param);
        }
        if (typeName.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = PropertiesWrapper.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
            return Integer.valueOf(param);
        }
        if (typeName.equals((class$java$util$Properties == null ? (class$java$util$Properties = PropertiesWrapper.class$("java.util.Properties")) : class$java$util$Properties).getName())) {
            Properties result = new Properties();
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(param.getBytes("8859_1"));
                result.load(bais);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("bug in property conversion", (Throwable)e);
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown parameter type: " + typeName);
    }

    private static List processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split((String)sl, (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    public void setProperty(String key, File file) {
        if (file != null) {
            this.setProperty(key, file.toString());
        }
    }

    public void setProperty(String key, Boolean aBoolean) {
        if (aBoolean != null) {
            this.setProperty(key, aBoolean.toString());
        }
    }

    Classpath getClasspath(String prefix) {
        List elements = this.getStringList(prefix);
        return new Classpath(elements);
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List classpathElements = classpath.getClassPath();
        for (int i = 0; i < classpathElements.size(); ++i) {
            String element = (String)classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.setProperty(key, value);
        }
    }

    public void addList(List items, String propertyPrefix) {
        if (items == null || items.size() == 0) {
            return;
        }
        int i = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item == null) {
                throw new NullPointerException(propertyPrefix + i + " has null value");
            }
            String[] stringArray = StringUtils.split((String)item.toString(), (String)",");
            for (int j = 0; j < stringArray.length; ++j) {
                this.properties.setProperty(propertyPrefix + i, stringArray[j]);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

