/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Queue;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.booter.DumpErrorSingleton;
import org.apache.maven.surefire.booter.ProcessInfo;
import org.apache.maven.surefire.shade.booter.org.apache.commons.io.IOUtils;
import org.apache.maven.surefire.shade.booter.org.apache.commons.lang3.StringUtils;
import org.apache.maven.surefire.shade.booter.org.apache.commons.lang3.SystemUtils;

final class PpidChecker {
    private static final int MINUTES_TO_MILLIS = 60000;
    private static final int WMIC_CREATION_DATE_VALUE_LENGTH = 25;
    private static final int WMIC_CREATION_DATE_TIMESTAMP_LENGTH = 18;
    private static final SimpleDateFormat WMIC_CREATION_DATE_FORMAT = SystemUtils.IS_OS_WINDOWS ? PpidChecker.createWindowsCreationDateFormat() : null;
    private static final String WMIC_CREATION_DATE = "CreationDate";
    private static final String WINDOWS_SYSTEM_ROOT_ENV = "SystemRoot";
    private static final String RELATIVE_PATH_TO_WMIC = "System32\\Wbem";
    private static final String SYSTEM_PATH_TO_WMIC = "%SystemRoot%\\System32\\Wbem\\";
    private final Queue<Process> destroyableCommands = new ConcurrentLinkedQueue<Process>();
    static final Pattern UNIX_CMD_OUT_PATTERN = Pattern.compile("^(((\\d+)-)?(\\d{1,2}):)?(\\d{1,2}):(\\d{1,2})$");
    private final long ppid;
    private volatile ProcessInfo parentProcessInfo;
    private volatile boolean stopped;

    PpidChecker(long ppid) {
        this.ppid = ppid;
    }

    boolean canUse() {
        ProcessInfo ppi = this.parentProcessInfo;
        return ppi == null ? SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_UNIX && PpidChecker.canExecuteUnixPs() : ppi.canUse();
    }

    boolean isProcessAlive() {
        if (!this.canUse()) {
            throw new IllegalStateException("irrelevant to call isProcessAlive()");
        }
        ProcessInfo previousInfo = this.parentProcessInfo;
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                this.parentProcessInfo = this.windows();
                this.checkProcessInfo();
                boolean bl = previousInfo == null || this.parentProcessInfo.isTimeEqualTo(previousInfo);
                return bl;
            }
            if (SystemUtils.IS_OS_UNIX) {
                this.parentProcessInfo = this.unix();
                this.checkProcessInfo();
                boolean bl = previousInfo == null || !this.parentProcessInfo.isTimeBefore(previousInfo);
                return bl;
            }
            throw new IllegalStateException("unknown platform or you did not call canUse() before isProcessAlive()");
        }
        finally {
            if (this.parentProcessInfo == null) {
                this.parentProcessInfo = ProcessInfo.INVALID_PROCESS_INFO;
            }
        }
    }

    private void checkProcessInfo() {
        if (this.isStopped()) {
            throw new IllegalStateException("error [STOPPED] to read process " + this.ppid);
        }
        if (this.parentProcessInfo.isError()) {
            throw new IllegalStateException("error to read process " + this.ppid);
        }
        if (!this.parentProcessInfo.canUse()) {
            throw new IllegalStateException("Cannot use PPID " + this.ppid + " process information. Going to use NOOP events.");
        }
    }

    ProcessInfo unix() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer(Charset.defaultCharset().name()){

            @Override
            ProcessInfo consumeLine(String line, ProcessInfo previousOutputLine) {
                Matcher matcher;
                if (previousOutputLine.isInvalid() && (matcher = UNIX_CMD_OUT_PATTERN.matcher(line)).matches()) {
                    long pidUptime = PpidChecker.fromDays(matcher) + PpidChecker.fromHours(matcher) + PpidChecker.fromMinutes(matcher) + PpidChecker.fromSeconds(matcher);
                    return ProcessInfo.unixProcessInfo(PpidChecker.this.ppid, pidUptime);
                }
                return previousOutputLine;
            }
        };
        return reader.execute("/bin/sh", "-c", PpidChecker.unixPathToPS() + " -o etime= -p " + this.ppid);
    }

    ProcessInfo windows() {
        ProcessInfoConsumer reader = new ProcessInfoConsumer("US-ASCII"){
            private boolean hasHeader;

            @Override
            ProcessInfo consumeLine(String line, ProcessInfo previousProcessInfo) throws Exception {
                if (previousProcessInfo.isInvalid() && !line.isEmpty()) {
                    if (this.hasHeader) {
                        if (line.length() != 25) {
                            throw new IllegalStateException("WMIC CreationDate should have 25 characters " + line);
                        }
                        String startTimestamp = line.substring(0, 18);
                        int indexOfTimeZone = 21;
                        long startTimestampMillisUTC = WMIC_CREATION_DATE_FORMAT.parse(startTimestamp).getTime() - (long)(Integer.parseInt(line.substring(indexOfTimeZone)) * 60000);
                        return ProcessInfo.windowsProcessInfo(PpidChecker.this.ppid, startTimestampMillisUTC);
                    }
                    this.hasHeader = PpidChecker.WMIC_CREATION_DATE.equals(line);
                }
                return previousProcessInfo;
            }
        };
        String wmicPath = PpidChecker.hasWmicStandardSystemPath() ? SYSTEM_PATH_TO_WMIC : "";
        return reader.execute("CMD", "/A", "/X", "/C", wmicPath + "wmic process where (ProcessId=" + this.ppid + ") get " + WMIC_CREATION_DATE);
    }

    void destroyActiveCommands() {
        this.stopped = true;
        Process p = this.destroyableCommands.poll();
        while (p != null) {
            p.destroy();
            p = this.destroyableCommands.poll();
        }
    }

    private boolean isStopped() {
        return this.stopped;
    }

    private static String unixPathToPS() {
        return PpidChecker.canExecuteLocalUnixPs() ? "/usr/bin/ps" : "/bin/ps";
    }

    static boolean canExecuteUnixPs() {
        return PpidChecker.canExecuteLocalUnixPs() || PpidChecker.canExecuteStandardUnixPs();
    }

    private static boolean canExecuteLocalUnixPs() {
        return new File("/usr/bin/ps").canExecute();
    }

    private static boolean canExecuteStandardUnixPs() {
        return new File("/bin/ps").canExecute();
    }

    private static boolean hasWmicStandardSystemPath() {
        String systemRoot = System.getenv(WINDOWS_SYSTEM_ROOT_ENV);
        return StringUtils.isNotBlank(systemRoot) && new File(systemRoot, "System32\\Wbem\\wmic.exe").isFile();
    }

    static long fromDays(Matcher matcher) {
        String s = matcher.group(3);
        return s == null ? 0L : TimeUnit.DAYS.toSeconds(Long.parseLong(s));
    }

    static long fromHours(Matcher matcher) {
        String s = matcher.group(4);
        return s == null ? 0L : TimeUnit.HOURS.toSeconds(Long.parseLong(s));
    }

    static long fromMinutes(Matcher matcher) {
        String s = matcher.group(5);
        return s == null ? 0L : TimeUnit.MINUTES.toSeconds(Long.parseLong(s));
    }

    static long fromSeconds(Matcher matcher) {
        String s = matcher.group(6);
        return s == null ? 0L : Long.parseLong(s);
    }

    private static void checkValid(Scanner scanner) throws IOException {
        IOException exception = scanner.ioException();
        if (exception != null) {
            throw exception;
        }
    }

    private static SimpleDateFormat createWindowsCreationDateFormat() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss'.'SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter;
    }

    private abstract class ProcessInfoConsumer {
        private final String charset;

        ProcessInfoConsumer(String charset) {
            this.charset = charset;
        }

        abstract ProcessInfo consumeLine(String var1, ProcessInfo var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProcessInfo execute(String ... command) {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            Process process = null;
            ProcessInfo processInfo = ProcessInfo.INVALID_PROCESS_INFO;
            try {
                if (SystemUtils.IS_OS_HP_UX) {
                    processBuilder.environment().put("UNIX95", "1");
                }
                process = processBuilder.start();
                PpidChecker.this.destroyableCommands.add(process);
                Scanner scanner = new Scanner(process.getInputStream(), this.charset);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    processInfo = this.consumeLine(line, processInfo);
                }
                PpidChecker.checkValid(scanner);
                int exitCode = process.waitFor();
                ProcessInfo processInfo2 = exitCode == 0 ? processInfo : ProcessInfo.INVALID_PROCESS_INFO;
                return processInfo2;
            }
            catch (Exception e) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
                ProcessInfo processInfo3 = ProcessInfo.ERR_PROCESS_INFO;
                return processInfo3;
            }
            finally {
                if (process != null) {
                    PpidChecker.this.destroyableCommands.remove(process);
                    process.destroy();
                    IOUtils.closeQuietly(process.getInputStream());
                    IOUtils.closeQuietly(process.getErrorStream());
                    IOUtils.closeQuietly(process.getOutputStream());
                }
            }
        }
    }
}

