/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.util.internal.StringUtils;

public class PropertiesWrapper
implements KeyValueSource {
    private final Map<String, String> properties;

    public PropertiesWrapper(Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalStateException("Properties cannot be null");
        }
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setAsSystemProperties() {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public boolean getBooleanProperty(String propertyName) {
        return Boolean.valueOf(this.properties.get(propertyName));
    }

    public int getIntProperty(String propertyName) {
        return Integer.parseInt(this.properties.get(propertyName));
    }

    public Long getLongProperty(String propertyName) {
        String number = this.getProperty(propertyName);
        return number == null ? null : Long.valueOf(Long.parseLong(number));
    }

    public File getFileProperty(String key) {
        String property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        TypeEncodedValue typeEncodedValue = new TypeEncodedValue(File.class.getName(), property);
        return (File)typeEncodedValue.getDecodedValue();
    }

    public List<String> getStringList(String propertyPrefix) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        String value;
        while ((value = this.getProperty(propertyPrefix + i)) != null) {
            result.add(value);
            ++i;
        }
        return result;
    }

    public TypeEncodedValue getTypeEncodedValue(String key) {
        String typeEncoded = this.getProperty(key);
        if (typeEncoded != null) {
            int typeSep = typeEncoded.indexOf("|");
            String type = typeEncoded.substring(0, typeSep);
            String value = typeEncoded.substring(typeSep + 1);
            return new TypeEncodedValue(type, value);
        }
        return null;
    }

    Classpath getClasspath(String prefix) {
        List<String> elements = this.getStringList(prefix);
        return new Classpath(elements);
    }

    public void setClasspath(String prefix, Classpath classpath) {
        List<String> classpathElements = classpath.getClassPath();
        int size = classpathElements.size();
        for (int i = 0; i < size; ++i) {
            String element = classpathElements.get(i);
            this.setProperty(prefix + i, element);
        }
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.put(key, value);
        }
    }

    public void addList(List items, String propertyPrefix) {
        if (items != null && !items.isEmpty()) {
            int i = 0;
            for (Object item : items) {
                String[] stringArray;
                if (item == null) {
                    throw new NullPointerException(propertyPrefix + i + " has null value");
                }
                for (String aStringArray : stringArray = StringUtils.split((String)item.toString(), (String)",")) {
                    this.properties.put(propertyPrefix + i, aStringArray);
                    ++i;
                }
            }
        }
    }

    @Override
    public void copyTo(Map<Object, Object> target) {
        target.putAll(this.properties);
    }
}

