/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.group.match;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.surefire.group.match.GroupMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleGroupMatcher
implements GroupMatcher {
    private String enabled;
    private Class<?> enabledClass;
    private Pattern pattern;

    public SingleGroupMatcher(String enabled) {
        this.enabled = enabled.endsWith(".class") ? enabled.substring(0, enabled.length() - 6) : enabled;
        try {
            this.pattern = Pattern.compile(enabled);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleGroupMatcher other = (SingleGroupMatcher)obj;
        return !(this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled));
    }

    public String toString() {
        return "*" + this.enabled;
    }

    @Override
    public boolean enabled(Class<?> ... cats) {
        if (cats != null) {
            for (Class<?> cls : cats) {
                if (this.enabledClass != null && this.enabledClass.isAssignableFrom(cls)) {
                    return true;
                }
                String name = cls.getName();
                if (!name.endsWith(this.enabled)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean enabled(String ... cats) {
        if (this.enabled == null) {
            return true;
        }
        for (String cat : cats) {
            if (cat == null || cat.trim().length() < 1) continue;
            if (cat.endsWith(this.enabled)) {
                return true;
            }
            if (this.pattern == null || !this.pattern.matcher(cat).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadGroupClasses(ClassLoader cloader) {
        try {
            this.enabledClass = cloader.loadClass(this.enabled);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load category: " + this.enabled, e);
        }
    }
}

