/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartStackTraceParser {
    private final SafeThrowable throwable;
    private final StackTraceElement[] stackTrace;
    private final String simpleName;
    private String testClassName;
    private final Class testClass;
    private String testMethodName;

    public SmartStackTraceParser(Class testClass, Throwable throwable) {
        this(testClass.getName(), throwable, null);
    }

    public SmartStackTraceParser(String testClassName, Throwable throwable, String testMethodName) {
        this.testMethodName = testMethodName;
        this.testClassName = testClassName;
        this.testClass = SmartStackTraceParser.getClass(testClassName);
        this.simpleName = this.testClassName.substring(this.testClassName.lastIndexOf(".") + 1);
        this.throwable = new SafeThrowable(throwable);
        this.stackTrace = throwable.getStackTrace();
    }

    private static Class getClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getSimpleName(String className) {
        int i = className.lastIndexOf(".");
        return className.substring(i + 1);
    }

    public String getString() {
        Throwable target;
        if (this.testClass == null) {
            return this.throwable.getLocalizedMessage();
        }
        StringBuilder result = new StringBuilder();
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusOnClass(this.stackTrace, this.testClass);
        Collections.reverse(stackTraceElements);
        if (stackTraceElements.isEmpty()) {
            result.append(this.simpleName);
            if (StringUtils.isNotEmpty(this.testMethodName)) {
                result.append(".").append(this.testMethodName);
            }
        } else {
            for (int i = 0; i < stackTraceElements.size(); ++i) {
                StackTraceElement stackTraceElement = stackTraceElements.get(i);
                if (i == 0) {
                    result.append(this.simpleName);
                    if (!stackTraceElement.getClassName().equals(this.testClassName)) {
                        result.append(">");
                    } else {
                        result.append(".");
                    }
                }
                if (!stackTraceElement.getClassName().equals(this.testClassName)) {
                    result.append(SmartStackTraceParser.getSimpleName(stackTraceElement.getClassName()));
                    result.append(".");
                }
                result.append(stackTraceElement.getMethodName()).append(":").append(stackTraceElement.getLineNumber());
                result.append("->");
            }
            if (result.length() >= 2) {
                result.deleteCharAt(result.length() - 1);
                result.deleteCharAt(result.length() - 1);
            }
        }
        if ((target = this.throwable.getTarget()) instanceof AssertionError) {
            result.append(" ");
            result.append(this.throwable.getMessage());
        } else if ("junit.framework.AssertionFailedError".equals(target.getClass().getName()) || "junit.framework.ComparisonFailure".equals(target.getClass().getName())) {
            result.append(" ");
            result.append(this.throwable.getMessage());
        } else {
            result.append(this.rootIsInclass() ? " " : " \u00bb ");
            result.append(this.getMinimalThrowableMiniMessage(target));
            result.append(this.getTruncatedMessage(77 - result.length()));
        }
        return result.toString();
    }

    private String getMinimalThrowableMiniMessage(Throwable throwable) {
        String name = throwable.getClass().getSimpleName();
        if (name.endsWith("Exception")) {
            return StringUtils.chompLast(name, "Exception");
        }
        if (name.endsWith("Error")) {
            return StringUtils.chompLast(name, "Error");
        }
        return name;
    }

    private String getTruncatedMessage(int i) {
        if (i < 0) {
            return "";
        }
        String msg = this.throwable.getMessage();
        if (msg == null) {
            return "";
        }
        String substring = msg.substring(0, Math.min(i, msg.length()));
        if (i < msg.length()) {
            return " " + substring + "...";
        }
        return " " + substring;
    }

    private boolean rootIsInclass() {
        return this.stackTrace.length > 0 && this.stackTrace[0].getClassName().equals(this.testClassName);
    }

    static List<StackTraceElement> focusOnClass(StackTraceElement[] stackTrace, Class clazz) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (element == null || !SmartStackTraceParser.isInSupers(clazz, element.getClassName())) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean isInSupers(Class testClass, String lookFor) {
        if (lookFor.startsWith("junit.framework.")) {
            return false;
        }
        while (!testClass.getName().equals(lookFor) && testClass.getSuperclass() != null) {
            testClass = testClass.getSuperclass();
        }
        return testClass.getName().equals(lookFor);
    }

    static Throwable findInnermostWithClass(Throwable t, String className) {
        Throwable match = t;
        do {
            if (!SmartStackTraceParser.containsClassName(t.getStackTrace(), className)) continue;
            match = t;
        } while ((t = t.getCause()) != null);
        return match;
    }

    public static String innerMostWithFocusOnClass(Throwable t, String className) {
        Throwable innermost = SmartStackTraceParser.findInnermostWithClass(t, className);
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusInsideClass(innermost.getStackTrace(), className);
        String s = SmartStackTraceParser.causeToString(innermost.getCause());
        return SmartStackTraceParser.toString(t, stackTraceElements) + s;
    }

    static List<StackTraceElement> focusInsideClass(StackTraceElement[] stackTrace, String className) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        boolean found = false;
        for (StackTraceElement element : stackTrace) {
            if (!found) {
                result.add(element);
            }
            if (className.equals(element.getClassName())) {
                if (found) {
                    result.add(element);
                }
                found = true;
                continue;
            }
            if (found) break;
        }
        return result;
    }

    static boolean containsClassName(StackTraceElement[] stackTrace, String className) {
        for (StackTraceElement element : stackTrace) {
            if (!className.equals(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static String causeToString(Throwable cause) {
        StringBuilder resp = new StringBuilder();
        while (cause != null) {
            resp.append("Caused by: ");
            resp.append(SmartStackTraceParser.toString(cause, Arrays.asList(cause.getStackTrace())));
            cause = cause.getCause();
        }
        return resp.toString();
    }

    public static String toString(Throwable t, Iterable<StackTraceElement> elements) {
        StringBuilder result = new StringBuilder();
        result.append(t.getClass().getName());
        result.append(": ");
        result.append(t.getMessage());
        result.append("\n");
        for (StackTraceElement element : elements) {
            result.append("\tat ").append(element.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

