/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4ProviderUtil {
    public static Map<Class<?>, Set<String>> generateFailingTests(List<Failure> allFailures, TestsToRun testsToRun) {
        HashMap testClassMethods = new HashMap();
        for (Failure failure : allFailures) {
            if (JUnit4RunListener.isFailureInsideJUnitItself(failure)) continue;
            String[] testMethodClass = StringUtils.split((String)failure.getTestHeader(), (String)"(");
            String testMethod = testMethodClass[0];
            String testClass = StringUtils.split((String)testMethodClass[1], (String)")")[0];
            Class testClassObj = testsToRun.getClassByName(testClass);
            if (testClassObj == null) continue;
            HashSet<String> failingMethods = (HashSet<String>)testClassMethods.get(testClassObj);
            if (failingMethods == null) {
                failingMethods = new HashSet<String>();
                failingMethods.add(testMethod);
                testClassMethods.put(testClassObj, failingMethods);
                continue;
            }
            failingMethods.add(testMethod);
        }
        return testClassMethods;
    }

    public static Set<String> generateFailingTests(List<Failure> allFailures) {
        HashSet<String> failingMethods = new HashSet<String>();
        for (Failure failure : allFailures) {
            if (JUnit4RunListener.isFailureInsideJUnitItself(failure)) continue;
            String testMethod = StringUtils.split((String)failure.getTestHeader(), (String)"(")[0];
            failingMethods.add(testMethod);
        }
        return failingMethods;
    }

    public static Description createSuiteDescription(Collection<Class<?>> classes) {
        JUnit4Reflector reflector = new JUnit4Reflector();
        return reflector.createRequest(classes.toArray(new Class[classes.size()])).getRunner().getDescription();
    }
}

