/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessListener;
import org.apache.maven.surefire.booter.MasterProcessReader;
import org.apache.maven.surefire.common.junit4.ClassMethod;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4Reflector;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.common.junit4.Notifier;
import org.apache.maven.surefire.junit4.JUnit4FailFastListener;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4Provider
extends AbstractProvider {
    private static final String UNDETERMINED_TESTS_DESCRIPTION = "cannot determine test in forked JVM with surefire";
    private final ClassLoader testClassLoader;
    private final Collection<org.junit.runner.notification.RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private final TestListResolver testResolver;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private final MasterProcessReader commandsReader;
    private TestsToRun testsToRun;

    public JUnit4Provider(ProviderParameters booterParameters) {
        this.commandsReader = booterParameters.isInsideFork() ? MasterProcessReader.getReader().setShutdown(booterParameters.getShutdown()) : null;
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.scanResult = booterParameters.getScanResult();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        String listeners = (String)booterParameters.getProviderProperties().get("listener");
        this.customRunListeners = Collections.unmodifiableCollection(JUnit4RunListenerFactory.createCustomListeners(listeners));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        TestRequest testRequest = booterParameters.getTestRequest();
        this.testResolver = testRequest.getTestListResolver();
        this.rerunFailingTestsCount = testRequest.getRerunFailingTestsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        if (this.isRerunFailingTests() && this.isFailFast()) {
            throw new TestSetFailedException("don't enable parameters rerunFailingTestsCount, skipAfterFailureCount");
        }
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
        }
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        Notifier notifier = new Notifier(new JUnit4RunListener(reporter), this.getSkipAfterFailureCount());
        if (this.isFailFast()) {
            notifier.addListener(new JUnit4FailFastListener(notifier));
        }
        Result result = new Result();
        notifier.addListeners(this.customRunListeners).addListener(result.createListener());
        if (this.isFailFast() && this.commandsReader != null) {
            this.registerPleaseStopJunitListener(notifier);
        }
        try {
            notifier.fireTestRunStarted(this.testsToRun.allowEagerReading() ? this.createTestsDescription() : JUnit4Reflector.createDescription(UNDETERMINED_TESTS_DESCRIPTION));
            if (this.commandsReader != null) {
                this.commandsReader.addShutdownListener(new MasterProcessListener(){

                    public void update(Command command) {
                        JUnit4Provider.this.testsToRun.markTestSetFinished();
                    }
                });
                this.commandsReader.awaitStarted();
            }
            for (Class aTestsToRun : this.testsToRun) {
                this.executeTestSet(aTestsToRun, reporter, notifier);
            }
        }
        finally {
            notifier.fireTestRunFinished(result);
            notifier.removeListeners();
            this.closeCommandsReader();
        }
        JUnit4RunListener.rethrowAnyTestMechanismFailures(result);
        return reporterFactory.close();
    }

    private boolean isRerunFailingTests() {
        return this.rerunFailingTestsCount > 0;
    }

    private boolean isFailFast() {
        return this.providerParameters.getSkipAfterFailureCount() > 0;
    }

    private int getSkipAfterFailureCount() {
        return this.isFailFast() && !this.isRerunFailingTests() ? this.providerParameters.getSkipAfterFailureCount() : 0;
    }

    private void closeCommandsReader() {
        if (this.commandsReader != null) {
            this.commandsReader.stop();
        }
    }

    private MasterProcessListener registerPleaseStopJunitListener(final Notifier notifier) {
        MasterProcessListener listener = new MasterProcessListener(){

            public void update(Command command) {
                notifier.pleaseStop();
            }
        };
        this.commandsReader.addSkipNextListener(listener);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> clazz, RunListener reporter, Notifier notifier) {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), clazz.getName());
        reporter.testSetStarting((ReportEntry)report);
        try {
            this.executeWithRerun(clazz, notifier);
        }
        catch (Throwable e) {
            if (this.isFailFast() && e instanceof StoppedByUserException) {
                String reason = e.getClass().getName();
                Description skippedTest = JUnit4Reflector.createDescription(clazz.getName(), new Annotation[]{JUnit4Reflector.createIgnored(reason)});
                notifier.fireTestIgnored(skippedTest);
            } else {
                String reportName = report.getName();
                String reportSourceName = report.getSourceName();
                PojoStackTraceWriter stackWriter = new PojoStackTraceWriter(reportSourceName, reportName, e);
                reporter.testError((ReportEntry)SimpleReportEntry.withException((String)reportSourceName, (String)reportName, (StackTraceWriter)stackWriter));
            }
        }
        finally {
            reporter.testSetCompleted((ReportEntry)report);
        }
    }

    private void executeWithRerun(Class<?> clazz, Notifier notifier) throws TestSetFailedException {
        JUnitTestFailureListener failureListener = new JUnitTestFailureListener();
        notifier.addListener(failureListener);
        boolean hasMethodFilter = this.testResolver != null && this.testResolver.hasMethodPatterns();
        JUnit4Provider.execute(clazz, notifier, hasMethodFilter ? new TestResolverFilter() : new NullFilter());
        if (this.isRerunFailingTests()) {
            for (int i = 0; i < this.rerunFailingTestsCount && !failureListener.getAllFailures().isEmpty(); ++i) {
                Set<ClassMethod> failedTests = JUnit4ProviderUtil.generateFailingTests(failureListener.getAllFailures());
                failureListener.reset();
                if (failedTests.isEmpty()) continue;
                this.executeFailedMethod(notifier, failedTests);
            }
        }
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun;
    }

    private TestsToRun scanClassPath() {
        TestsToRun scannedClasses = this.scanResult.applyFilter((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scannedClasses);
    }

    private void upgradeCheck() throws TestSetFailedException {
        List classesSkippedByValidation;
        if (JUnit4Provider.isJUnit4UpgradeCheck() && !(classesSkippedByValidation = this.scanResult.getClassesSkippedByValidation((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader)).isEmpty()) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : classesSkippedByValidation) {
                reason.append("   ");
                reason.append(testClass.getName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    private Description createTestsDescription() {
        ArrayList classes = new ArrayList();
        for (Class clazz : this.testsToRun) {
            classes.add(clazz);
        }
        return JUnit4ProviderUtil.createSuiteDescription(classes);
    }

    private static boolean isJUnit4UpgradeCheck() {
        return System.getProperty("surefire.junit4.upgradecheck") != null;
    }

    private static void execute(Class<?> testClass, Notifier notifier, Filter filter) {
        Runner runner;
        int classModifiers = testClass.getModifiers();
        if (!Modifier.isAbstract(classModifiers) && !Modifier.isInterface(classModifiers) && JUnit4Provider.countTestsInRunner((runner = Request.aClass(testClass).filterWith(filter).getRunner()).getDescription()) != 0) {
            runner.run((RunNotifier)notifier);
        }
    }

    private void executeFailedMethod(Notifier notifier, Set<ClassMethod> failedMethods) throws TestSetFailedException {
        for (ClassMethod failedMethod : failedMethods) {
            try {
                Class<?> methodClass = Class.forName(failedMethod.getClazz(), true, this.testClassLoader);
                String methodName = failedMethod.getMethod();
                Request.method(methodClass, (String)methodName).getRunner().run((RunNotifier)notifier);
            }
            catch (ClassNotFoundException e) {
                throw new TestSetFailedException("Unable to create test class '" + failedMethod.getClazz() + "'", (Throwable)e);
            }
        }
    }

    private static int countTestsInRunner(Description description) {
        if (description.isSuite()) {
            int count = 0;
            for (Description child : description.getChildren()) {
                if (JUnit4Provider.hasFilteredOutAllChildren(child)) continue;
                count += JUnit4Provider.countTestsInRunner(child);
            }
            return count;
        }
        if (description.isTest()) {
            return JUnit4Provider.hasFilteredOutAllChildren(description) ? 0 : 1;
        }
        return 0;
    }

    private static boolean hasFilteredOutAllChildren(Description description) {
        String name = description.getDisplayName();
        if (name == null) {
            return true;
        }
        return (name = name.trim()).startsWith("initializationError0(org.junit.runner.manipulation.Filter)") || name.startsWith("initializationError(org.junit.runner.manipulation.Filter)");
    }

    private final class NullFilter
    extends TestResolverFilter {
        private NullFilter() {
        }

        public boolean shouldRun(Description description) {
            return true;
        }

        public String describe() {
            return "";
        }
    }

    private class TestResolverFilter
    extends Filter {
        private final TestListResolver methodFilter;

        private TestResolverFilter() {
            this.methodFilter = JUnit4Provider.this.testResolver.createMethodFilters();
        }

        public boolean shouldRun(Description description) {
            ClassMethod cm = JUnit4ProviderUtil.cutTestClassAndMethod(description);
            boolean isSuite = description.isSuite();
            boolean isValidTest = description.isTest() && cm.isValid();
            String clazz = cm.getClazz();
            String method = cm.getMethod();
            return isSuite || isValidTest && this.methodFilter.shouldRun(TestListResolver.toClassFileName((String)clazz), method);
        }

        public String describe() {
            return this.methodFilter.toString();
        }
    }
}

