/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import junit.framework.Test;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.ScannerFilter;
import org.junit.runner.RunWith;

public class JUnit4TestChecker
implements ScannerFilter {
    private final Class junitClass;
    private final NonAbstractClassFilter nonAbstractClassFilter;
    private final Class runWith;

    public JUnit4TestChecker(ClassLoader testClassLoader) {
        this.junitClass = this.getJUnitClass(testClassLoader, Test.class.getName());
        this.runWith = this.getJUnitClass(testClassLoader, RunWith.class.getName());
        this.nonAbstractClassFilter = new NonAbstractClassFilter();
    }

    public boolean accept(Class testClass) {
        return this.isValidJUnit4Test(testClass);
    }

    public boolean isValidJUnit4Test(Class testClass) {
        if (!this.nonAbstractClassFilter.accept(testClass)) {
            return false;
        }
        if (this.junitClass != null && this.junitClass.isAssignableFrom(testClass)) {
            return true;
        }
        Object runWithAnnotation = testClass.getAnnotation(this.runWith);
        if (runWithAnnotation != null) {
            return true;
        }
        for (Class classToCheck = testClass; classToCheck != null; classToCheck = classToCheck.getSuperclass()) {
            if (!this.checkforTestAnnotatedMethod(classToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean checkforTestAnnotatedMethod(Class testClass) {
        for (Method lMethod : testClass.getDeclaredMethods()) {
            for (Annotation lAnnotation : lMethod.getAnnotations()) {
                if (!org.junit.Test.class.isAssignableFrom(lAnnotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    private Class getJUnitClass(ClassLoader classLoader, String className) {
        return ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)className);
    }
}

