/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.Map;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.util.internal.ObjectUtils;

abstract class TestSuite {
    TestSuite() {
    }

    abstract Map<String, String> getOptions();

    final String getSuiteName() {
        String result = this.getOptions().get("suitename");
        return result == null ? "TestSuite" : result;
    }

    final void startTestSuite(RunListener reporterManager) {
        SimpleReportEntry report = new SimpleReportEntry(this.getClass().getName(), this.getSuiteName(), ObjectUtils.systemProps());
        try {
            reporterManager.testSetStarting((TestSetReportEntry)report);
        }
        catch (ReporterException reporterException) {
            // empty catch block
        }
    }

    final void finishTestSuite(RunListener reporterManager) {
        SimpleReportEntry report = new SimpleReportEntry(this.getClass().getName(), this.getSuiteName(), ObjectUtils.systemProps());
        reporterManager.testSetCompleted((TestSetReportEntry)report);
    }
}

