/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FileTestUtils {
    public static final File createUniqueFile(String dirname, String name) throws IOException {
        File dir = FileTestUtils.createDir(dirname);
        File retValue = new File(dir, name);
        return retValue;
    }

    public static final File createUniqueDir(String name) throws IOException {
        String filename = name + System.currentTimeMillis();
        return FileTestUtils.createDir(filename);
    }

    public static final File createDir(String name) throws IOException {
        File baseDirectory = FileTestUtils.getTestOutputDir();
        File retValue = new File(baseDirectory, name);
        retValue.delete();
        retValue.mkdirs();
        if (!retValue.exists()) {
            throw new IOException("Unable to create the directory for testdata");
        }
        return retValue;
    }

    public static final File getTestOutputDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        String baseDir = System.getProperty("basedir", tempDir);
        File base = new File(baseDir).getAbsoluteFile();
        String pathname = base + File.separator + "target" + File.separator + "test-output";
        File retValue = new File(pathname);
        retValue.mkdirs();
        return retValue;
    }

    public static File generateFile(String file, String content) throws IOException {
        File f = new File(file);
        f.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(f);
        writer.write(content);
        ((Writer)writer).close();
        return f;
    }
}

