/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WagonTestCase
extends PlexusTestCase {
    protected static Logger logger = LoggerFactory.getLogger(WagonTestCase.class);
    protected static final String TEST_CONTENT = "test-resource.txt\n";
    protected static final String TEST_CKSUM = WagonTestCase.cksum("test-resource.txt\n");
    protected static final String POM = "pom.xml";
    protected Repository localRepository;
    protected Repository testRepository;
    protected String localRepositoryPath;
    protected File sourceFile;
    protected File destFile;
    protected String resource;
    protected boolean testSkipped;
    protected File artifactSourceFile;
    protected File artifactDestFile;
    protected ChecksumObserver checksumObserver;
    protected TransferListener mockTransferListener;

    protected void setUp() throws Exception {
        this.checksumObserver = new ChecksumObserver();
        this.mockTransferListener = (TransferListener)EasyMock.createMock(TransferListener.class);
        super.setUp();
    }

    protected abstract String getTestRepositoryUrl() throws IOException;

    protected abstract String getProtocol();

    protected void setupRepositories() throws Exception {
        this.resource = "test-resource";
        this.testRepository = new Repository();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
        this.testRepository.setPermissions(this.getPermissions());
        File file = FileTestUtils.createDir("local-repository");
        this.localRepositoryPath = file.getPath();
        this.localRepository = this.createFileRepository(file.toPath().toUri().toASCIIString());
        this.message("Local repository: " + this.localRepository);
        File f = new File(this.localRepositoryPath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    protected void customizeContext() throws Exception {
        this.getContainer().addContextValue((Object)"test.repository", (Object)this.localRepositoryPath);
    }

    protected void setupWagonTestingFixtures() throws Exception {
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
    }

    protected AuthenticationInfo getAuthInfo() {
        return new AuthenticationInfo();
    }

    protected RepositoryPermissions getPermissions() {
        return new RepositoryPermissions();
    }

    protected Wagon getWagon() throws Exception {
        Wagon wagon = (Wagon)this.lookup(Wagon.ROLE, this.getProtocol());
        Debug debug = new Debug();
        wagon.addSessionListener((SessionListener)debug);
        wagon.addTransferListener((TransferListener)debug);
        return wagon;
    }

    public static boolean isSystemCmd(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void message(String message) {
        logger.info(message);
    }

    public void testWagon() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        this.fileRoundTripTesting();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonGetIfNewerIsNewer() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupWagonTestingFixtures();
            this.setupRepositories();
            int expectedSize = this.putFile();
            this.getIfNewer(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)) + 30000L, false, expectedSize);
        }
    }

    protected void runTest() throws Throwable {
        if (!this.testSkipped) {
            super.runTest();
        }
    }

    protected boolean supportsGetIfNewer() {
        return true;
    }

    public void testWagonGetIfNewerIsSame() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupWagonTestingFixtures();
            this.setupRepositories();
            int expectedSize = this.putFile();
            this.getIfNewer(this.getExpectedLastModifiedOnGet(this.testRepository, new Resource(this.resource)), false, expectedSize);
        }
    }

    public void testWagonGetIfNewerIsOlder() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupWagonTestingFixtures();
            this.setupRepositories();
            int expectedSize = this.putFile();
            this.getIfNewer(new SimpleDateFormat("yyyy-MM-dd").parse("2006-01-01").getTime(), true, expectedSize);
        }
    }

    private void getIfNewer(long timestamp, boolean expectedResult, int expectedSize) throws Exception {
        Wagon wagon = this.getWagon();
        ProgressAnswer progressAnswer = this.setupGetIfNewerTest(wagon, expectedResult, expectedSize);
        this.connectWagon(wagon);
        boolean result = wagon.getIfNewer(this.resource, this.destFile, timestamp);
        WagonTestCase.assertEquals((boolean)expectedResult, (boolean)result);
        this.disconnectWagon(wagon);
        this.assertGetIfNewerTest(progressAnswer, expectedResult, expectedSize);
        this.tearDownWagonTestingFixtures();
    }

    protected ProgressAnswer setupGetIfNewerTest(Wagon wagon, boolean expectedResult, int expectedSize) throws NoSuchAlgorithmException, IOException {
        this.checksumObserver = new ChecksumObserver();
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.delete();
        WagonTestCase.assertFalse((boolean)this.destFile.exists());
        this.destFile.deleteOnExit();
        ProgressAnswer progressAnswer = null;
        if (expectedResult) {
            progressAnswer = this.replaceMockForGet(wagon, expectedSize);
        } else {
            this.replaceMockForSkippedGetIfNewer(wagon, expectedSize);
        }
        return progressAnswer;
    }

    protected void assertGetIfNewerTest(ProgressAnswer progressAnswer, boolean expectedResult, int expectedSize) throws IOException {
        if (expectedResult) {
            this.verifyMock(progressAnswer, expectedSize);
            WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
            WagonTestCase.assertEquals((String)"compare checksums", (String)TEST_CKSUM, (String)this.checksumObserver.getActualChecksum());
            String sourceContent = FileUtils.fileRead((File)this.sourceFile);
            String destContent = FileUtils.fileRead((File)this.destFile);
            WagonTestCase.assertEquals((String)sourceContent, (String)destContent);
        } else {
            EasyMock.verify((Object[])new Object[]{this.mockTransferListener});
            EasyMock.reset((Object[])new Object[]{this.mockTransferListener});
            WagonTestCase.assertNull((String)"check checksum is null", (Object)this.checksumObserver.getActualChecksum());
            WagonTestCase.assertFalse((boolean)this.destFile.exists());
        }
    }

    private void replaceMockForSkippedGetIfNewer(Wagon wagon, int expectedSize) {
        Resource resource = new Resource(this.resource);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 5, this.destFile));
        resource = new Resource(this.resource);
        resource.setContentLength((long)this.getExpectedContentLengthOnGet(expectedSize));
        resource.setLastModified(this.getExpectedLastModifiedOnGet(this.testRepository, resource));
        this.mockTransferListener.debug(EasyMock.anyString());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockTransferListener});
    }

    public void testWagonPutDirectory() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("directory-copy/test-resource-1.txt", this.destFile);
            wagon.get("directory-copy/a/test-resource-2.txt", this.destFile);
            wagon.get("directory-copy/a/b/test-resource-3.txt", this.destFile);
            wagon.get("directory-copy/c/test-resource-4.txt", this.destFile);
            wagon.get("directory-copy/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryDeepDestination() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "deep0/deep1/deep2");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            this.writeTestFile("d/e/f/test-resource-5.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "deep0/deep1/deep2");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("deep0/deep1/deep2/test-resource-1.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/test-resource-2.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/a/b/test-resource-3.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/c/test-resource-4.txt", this.destFile);
            wagon.get("deep0/deep1/deep2/d/e/f/test-resource-5.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryWhenDirectoryAlreadyExists() throws Exception {
        String dirName = "directory-copy-existing";
        String resourceToCreate = "test-resource-1.txt";
        String[] resources = new String[]{"a/test-resource-2.txt", "a/b/test-resource-3.txt", "c/test-resource-4.txt"};
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy-existing");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.createDirectory(wagon, "test-resource-1.txt", "directory-copy-existing");
            for (String resource : resources) {
                this.writeTestFile(resource);
            }
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy-existing");
            ArrayList<String> resourceNames = new ArrayList<String>(resources.length + 1);
            resourceNames.add("directory-copy-existing/test-resource-1.txt");
            for (String resource : resources) {
                resourceNames.add("directory-copy-existing/" + resource);
            }
            this.assertResourcesAreInRemoteSide(wagon, resourceNames);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectoryForDot() throws Exception {
        String resourceToCreate = "test-resource-1.txt";
        String[] resources = new String[]{"a/test-resource-2.txt", "a/b/test-resource-3.txt", "c/test-resource-4.txt"};
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "dot-repo");
            FileUtils.deleteDirectory((File)this.sourceFile);
            this.createDirectory(wagon, "test-resource-1.txt", ".");
            for (String resource : resources) {
                this.writeTestFile(resource);
            }
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, ".");
            ArrayList<String> resourceNames = new ArrayList<String>(resources.length + 1);
            resourceNames.add("test-resource-1.txt");
            Collections.addAll(resourceNames, resources);
            this.assertResourcesAreInRemoteSide(wagon, resourceNames);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    protected void createDirectory(Wagon wagon, String resourceToCreate, String dirName) throws Exception {
        this.writeTestFile(resourceToCreate);
    }

    protected void assertResourcesAreInRemoteSide(Wagon wagon, List<String> resourceNames) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        for (String resourceName : resourceNames) {
            File destFile = FileTestUtils.createUniqueFile(this.getName(), resourceName);
            destFile.deleteOnExit();
            wagon.get(resourceName, destFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNotExists(Wagon wagon, String resourceName) throws IOException, TransferFailedException, AuthorizationException {
        File tmpFile = File.createTempFile("wagon", null);
        try {
            wagon.get(resourceName, tmpFile);
            WagonTestCase.fail((String)("Resource exists: " + resourceName));
        }
        catch (ResourceDoesNotExistException resourceDoesNotExistException) {
        }
        finally {
            tmpFile.delete();
        }
    }

    private void writeTestFile(String child) throws IOException {
        File dir = new File(this.sourceFile, child);
        dir.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dir.getAbsolutePath(), (String)child);
    }

    public void testFailedGet() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        try {
            wagon.get("fubar.txt", this.destFile);
            WagonTestCase.fail((String)"File was found when it shouldn't have been");
        }
        catch (ResourceDoesNotExistException e) {
            WagonTestCase.assertTrue((boolean)true);
        }
        finally {
            wagon.removeTransferListener((TransferListener)this.checksumObserver);
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testFailedGetIfNewer() throws Exception {
        if (this.supportsGetIfNewer()) {
            this.setupWagonTestingFixtures();
            this.setupRepositories();
            this.message("Getting test artifact from test repository " + this.testRepository);
            Wagon wagon = this.getWagon();
            wagon.addTransferListener((TransferListener)this.checksumObserver);
            wagon.connect(this.testRepository, this.getAuthInfo());
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            try {
                wagon.getIfNewer("fubar.txt", this.destFile, 0L);
                WagonTestCase.fail((String)"File was found when it shouldn't have been");
            }
            catch (ResourceDoesNotExistException e) {
                WagonTestCase.assertTrue((boolean)true);
            }
            finally {
                wagon.removeTransferListener((TransferListener)this.checksumObserver);
                wagon.disconnect();
                this.tearDownWagonTestingFixtures();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWagonGetFileList() throws Exception {
        String[] filenames;
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        String dirName = "file-list";
        for (String filename : filenames = new String[]{"test-resource.txt", "test-resource.pom", "test-resource b.txt", "more-resources.dat", ".index.txt"}) {
            this.putFile(dirName + "/" + filename, dirName + "/" + filename, filename + "\n");
        }
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        try {
            List list = wagon.getFileList(dirName);
            WagonTestCase.assertNotNull((String)"file list should not be null.", (Object)list);
            WagonTestCase.assertTrue((String)("file list should contain more items (actually contains '" + list + "')."), (list.size() >= filenames.length ? 1 : 0) != 0);
            for (String filename : filenames) {
                WagonTestCase.assertTrue((String)("Filename '" + filename + "' should be in list."), (boolean)list.contains(filename));
            }
            list = wagon.getFileList("");
            WagonTestCase.assertNotNull((String)"file list should not be null.", (Object)list);
            WagonTestCase.assertTrue((String)("file list should contain items (actually contains '" + list + "')."), (!list.isEmpty() ? 1 : 0) != 0);
            WagonTestCase.assertTrue((boolean)list.contains("file-list/"));
            WagonTestCase.assertFalse((boolean)list.contains("file-list"));
            WagonTestCase.assertFalse((boolean)list.contains("."));
            WagonTestCase.assertFalse((boolean)list.contains(".."));
            WagonTestCase.assertFalse((boolean)list.contains("./"));
            WagonTestCase.assertFalse((boolean)list.contains("../"));
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeFalse((boolean)false);
        }
        finally {
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWagonGetFileListWhenDirectoryDoesNotExist() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        String dirName = "file-list-unexisting";
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        try {
            wagon.getFileList(dirName);
            WagonTestCase.fail((String)"getFileList on unexisting directory must throw ResourceDoesNotExistException");
        }
        catch (ResourceDoesNotExistException resourceDoesNotExistException) {
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeFalse((boolean)false);
        }
        finally {
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    public void testWagonResourceExists() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        this.putFile();
        wagon.connect(this.testRepository, this.getAuthInfo());
        WagonTestCase.assertTrue((String)(this.sourceFile.getName() + " does not exist"), (boolean)wagon.resourceExists(this.sourceFile.getName()));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonResourceNotExists() throws Exception {
        this.setupWagonTestingFixtures();
        this.setupRepositories();
        Wagon wagon = this.getWagon();
        wagon.connect(this.testRepository, this.getAuthInfo());
        WagonTestCase.assertFalse((boolean)wagon.resourceExists("a/bad/resource/name/that/should/not/exist.txt"));
        wagon.disconnect();
        this.tearDownWagonTestingFixtures();
    }

    protected void putFile(String resourceName, String testFileName, String content) throws Exception {
        this.sourceFile = new File(FileTestUtils.getTestOutputDir(), testFileName);
        this.sourceFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)this.sourceFile.getAbsolutePath(), (String)content);
        Wagon wagon = this.getWagon();
        ProgressAnswer progressAnswer = this.replayMockForPut(resourceName, content, wagon);
        this.message("Putting test artifact: " + resourceName + " into test repository " + this.testRepository);
        this.connectWagon(wagon);
        wagon.put(this.sourceFile, resourceName);
        this.disconnectWagon(wagon);
        this.verifyMock(progressAnswer, content.length());
    }

    protected ProgressAnswer replayMockForPut(String resourceName, String content, Wagon wagon) {
        Resource resource = new Resource(resourceName);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 6, this.sourceFile));
        resource = new Resource(resourceName);
        resource.setContentLength((long)content.length());
        resource.setLastModified(this.sourceFile.lastModified());
        this.mockTransferListener.transferStarted(this.createTransferEvent(wagon, resource, 1, 6, this.sourceFile));
        this.mockTransferListener.transferProgress((TransferEvent)EasyMock.eq((Object)this.createTransferEvent(wagon, resource, 3, 6, this.sourceFile)), (byte[])EasyMock.anyObject(byte[].class), EasyMock.anyInt());
        ProgressAnswer progressAnswer = new ProgressAnswer();
        EasyMock.expectLastCall().andStubAnswer((IAnswer)progressAnswer);
        this.mockTransferListener.debug(EasyMock.anyString());
        EasyMock.expectLastCall().anyTimes();
        this.mockTransferListener.transferCompleted(this.createTransferEvent(wagon, resource, 2, 6, this.sourceFile));
        EasyMock.replay((Object[])new Object[]{this.mockTransferListener});
        return progressAnswer;
    }

    protected TransferEvent createTransferEvent(Wagon wagon, Resource resource, int eventType, int requestType, File file) {
        TransferEvent transferEvent = new TransferEvent(wagon, resource, eventType, requestType);
        transferEvent.setLocalFile(file);
        return transferEvent;
    }

    protected int putFile() throws Exception {
        String content = TEST_CONTENT;
        this.putFile(this.resource, "test-resource", content);
        return content.length();
    }

    protected void getFile(int expectedSize) throws Exception {
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        Wagon wagon = this.getWagon();
        ProgressAnswer progressAnswer = this.replaceMockForGet(wagon, expectedSize);
        this.message("Getting test artifact from test repository " + this.testRepository);
        this.connectWagon(wagon);
        wagon.get(this.resource, this.destFile);
        this.disconnectWagon(wagon);
        this.verifyMock(progressAnswer, expectedSize);
    }

    protected void verifyMock(ProgressAnswer progressAnswer, int length) {
        EasyMock.verify((Object[])new Object[]{this.mockTransferListener});
        WagonTestCase.assertEquals((int)length, (int)progressAnswer.getSize());
        EasyMock.reset((Object[])new Object[]{this.mockTransferListener});
    }

    protected void disconnectWagon(Wagon wagon) throws ConnectionException {
        wagon.removeTransferListener(this.mockTransferListener);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void connectWagon(Wagon wagon) throws ConnectionException, AuthenticationException {
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.addTransferListener(this.mockTransferListener);
        wagon.connect(this.testRepository, this.getAuthInfo());
    }

    protected boolean assertOnTransferProgress() {
        return false;
    }

    protected ProgressAnswer replaceMockForGet(Wagon wagon, int expectedSize) {
        Resource resource = new Resource(this.resource);
        this.mockTransferListener.transferInitiated(this.createTransferEvent(wagon, resource, 0, 5, this.destFile));
        resource = new Resource(this.resource);
        resource.setContentLength((long)this.getExpectedContentLengthOnGet(expectedSize));
        resource.setLastModified(this.getExpectedLastModifiedOnGet(this.testRepository, resource));
        TransferEvent te = this.createTransferEvent(wagon, resource, 1, 5, null);
        this.mockTransferListener.transferStarted(te);
        this.mockTransferListener.transferProgress((TransferEvent)EasyMock.eq((Object)new TransferEvent(wagon, resource, 3, 5)), (byte[])EasyMock.anyObject(byte[].class), EasyMock.anyInt());
        ProgressAnswer progressAnswer = new ProgressAnswer();
        if (this.assertOnTransferProgress()) {
            EasyMock.expectLastCall().andAnswer((IAnswer)progressAnswer);
        } else {
            EasyMock.expectLastCall().andAnswer((IAnswer)progressAnswer);
            EasyMock.expectLastCall().anyTimes();
        }
        this.mockTransferListener.debug(EasyMock.anyString());
        EasyMock.expectLastCall().anyTimes();
        this.mockTransferListener.transferCompleted(this.createTransferEvent(wagon, resource, 2, 5, this.destFile));
        EasyMock.replay((Object[])new Object[]{this.mockTransferListener});
        return progressAnswer;
    }

    protected int getExpectedContentLengthOnGet(int expectedSize) {
        return expectedSize;
    }

    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        return this.sourceFile.lastModified();
    }

    protected void fileRoundTripTesting() throws Exception {
        this.message("File round trip testing ...");
        int expectedSize = this.putFile();
        WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        WagonTestCase.assertEquals((String)"compare checksums", (String)TEST_CKSUM, (String)this.checksumObserver.getActualChecksum());
        this.checksumObserver = new ChecksumObserver();
        this.getFile(expectedSize);
        WagonTestCase.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        WagonTestCase.assertEquals((String)"compare checksums", (String)TEST_CKSUM, (String)this.checksumObserver.getActualChecksum());
        String sourceContent = FileUtils.fileRead((File)this.sourceFile);
        String destContent = FileUtils.fileRead((File)this.destFile);
        WagonTestCase.assertEquals((String)sourceContent, (String)destContent);
    }

    protected Repository createFileRepository(String url) {
        File path = new File(url.substring(7));
        path.mkdirs();
        Repository repository = new Repository();
        repository.setUrl(url);
        return repository;
    }

    protected static String cksum(String content) {
        String checkSum;
        try {
            ChecksumObserver obs = new ChecksumObserver();
            byte[] buf = content.getBytes(StandardCharsets.ISO_8859_1);
            obs.transferProgress(null, buf, buf.length);
            obs.transferCompleted(null);
            checkSum = obs.getActualChecksum();
        }
        catch (Exception e) {
            checkSum = null;
        }
        return checkSum;
    }

    static final class ProgressAnswer
    implements IAnswer {
        private int size;

        ProgressAnswer() {
        }

        public Object answer() throws Throwable {
            int length = (Integer)EasyMock.getCurrentArguments()[2];
            this.size += length;
            return null;
        }

        public int getSize() {
            return this.size;
        }
    }
}

