/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.StreamingWagonTestCase;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;

public abstract class HttpWagonTestCase
extends StreamingWagonTestCase {
    public static final int SC_TOO_MANY_REQUESTS = 429;
    private Server server;
    private ServerConnector connector;

    protected int getLocalPort(Server server) {
        Connector connector = server.getConnectors()[0];
        return ((ServerConnector)connector).getLocalPort();
    }

    @Override
    protected void setupWagonTestingFixtures() throws Exception {
        File file = FileTestUtils.createUniqueFile("local-repository", "test-resource");
        file.delete();
        file.getParentFile().mkdirs();
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        this.server = new Server();
        this.connector = this.addConnector(this.server);
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        ServletContextHandler context = this.createContext(this.server, repositoryDirectory);
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)putHandler);
        handlers.addHandler((Handler)context);
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    protected final int getTestRepositoryPort() {
        if (this.server == null) {
            return 0;
        }
        return this.connector.getLocalPort();
    }

    protected ServletContextHandler createContext(Server server, File repositoryDirectory) throws IOException {
        ServletContextHandler root = new ServletContextHandler(1);
        root.setResourceBase(repositoryDirectory.getAbsolutePath());
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
        return root;
    }

    @Override
    protected void tearDownWagonTestingFixtures() throws Exception {
        this.server.stop();
    }

    public void testHttpHeaders() throws Exception {
        Properties headers = new Properties();
        headers.setProperty("User-Agent", "Maven-Wagon/1.0");
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        this.setHttpConfiguration(wagon, headers, new Properties());
        Server server = new Server();
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        ServerConnector serverConnector = this.addConnector(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + serverConnector.getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"Maven-Wagon/1.0", (String)handler.headers.get("User-Agent"));
    }

    public void testHttpHeadersWithCommonMethods() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("User-Agent", "Maven-Wagon/1.0");
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
        setHttpHeaders.invoke((Object)wagon, properties);
        Server server = new Server();
        ServerConnector serverConnector = this.addConnector(server);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnector(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + serverConnector.getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"Maven-Wagon/1.0", (String)handler.headers.get("User-Agent"));
    }

    public void testUserAgentHeaderIsPresentByDefault() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server();
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnector(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + this.getLocalPort(server)));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertNotNull((String)"default User-Agent header of wagon provider should be present", (Object)handler.headers.get("User-Agent"));
    }

    public void testUserAgentHeaderIsPresentOnlyOnceIfSetMultipleTimes() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Properties headers1 = new Properties();
        headers1.setProperty("User-Agent", "test-user-agent");
        this.setHttpConfiguration(wagon, headers1, new Properties());
        Properties headers2 = new Properties();
        headers2.setProperty("User-Agent", "test-user-agent");
        Method setHttpHeaders = wagon.getClass().getMethod("setHttpHeaders", Properties.class);
        setHttpHeaders.invoke((Object)wagon, headers2);
        Server server = new Server();
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnector(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + this.getLocalPort(server)));
        wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((String)"test-user-agent", (String)handler.headers.get("User-Agent"));
    }

    protected abstract void setHttpConfiguration(StreamingWagon var1, Properties var2, Properties var3);

    protected ServerConnector addConnector(Server server) {
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
        server.addConnector((Connector)serverConnector);
        return serverConnector;
    }

    protected String getRepositoryUrl(Server server) {
        int localPort = this.getLocalPort(server);
        return this.getProtocol() + "://localhost:" + localPort;
    }

    public void testGetForbidden() throws Exception {
        try {
            this.runTestGet(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testGet404() throws Exception {
        try {
            this.runTestGet(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testGet500() throws Exception {
        try {
            this.runTestGet(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    private void runTestGet(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = this.createStatusServer(status);
        server.start();
        String baseUrl = this.getRepositoryUrl(server);
        String resourceName = "resource";
        String serverReasonPhrase = HttpStatus.getCode((int)status).getMessage();
        wagon.connect(new Repository("id", baseUrl));
        try {
            wagon.getToStream("resource", (OutputStream)new ByteArrayOutputStream());
            HttpWagonTestCase.fail();
        }
        catch (Exception e) {
            this.verifyWagonExceptionMessage(e, status, baseUrl + "/" + resourceName, serverReasonPhrase);
            throw e;
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    public void testResourceExistsForbidden() throws Exception {
        try {
            this.runTestResourceExists(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists404() throws Exception {
        try {
            HttpWagonTestCase.assertFalse((boolean)this.runTestResourceExists(404));
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists500() throws Exception {
        try {
            this.runTestResourceExists(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceExists429() throws Exception {
        try {
            final AtomicBoolean called = new AtomicBoolean();
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (called.get()) {
                        response.setStatus(500);
                        baseRequest.setHandled(true);
                    } else {
                        called.set(true);
                        response.setStatus(429);
                        baseRequest.setHandled(true);
                    }
                }
            };
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Server server = new Server();
            server.setHandler((Handler)handler);
            this.addConnector(server);
            server.start();
            wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
            try {
                wagon.resourceExists("resource");
            }
            finally {
                wagon.disconnect();
                server.stop();
            }
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestResourceExists(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = this.createStatusServer(status);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        try {
            boolean bl = wagon.resourceExists("resource");
            return bl;
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    @Override
    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        File file = new File(this.getRepositoryDirectory(), resource.getName());
        return file.lastModified() / 1000L * 1000L;
    }

    protected File getRepositoryDirectory() {
        return HttpWagonTestCase.getTestFile((String)"target/test-output/http-repository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGzipGet() throws Exception {
        Server server = new Server();
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        ServletContextHandler root = new ServletContextHandler(1);
        root.setResourceBase(localRepositoryPath);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        servletHolder.setInitParameter("gzip", "true");
        root.addServlet(servletHolder, "/*");
        this.addConnector(server);
        server.setHandler((Handler)root);
        server.start();
        try {
            Wagon wagon = this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath + "/gzip");
            sourceFile.deleteOnExit();
            String resName = "gzip-res.txt";
            String sourceContent = this.writeTestFile(sourceFile, resName, "gzip");
            wagon.connect(testRepository);
            File destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            destFile.deleteOnExit();
            wagon.get("gzip/" + resName, destFile);
            wagon.disconnect();
            String destContent = FileUtils.fileRead((File)destFile);
            HttpWagonTestCase.assertEquals((String)sourceContent, (String)destContent);
        }
        finally {
            server.stop();
        }
    }

    public void testProxiedRequest() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        TestHeaderHandler handler = new TestHeaderHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
    }

    public void testProxiedRequestWithAuthentication() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        proxyInfo.setUserName("user");
        proxyInfo.setPassword("secret");
        AuthorizingProxyHandler handler = new AuthorizingProxyHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
        HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Authorization"));
        if (this.supportProxyPreemptiveAuthentication()) {
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((int)407, (int)handler.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    public void testProxiedRequestWithAuthenticationWithProvider() throws Exception {
        final ProxyInfo proxyInfo = this.createProxyInfo();
        proxyInfo.setUserName("user");
        proxyInfo.setPassword("secret");
        AuthorizingProxyHandler handler = new AuthorizingProxyHandler();
        ProxyInfoProvider proxyInfoProvider = new ProxyInfoProvider(){

            public ProxyInfo getProxyInfo(String protocol) {
                return proxyInfo;
            }
        };
        this.runTestProxiedRequestWithProvider(proxyInfoProvider, handler);
        HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Authorization"));
        if (this.supportProxyPreemptiveAuthentication()) {
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((int)407, (int)handler.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)200, (int)handler.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectGetToStream() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server realServer = new Server();
        TestHeaderHandler handler = new TestHeaderHandler();
        realServer.setHandler((Handler)handler);
        this.addConnector(realServer);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + this.getLocalPort(realServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, redirectUrl, null);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(redirectServer)));
        File tmpResult = File.createTempFile("foo", "get");
        try (FileOutputStream fileOutputStream = new FileOutputStream(tmpResult);){
            wagon.getToStream("resource", (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            String found = FileUtils.fileRead((File)tmpResult);
            HttpWagonTestCase.assertEquals((String)("found:'" + found + "'"), (String)"Hello, World!", (String)found);
            this.checkHandlerResult(redirectHandler.handlerRequestResponses, 303);
            this.checkHandlerResult(handler.handlerRequestResponses, 200);
        }
        finally {
            wagon.disconnect();
            redirectServer.stop();
            realServer.stop();
            tmpResult.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectGet() throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server realServer = new Server();
        TestHeaderHandler handler = new TestHeaderHandler();
        realServer.setHandler((Handler)handler);
        this.addConnector(realServer);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + this.getLocalPort(realServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, redirectUrl, null);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(redirectServer)));
        File tmpResult = File.createTempFile("foo", "get");
        try {
            wagon.get("resource", tmpResult);
            String found = FileUtils.fileRead((File)tmpResult);
            HttpWagonTestCase.assertEquals((String)("found:'" + found + "'"), (String)"Hello, World!", (String)found);
            this.checkHandlerResult(redirectHandler.handlerRequestResponses, 303);
            this.checkHandlerResult(handler.handlerRequestResponses, 200);
        }
        finally {
            wagon.disconnect();
            redirectServer.stop();
            realServer.stop();
            tmpResult.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFromStreamWithFullUrl() throws Exception {
        Server realServer = new Server();
        this.addConnector(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + this.getLocalPort(realServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, redirectUrl, repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
                this.checkRequestResponseForRedirectPutWithFullUrl(redirectHandler, putHandler);
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    protected void checkRequestResponseForRedirectPutWithFullUrl(RedirectHandler redirectHandler, PutHandler putHandler) {
        this.checkHandlerResult(redirectHandler.handlerRequestResponses, 303);
        this.checkHandlerResult(putHandler.handlerRequestResponses, 201);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFromStreamRelativeUrl() throws Exception {
        Server realServer = new Server();
        this.addConnector(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, "/redirectRequest/foo", repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "/redirectRequest/foo/test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
                this.checkRequestResponseForRedirectPutWithRelativeUrl(redirectHandler, putHandler);
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    protected void checkRequestResponseForRedirectPutWithRelativeUrl(RedirectHandler redirectHandler, PutHandler putHandler) {
        this.checkHandlerResult(redirectHandler.handlerRequestResponses, 303, 201);
        this.checkHandlerResult(putHandler.handlerRequestResponses, new int[0]);
    }

    protected void checkHandlerResult(List<HandlerRequestResponse> handlerRequestResponses, int ... expectedResponseCodes) {
        boolean success = true;
        if (handlerRequestResponses.size() == expectedResponseCodes.length) {
            for (int i = 0; i < expectedResponseCodes.length; ++i) {
                success &= expectedResponseCodes[i] == handlerRequestResponses.get((int)i).responseCode;
            }
        }
        if (!success) {
            HttpWagonTestCase.fail((String)("expected " + expectedResponseCodes + ", got " + handlerRequestResponses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFileWithFullUrl() throws Exception {
        Server realServer = new Server();
        this.addConnector(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        String protocol = this.getProtocol();
        if (protocol.equals("dav")) {
            protocol = "http";
        }
        if (protocol.equals("davs")) {
            protocol = "https";
        }
        String redirectUrl = protocol + "://localhost:" + this.getLocalPort(realServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, redirectUrl, repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try {
                wagon.put(tempFile, "test-secured-put-resource");
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
                this.checkRequestResponseForRedirectPutWithFullUrl(redirectHandler, putHandler);
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFileRelativeUrl() throws Exception {
        Server realServer = new Server();
        this.addConnector(realServer);
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        realServer.setHandler((Handler)putHandler);
        realServer.start();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, "/redirectRequest/foo", repositoryDirectory);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "/redirectRequest/foo/test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try {
                wagon.put(tempFile, "test-secured-put-resource");
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
                this.checkRequestResponseForRedirectPutWithRelativeUrl(redirectHandler, putHandler);
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
        }
        finally {
            realServer.stop();
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectPutFailureNonRepeatableStream() throws Exception {
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        Server redirectServer = new Server();
        this.addConnector(redirectServer);
        RedirectHandler redirectHandler = new RedirectHandler("See Other", 303, "/redirectRequest/foo", null);
        redirectServer.setHandler((Handler)redirectHandler);
        redirectServer.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Properties params = new Properties();
            params.put("http.protocol.expect-continue", "%b,false");
            this.setHttpConfiguration(wagon, new Properties(), params);
            Repository repository = new Repository("foo", this.getRepositoryUrl(redirectServer));
            wagon.connect(repository);
            File sourceFile = new File(repositoryDirectory, "/redirectRequest/foo/test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            String content = "put top secret";
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
            try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
                if (wagon.getClass().getName().contains("Lightweight")) {
                    HttpWagonTestCase.assertTrue((boolean)true);
                } else {
                    HttpWagonTestCase.fail();
                }
            }
            catch (TransferFailedException e) {
                HttpWagonTestCase.assertTrue((boolean)true);
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
        }
        finally {
            redirectServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestProxiedRequest(ProxyInfo proxyInfo, TestHeaderHandler handler) throws Exception {
        Thread.sleep(5001L);
        Server proxyServer = new Server();
        ServerConnector serverConnector = new ServerConnector(proxyServer, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
        proxyServer.addConnector((Connector)serverConnector);
        proxyServer.setHandler((Handler)handler);
        proxyServer.start();
        proxyInfo.setPort(this.getLocalPort(proxyServer));
        System.out.println("start proxy on host/port " + proxyInfo.getHost() + "/" + proxyInfo.getPort() + " with non proxyHosts " + proxyInfo.getNonProxyHosts());
        while (!proxyServer.isRunning() || !proxyServer.isStarted()) {
            Thread.sleep(10L);
        }
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", "http://www.example.com/");
            String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
            File sourceFile = new File(localRepositoryPath, "test-proxied-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"content");
            wagon.connect(testRepository, proxyInfo);
            try {
                wagon.getToStream("test-proxied-resource", (OutputStream)new ByteArrayOutputStream());
                HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Connection"));
            }
            finally {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                wagon.disconnect();
            }
        }
        finally {
            proxyServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestProxiedRequestWithProvider(ProxyInfoProvider proxyInfoProvider, TestHeaderHandler handler) throws Exception {
        Thread.sleep(5001L);
        Server proxyServer = new Server();
        ServerConnector serverConnector = new ServerConnector(proxyServer, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
        proxyServer.addConnector((Connector)serverConnector);
        proxyServer.setHandler((Handler)handler);
        proxyServer.start();
        proxyInfoProvider.getProxyInfo(null).setPort(this.getLocalPort(proxyServer));
        System.out.println("start proxy on host/port " + proxyInfoProvider.getProxyInfo(null).getHost() + "/" + proxyInfoProvider.getProxyInfo(null).getPort() + " with non proxyHosts " + proxyInfoProvider.getProxyInfo(null).getNonProxyHosts());
        while (!proxyServer.isRunning() || !proxyServer.isStarted()) {
            Thread.sleep(10L);
        }
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", "http://www.example.com/");
            String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
            File sourceFile = new File(localRepositoryPath, "test-proxied-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"content");
            wagon.connect(testRepository, proxyInfoProvider);
            try {
                wagon.getToStream("test-proxied-resource", (OutputStream)new ByteArrayOutputStream());
                HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Connection"));
            }
            finally {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                wagon.disconnect();
            }
        }
        finally {
            proxyServer.stop();
        }
    }

    private ProxyInfo createProxyInfo() {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost("localhost");
        proxyInfo.setNonProxyHosts(null);
        proxyInfo.setType("http");
        return proxyInfo;
    }

    public void testSecuredGetUnauthorized() throws Exception {
        try {
            this.runTestSecuredGet(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGetWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredGet(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGet() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredGet(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredGet(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            File file = File.createTempFile("wagon-test", "txt");
            try {
                wagon.get("test-secured-resource", file);
            }
            finally {
                wagon.disconnect();
            }
            FileInputStream in = new FileInputStream(file);
            HttpWagonTestCase.assertEquals((String)"top secret", (String)IOUtil.toString((InputStream)in));
            Thread.sleep(2000L);
            TestSecurityHandler securityHandler = (TestSecurityHandler)server.getChildHandlerByClass(TestSecurityHandler.class);
            this.testPreemptiveAuthenticationGet(securityHandler, this.supportPreemptiveAuthenticationGet());
        }
        finally {
            server.stop();
        }
    }

    public void testSecuredGetToStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredGetToStream(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredGetToStream(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                wagon.getToStream("test-secured-resource", (OutputStream)out);
            }
            finally {
                wagon.disconnect();
            }
            HttpWagonTestCase.assertEquals((String)"top secret", (String)out.toString("US-ASCII"));
            Thread.sleep(2000L);
            TestSecurityHandler securityHandler = (TestSecurityHandler)server.getChildHandlerByClass(TestSecurityHandler.class);
            this.testPreemptiveAuthenticationGet(securityHandler, this.supportPreemptiveAuthenticationGet());
        }
        finally {
            server.stop();
        }
    }

    public void testSecuredResourceExistsUnauthorized() throws Exception {
        try {
            this.runTestSecuredResourceExists(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExistsWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredResourceExists(authInfo);
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExists() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredResourceExists(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredResourceExists(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource-exists");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            try {
                HttpWagonTestCase.assertTrue((boolean)wagon.resourceExists("test-secured-resource-exists"));
                HttpWagonTestCase.assertFalse((boolean)wagon.resourceExists("test-secured-resource-not-exists"));
            }
            finally {
                wagon.disconnect();
            }
        }
        finally {
            server.stop();
        }
    }

    private Server createSecurityServer(String localRepositoryPath) {
        Server server = new Server();
        TestSecurityHandler sh = this.createSecurityHandler();
        ServletContextHandler root = new ServletContextHandler(3);
        root.setResourceBase(localRepositoryPath);
        root.setSecurityHandler((SecurityHandler)sh);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
        server.setHandler((Handler)root);
        this.addConnector(server);
        return server;
    }

    private Server createStatusServer(int status) {
        Server server = new Server();
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnector(server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeTestFile(File parent, String child, String compressionType) throws IOException {
        String content;
        File file = new File(parent, child);
        file.getParentFile().mkdirs();
        file.deleteOnExit();
        try (OutputStream out = new FileOutputStream(file);){
            out.write(child.getBytes());
        }
        String ext = "";
        if ("gzip".equals(compressionType)) {
            ext = ".gz";
        }
        if ("deflate".equals(compressionType)) {
            ext = ".deflate";
        }
        file = new File(parent, child + ext);
        file.deleteOnExit();
        out = new FileOutputStream(file);
        if ("gzip".equals(compressionType)) {
            out = new GZIPOutputStream(out);
        }
        if ("deflate".equals(compressionType)) {
            out = new DeflaterOutputStream(out);
        }
        try {
            content = file.getAbsolutePath();
            out.write(content.getBytes());
        }
        finally {
            out.close();
        }
        return content;
    }

    public void testPutForbidden() throws Exception {
        try {
            this.runTestPut(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut404() throws Exception {
        try {
            this.runTestPut(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut500() throws Exception {
        try {
            this.runTestPut(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPut429() throws Exception {
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Server server = new Server();
            final AtomicBoolean called = new AtomicBoolean();
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (called.get()) {
                        response.setStatus(500);
                        baseRequest.setHandled(true);
                    } else {
                        called.set(true);
                        response.setStatus(429);
                        baseRequest.setHandled(true);
                    }
                }
            };
            server.setHandler((Handler)handler);
            this.addConnector(server);
            server.start();
            wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"content");
            try {
                wagon.put(tempFile, "resource");
                HttpWagonTestCase.fail();
            }
            finally {
                wagon.disconnect();
                server.stop();
                tempFile.delete();
            }
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    private void runTestPut(int status) throws Exception {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = this.createStatusServer(status);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        File tempFile = File.createTempFile("wagon", "tmp");
        tempFile.deleteOnExit();
        FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"content");
        String baseUrl = this.getRepositoryUrl(server);
        String resourceName = "resource";
        String serverReasonPhrase = HttpStatus.getCode((int)status).getMessage();
        try {
            wagon.put(tempFile, resourceName);
            HttpWagonTestCase.fail();
        }
        catch (Exception e) {
            this.verifyWagonExceptionMessage(e, status, baseUrl + "/" + resourceName, serverReasonPhrase);
            throw e;
        }
        finally {
            wagon.disconnect();
            server.stop();
            tempFile.delete();
        }
    }

    public void testSecuredPutUnauthorized() throws Exception {
        try {
            this.runTestSecuredPut(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPutWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredPut(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPut() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPut(authInfo);
    }

    public void runTestSecuredPut(AuthenticationInfo authInfo) throws Exception {
        this.runTestSecuredPut(authInfo, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredPut(AuthenticationInfo authInfo, int putNumber) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = new Server();
        TestSecurityHandler sh = this.createSecurityHandler();
        PutHandler putHandler = new PutHandler(new File(localRepositoryPath));
        sh.setHandler((Handler)putHandler);
        server.setHandler((Handler)sh);
        this.addConnector(server);
        server.start();
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
        wagon.connect(testRepository, authInfo);
        try {
            for (int i = 0; i < putNumber; ++i) {
                File sourceFile = new File(localRepositoryPath, "test-secured-put-resource");
                sourceFile.delete();
                HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
                File tempFile = File.createTempFile("wagon", "tmp");
                tempFile.deleteOnExit();
                FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"put top secret");
                try {
                    wagon.put(tempFile, "test-secured-put-resource");
                }
                finally {
                    tempFile.delete();
                }
                HttpWagonTestCase.assertEquals((String)"put top secret", (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            }
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
        HttpWagonTestCase.assertEquals((int)putNumber, (int)putHandler.putCallNumber);
        this.testPreemptiveAuthenticationPut(sh, this.supportPreemptiveAuthenticationPut());
    }

    public void testNonSecuredPutFromStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPutFromStream(authInfo, 1, false);
    }

    public void testSecuredPutFromStream() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPutFromStream(authInfo, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredPutFromStream(AuthenticationInfo authInfo, int putNumber, boolean addSecurityHandler) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = new Server();
        TestSecurityHandler sh = this.createSecurityHandler();
        PutHandler putHandler = new PutHandler(new File(localRepositoryPath));
        if (addSecurityHandler) {
            sh.setHandler((Handler)putHandler);
            server.setHandler((Handler)sh);
        } else {
            server.setHandler((Handler)putHandler);
        }
        this.addConnector(server);
        server.start();
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
        if (addSecurityHandler) {
            wagon.connect(testRepository, authInfo);
        } else {
            wagon.connect(testRepository);
        }
        try {
            for (int i = 0; i < putNumber; ++i) {
                File sourceFile = new File(localRepositoryPath, "test-secured-put-resource");
                sourceFile.delete();
                HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
                File tempFile = File.createTempFile("wagon", "tmp");
                tempFile.deleteOnExit();
                String content = "put top secret";
                FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)content);
                try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                    wagon.putFromStream((InputStream)fileInputStream, "test-secured-put-resource", (long)content.length(), -1L);
                }
                finally {
                    tempFile.delete();
                }
                HttpWagonTestCase.assertEquals((String)content, (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
            }
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
        HttpWagonTestCase.assertEquals((int)putNumber, (int)putHandler.putCallNumber);
        if (addSecurityHandler) {
            this.testPreemptiveAuthenticationPut(sh, this.supportPreemptiveAuthenticationPut());
        }
        for (DeployedResource deployedResource : putHandler.deployedResources) {
            if (!StringUtils.equalsIgnoreCase((String)"chunked", (String)deployedResource.transferEncoding)) continue;
            HttpWagonTestCase.fail((String)("deployedResource use chunked: " + deployedResource));
        }
    }

    protected abstract boolean supportPreemptiveAuthenticationPut();

    protected abstract boolean supportPreemptiveAuthenticationGet();

    protected abstract boolean supportProxyPreemptiveAuthentication();

    protected void testPreemptiveAuthenticationGet(TestSecurityHandler sh, boolean preemptive) {
        this.testPreemptiveAuthentication(sh, preemptive, 200);
    }

    protected void testPreemptiveAuthenticationPut(TestSecurityHandler sh, boolean preemptive) {
        this.testPreemptiveAuthentication(sh, preemptive, 201);
    }

    protected void testPreemptiveAuthentication(TestSecurityHandler sh, boolean preemptive, int statusCode) {
        if (preemptive) {
            HttpWagonTestCase.assertEquals((String)("not 1 security handler use " + sh.handlerRequestResponses), (int)1, (int)sh.handlerRequestResponses.size());
            HttpWagonTestCase.assertEquals((int)statusCode, (int)sh.handlerRequestResponses.get((int)0).responseCode);
        } else {
            HttpWagonTestCase.assertEquals((String)("not 2 security handler use " + sh.handlerRequestResponses), (int)2, (int)sh.handlerRequestResponses.size());
            HttpWagonTestCase.assertEquals((int)401, (int)sh.handlerRequestResponses.get((int)0).responseCode);
            HttpWagonTestCase.assertEquals((int)statusCode, (int)sh.handlerRequestResponses.get((int)1).responseCode);
        }
    }

    protected TestSecurityHandler createSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"admin"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        TestSecurityHandler sh = new TestSecurityHandler();
        HashLoginService hashLoginService = new HashLoginService("MyRealm");
        hashLoginService.putUser("user", (Credential)new Password("secret"), new String[]{"admin"});
        sh.setLoginService((LoginService)hashLoginService);
        sh.setConstraintMappings(new ConstraintMapping[]{cm});
        sh.setAuthenticator((Authenticator)new BasicAuthenticator());
        return sh;
    }

    protected void verifyWagonExceptionMessage(Exception e, int forStatusCode, String forUrl, String forReasonPhrase) {
        HttpWagonTestCase.assertNotNull((Object)e);
        try {
            HttpWagonTestCase.assertTrue((String)"only verify instances of WagonException", (boolean)(e instanceof WagonException));
            String assertMessageForBadMessage = "exception message not described properly";
            switch (forStatusCode) {
                case 404: {
                    HttpWagonTestCase.assertTrue((String)"404 not found response should throw ResourceDoesNotExistException", (boolean)(e instanceof ResourceDoesNotExistException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Not Found" : " " + forReasonPhrase;
                    HttpWagonTestCase.assertEquals((String)assertMessageForBadMessage, (String)("resource missing at " + forUrl + ", status: 404" + reasonPhrase), (String)e.getMessage());
                    break;
                }
                case 401: {
                    HttpWagonTestCase.assertTrue((String)"401 Unauthorized should throw AuthorizationException since  AuthenticationException is not explicitly declared as thrown from wagon methods", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Unauthorized" : " " + forReasonPhrase;
                    HttpWagonTestCase.assertEquals((String)assertMessageForBadMessage, (String)("authentication failed for " + forUrl + ", status: 401" + reasonPhrase), (String)e.getMessage());
                    break;
                }
                case 407: {
                    HttpWagonTestCase.assertTrue((String)"407 Proxy authentication required should throw AuthorizationException", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Proxy Authentication Required" : " " + forReasonPhrase;
                    HttpWagonTestCase.assertEquals((String)assertMessageForBadMessage, (String)("proxy authentication failed for " + forUrl + ", status: 407" + reasonPhrase), (String)e.getMessage());
                    break;
                }
                case 403: {
                    HttpWagonTestCase.assertTrue((String)"403 Forbidden should throw AuthorizationException", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Forbidden" : " " + forReasonPhrase;
                    HttpWagonTestCase.assertEquals((String)assertMessageForBadMessage, (String)("authorization failed for " + forUrl + ", status: 403" + reasonPhrase), (String)e.getMessage());
                    break;
                }
                default: {
                    HttpWagonTestCase.assertTrue((String)"transfer failures should at least be wrapped in a TransferFailedException", (boolean)(e instanceof TransferFailedException));
                    HttpWagonTestCase.assertTrue((String)"expected status code for transfer failures should be >= 400", (forStatusCode >= 400 ? 1 : 0) != 0);
                    String reasonPhrase = forReasonPhrase == null ? "" : " " + forReasonPhrase;
                    HttpWagonTestCase.assertEquals((String)assertMessageForBadMessage, (String)("transfer failed for " + forUrl + ", status: " + forStatusCode + reasonPhrase), (String)e.getMessage());
                    break;
                }
            }
        }
        catch (AssertionError assertionError) {
            logger.error("Exception which failed assertions: ", (Throwable)e);
            throw assertionError;
        }
    }

    public static class HandlerRequestResponse {
        public String method;
        public int responseCode;
        public String requestUri;

        private HandlerRequestResponse(String method, int responseCode, String requestUri) {
            this.method = method;
            this.responseCode = responseCode;
            this.requestUri = requestUri;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("HandlerRequestResponse");
            sb.append("{method='").append(this.method).append('\'');
            sb.append(", responseCode=").append(this.responseCode);
            sb.append(", requestUri='").append(this.requestUri).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class TestSecurityHandler
    extends ConstraintSecurityHandler {
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String method = request.getMethod();
            super.handle(target, baseRequest, request, response);
            this.handlerRequestResponses.add(new HandlerRequestResponse(method, ((Response)response).getStatus(), request.getRequestURI()));
        }
    }

    private static class TestHeaderHandler
    extends AbstractHandler {
        public Map<String, String> headers = Collections.emptyMap();
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        TestHeaderHandler() {
        }

        public void handle(String target, Request baseRrequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.headers = new HashMap<String, String>();
            Enumeration e = baseRrequest.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Enumeration headerValues = baseRrequest.getHeaders(name);
                StringBuffer combinedHeaderValue = new StringBuffer();
                int i = 0;
                while (headerValues.hasMoreElements()) {
                    if (i > 0) {
                        combinedHeaderValue.append(",");
                    }
                    combinedHeaderValue.append(headerValues.nextElement());
                    ++i;
                }
                this.headers.put(name, combinedHeaderValue.toString());
            }
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getWriter().print("Hello, World!");
            this.handlerRequestResponses.add(new HandlerRequestResponse(baseRrequest.getMethod(), ((Response)response).getStatus(), baseRrequest.getRequestURI()));
            baseRrequest.setHandled(true);
        }
    }

    private static class AuthorizingProxyHandler
    extends TestHeaderHandler {
        List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        private AuthorizingProxyHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            System.out.println(" handle proxy request");
            if (request.getHeader("Proxy-Authorization") == null) {
                this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), 407, request.getRequestURI()));
                response.setStatus(407);
                response.addHeader("Proxy-Authenticate", "Basic realm=\"Squid proxy-caching web server\"");
                baseRequest.setHandled(true);
                return;
            }
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), 200, request.getRequestURI()));
            super.handle(target, baseRequest, request, response);
        }
    }

    public static class PutHandler
    extends AbstractHandler {
        private final File resourceBase;
        public List<DeployedResource> deployedResources = new ArrayList<DeployedResource>();
        public int putCallNumber = 0;
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        public PutHandler(File repositoryDirectory) {
            this.resourceBase = repositoryDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (baseRequest.isHandled() || !"PUT".equals(baseRequest.getMethod())) {
                return;
            }
            baseRequest.setHandled(true);
            File file = new File(this.resourceBase, URLDecoder.decode(request.getPathInfo()));
            file.getParentFile().mkdirs();
            FileOutputStream out = null;
            ServletInputStream in = null;
            try {
                in = request.getInputStream();
                out = new FileOutputStream(file);
                IOUtil.copy((InputStream)in, (OutputStream)out);
                ((OutputStream)out).close();
                out = null;
                in.close();
                in = null;
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)in);
                IOUtil.close(out);
                throw throwable;
            }
            IOUtil.close((InputStream)in);
            IOUtil.close((OutputStream)out);
            ++this.putCallNumber;
            DeployedResource deployedResource = new DeployedResource();
            deployedResource.httpMethod = request.getMethod();
            deployedResource.requestUri = request.getRequestURI();
            deployedResource.transferEncoding = request.getHeader("Transfer-Encoding");
            deployedResource.contentLength = request.getHeader("Content-Length");
            this.deployedResources.add(deployedResource);
            response.setStatus(201);
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), ((Response)response).getStatus(), request.getRequestURI()));
        }
    }

    static class DeployedResource {
        String httpMethod;
        String requestUri;
        String contentLength;
        String transferEncoding;

        DeployedResource() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DeployedResource");
            sb.append("{httpMethod='").append(this.httpMethod).append('\'');
            sb.append(", requestUri='").append(this.requestUri).append('\'');
            sb.append(", contentLength='").append(this.contentLength).append('\'');
            sb.append(", transferEncoding='").append(this.transferEncoding).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    static class StatusHandler
    extends AbstractHandler {
        private int status;

        StatusHandler() {
        }

        public void setStatusToReturn(int status) {
            this.status = status;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.status != 0) {
                response.setStatus(this.status);
                baseRequest.setHandled(true);
            }
        }
    }

    public static class RedirectHandler
    extends AbstractHandler {
        String reason;
        int retCode;
        String redirectUrl;
        File repositoryDirectory;
        public List<HandlerRequestResponse> handlerRequestResponses = new ArrayList<HandlerRequestResponse>();

        RedirectHandler(String reason, int retCode, String redirectUrl, File repositoryDirectory) {
            this.reason = reason;
            this.retCode = retCode;
            this.redirectUrl = redirectUrl;
            this.repositoryDirectory = repositoryDirectory;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getRequestURI().contains("redirectRequest")) {
                PutHandler putHandler = new PutHandler(this.repositoryDirectory);
                putHandler.handle(target, baseRequest, request, response);
                this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), response.getStatus(), request.getRequestURI()));
                return;
            }
            response.setStatus(this.retCode);
            response.setHeader("Location", this.redirectUrl + request.getRequestURI());
            baseRequest.setHandled(true);
            this.handlerRequestResponses.add(new HandlerRequestResponse(request.getMethod(), response.getStatus(), request.getRequestURI()));
        }
    }
}

