/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http;

import org.apache.maven.wagon.Wagon;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class WagonTestCaseConfigurator
implements Contextualizable {
    private static final String UNSUPPORTED_ELEMENT = "unsupported";
    private PlexusConfiguration useCaseConfigs;
    private ComponentConfigurator configurator;
    private ClassRealm realm;
    private String wagonHint;

    public boolean isSupported(String useCaseId) {
        PlexusConfiguration config;
        if (this.useCaseConfigs != null && (config = this.useCaseConfigs.getChild(useCaseId, false)) != null && config.getChild(UNSUPPORTED_ELEMENT, false) != null) {
            System.out.println("Test case '" + useCaseId + "' is marked as unsupported by this wagon.");
            return false;
        }
        return true;
    }

    public boolean configureWagonForTest(Wagon wagon, String useCaseId) throws ComponentConfigurationException {
        if (this.useCaseConfigs != null) {
            PlexusConfiguration config = this.useCaseConfigs.getChild(useCaseId, false);
            if (config != null) {
                if (config.getChild(UNSUPPORTED_ELEMENT, false) != null) {
                    System.out.println("Test case '" + useCaseId + "' is marked as unsupported by this wagon.");
                    return false;
                }
                System.out.println("Configuring wagon for test case: " + useCaseId + " with:\n\n" + config);
                this.configurator.configureComponent((Object)wagon, this.useCaseConfigs.getChild(useCaseId, false), this.realm);
            } else {
                System.out.println("No wagon configuration found for test case: " + useCaseId);
            }
        } else {
            System.out.println("No test case configurations found.");
        }
        return true;
    }

    public void contextualize(Context context) throws ContextException {
        PlexusContainer container = (PlexusContainer)context.get((Object)"plexus");
        this.realm = container.getContainerRealm();
        try {
            this.configurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Failed to lookup component configurator: " + e.getMessage(), (Throwable)e);
        }
    }

    public PlexusConfiguration getUseCaseConfigs() {
        return this.useCaseConfigs;
    }

    public void setUseCaseConfigs(PlexusConfiguration useCaseConfigs) {
        this.useCaseConfigs = useCaseConfigs;
    }

    public String getWagonHint() {
        return this.wagonHint;
    }

    public void setWagonHint(String wagonHint) {
        this.wagonHint = wagonHint;
    }
}

