/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.tck.http.WagonTestCaseConfigurator;
import org.apache.maven.wagon.tck.http.fixture.ServerFixture;
import org.apache.maven.wagon.tck.http.util.TestUtil;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.util.FileUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpWagonTests {
    private ServerFixture serverFixture;
    private static PlexusContainer container;
    private Wagon wagon;
    private static WagonTestCaseConfigurator configurator;
    private String baseUrl;
    private static final Set<File> tmpFiles;
    private Repository repo;
    private final Set<Object> notificationTargets = new HashSet<Object>();
    protected static Logger logger;

    @Before
    public void beforeEach() throws Exception {
        this.serverFixture = new ServerFixture(this.isSsl());
        this.serverFixture.start();
        this.wagon = (Wagon)container.lookup(Wagon.ROLE, configurator.getWagonHint());
    }

    @BeforeClass
    public static void beforeAll() throws Exception {
        File keystore = TestUtil.getResource("ssl/keystore");
        System.setProperty("javax.net.ssl.keyStore", keystore.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "wagonhttp");
        System.setProperty("javax.net.ssl.trustStore", keystore.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", "wagonhttp");
        container = new DefaultPlexusContainer();
        configurator = (WagonTestCaseConfigurator)container.lookup(WagonTestCaseConfigurator.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        try {
            this.wagon.disconnect();
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        Iterator<Object> i$ = this.notificationTargets.iterator();
        while (i$.hasNext()) {
            Object obj;
            Object object = obj = i$.next();
            synchronized (object) {
                obj.notify();
            }
        }
        if (this.serverFixture != null) {
            try {
                this.serverFixture.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            container.release((Object)this.wagon);
        }
        catch (ComponentLifecycleException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void afterAll() {
        for (File f : tmpFiles) {
            if (!f.exists()) continue;
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (container != null) {
            try {
                container.release((Object)configurator);
            }
            catch (ComponentLifecycleException e) {
                e.printStackTrace();
            }
            container.dispose();
        }
    }

    protected void addNotificationTarget(Object target) {
        this.notificationTargets.add(target);
    }

    protected File newTempFile() throws IOException {
        File f = File.createTempFile("wagon-target.", ".file");
        f.deleteOnExit();
        return f;
    }

    protected boolean isSsl() {
        return false;
    }

    protected ProxyInfo newProxyInfo() {
        ProxyInfo info = new ProxyInfo();
        info.setType(this.isSsl() ? "https" : "http");
        info.setHost("localhost");
        info.setPort(this.getPort());
        return info;
    }

    protected boolean isSupported() {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String testCaseId = null;
        String lastMethodName = null;
        for (StackTraceElement e : elements) {
            if (!e.getClassName().startsWith(this.getClass().getPackage().getName())) {
                testCaseId = lastMethodName;
                break;
            }
            lastMethodName = e.getMethodName();
        }
        if (testCaseId == null || !configurator.isSupported(testCaseId)) {
            logger.error((Object)("Cannot run test: " + testCaseId + ". Wagon under test does not support this test case."));
            return false;
        }
        return true;
    }

    protected boolean initTest(AuthenticationInfo auth, ProxyInfo proxy) throws ComponentConfigurationException, ConnectionException, AuthenticationException {
        return this.initTest(this.getBaseUrl(), auth, proxy);
    }

    protected boolean initTest(String baseUrl, AuthenticationInfo auth, ProxyInfo proxy) throws ComponentConfigurationException, ConnectionException, AuthenticationException {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        String testCaseId = null;
        String lastMethodName = null;
        for (StackTraceElement e : elements) {
            if (!e.getClassName().startsWith(this.getClass().getPackage().getName())) {
                testCaseId = lastMethodName;
                break;
            }
            lastMethodName = e.getMethodName();
        }
        if (testCaseId == null || !configurator.configureWagonForTest(this.wagon, testCaseId)) {
            logger.error((Object)("Cannot run test: " + testCaseId + ". Wagon under test does not support this test case."));
            return false;
        }
        try {
            this.serverFixture.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start: " + e.getMessage(), e);
        }
        this.repo = new Repository("test", baseUrl);
        this.wagon.connect(this.repo, auth, proxy);
        return true;
    }

    protected int getPort() {
        return this.serverFixture.getHttpPort();
    }

    protected int getPortPropertyValue() {
        return Integer.parseInt(System.getProperty("test.port", "-1"));
    }

    protected String getBaseUrl() {
        if (this.baseUrl == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isSsl() ? "https" : "http");
            sb.append("://localhost:");
            sb.append(this.getPort());
            this.baseUrl = sb.toString();
        }
        return this.baseUrl;
    }

    protected ServerFixture getServerFixture() {
        return this.serverFixture;
    }

    protected static PlexusContainer getContainer() {
        return container;
    }

    protected Wagon getWagon() {
        return this.wagon;
    }

    protected static WagonTestCaseConfigurator getConfigurator() {
        return configurator;
    }

    protected static Set<File> getTmpfiles() {
        return tmpFiles;
    }

    protected Repository getRepo() {
        return this.repo;
    }

    static {
        tmpFiles = new HashSet<File>();
        logger = Logger.getLogger(HttpWagonTests.class);
    }
}

