/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.meecrowave.jpa.api.Jpa;
import org.apache.meecrowave.jpa.internal.JpaLiteral;

class AutoJpaAnnotationType<T>
implements AnnotatedType<T> {
    private final AnnotatedType<T> delegate;
    private final Set<Annotation> annotations = new HashSet<Annotation>();

    AutoJpaAnnotationType(AnnotatedType<T> delegate) {
        this.delegate = delegate;
        this.annotations.addAll(delegate.getAnnotations());
        this.annotations.add(JpaLiteral.DEFAULT);
    }

    public Class<T> getJavaClass() {
        return this.delegate.getJavaClass();
    }

    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.delegate.getConstructors();
    }

    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.delegate.getMethods();
    }

    public Set<AnnotatedField<? super T>> getFields() {
        return this.delegate.getFields();
    }

    public Type getBaseType() {
        return this.delegate.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.delegate.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return (T)Optional.ofNullable(this.delegate.getAnnotation(annotationType)).orElseGet(() -> annotationType == Jpa.class ? JpaLiteral.DEFAULT : null);
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType) || annotationType == Jpa.class;
    }
}

