/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;
import org.apache.meecrowave.junit5.AfterFirstInjection;
import org.apache.meecrowave.junit5.AfterLastTest;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class BaseLifecycle {
    BaseLifecycle() {
    }

    boolean isPerClass(ExtensionContext context) {
        return context.getTestInstanceLifecycle().map(it -> it.equals((Object)TestInstance.Lifecycle.PER_CLASS)).orElse(false);
    }

    LifecyleState onInjection(ExtensionContext context, LifecyleState state) {
        if (state != null && state.injected) {
            return state;
        }
        return context.getTestInstance().map(test -> BaseLifecycle.invoke(test, AfterFirstInjection.class)).orElse(state);
    }

    private static LifecyleState invoke(Object test, Class<? extends Annotation> marker) {
        for (Class<?> type = test.getClass(); type != Object.class; type = type.getSuperclass()) {
            Stream.of(type.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(marker)).forEach(method -> {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                try {
                    method.invoke(test, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalStateException(ite.getTargetException());
                }
            });
        }
        return new LifecyleState(true, test);
    }

    static class LifecyleState {
        private final boolean injected;
        private final Object instance;

        LifecyleState(boolean injected, Object instance) {
            this.injected = injected;
            this.instance = instance;
        }

        void afterLastTest(ExtensionContext context) {
            BaseLifecycle.invoke(this.instance, AfterLastTest.class);
        }
    }
}

